# Copilot Instructions for SkedWise

## Project Overview
SkedWise is a Laravel-based web application. The codebase follows standard Laravel conventions but includes custom business logic and integrations. Key directories:
- `app/Models/`: Eloquent models for business entities (e.g., `Business.php`, `Invoice.php`, `Staff.php`).
- `app/Http/Controllers/`: Route handlers and business logic. Controllers are grouped by domain.
- `routes/`: Route definitions (`web.php`, `api.php`, etc.).
- `resources/views/`: Blade templates for UI rendering.
- `config/`: Application configuration files.

## Architecture & Data Flow
- Follows MVC: Models (Eloquent), Controllers, Views (Blade).
- Controllers interact with models and return views or JSON responses.
- Business logic is often encapsulated in models or service classes (see `app/Models/` and `app/Http/Controllers/`).
- Middleware in `app/Http/Middleware/` handles authentication, authorization, and request preprocessing.

## Developer Workflows
- **Start local server:** `php artisan serve`
- **Run migrations:** `php artisan migrate`
- **Run tests:** `vendor\bin\phpunit` or `php artisan test`
- **Debugging:** Use Laravel's built-in logging (`storage/logs/`) and exception handling.
- **Front-end assets:** Managed via Vite (`vite.config.js`). Use `npm run dev` for hot-reloading.

## Project-Specific Patterns
- Models use Eloquent relationships (e.g., `hasMany`, `belongsTo`).
- Controllers may use Form Request classes from `app/Http/Requests/` for validation.
- Route model binding is common in controller methods.
- Business logic may be split between models and controllers; check both for domain rules.
- Custom configuration constants are in `config/constants.php`.

## Integration Points
- External dependencies managed via Composer (`composer.json`) and npm (`package.json`).
- Database: SQLite for local development (`database/database.sqlite`).
- Authentication: Laravel Sanctum (`config/sanctum.php`).
- API endpoints defined in `routes/api.php`.

## Conventions & Tips
- Use PSR-4 autoloading for classes.
- Blade templates are in `resources/views/` and use Laravel's Blade syntax.
- For new features, add migrations, models, controllers, and routes as needed.
- Use environment variables via `.env` for secrets and config.
- Tests are in `tests/Feature/` and `tests/Unit/`.

## Example: Adding a New Model
1. Create model: `php artisan make:model Example`
2. Add migration: `php artisan make:migration create_examples_table`
3. Update migration, run `php artisan migrate`
4. Add controller: `php artisan make:controller ExampleController`
5. Define routes in `routes/web.php` or `routes/api.php`

---
_If any section is unclear or missing, please provide feedback to improve these instructions._
