## SkedWise

SkedWise is a Laravel-based scheduling + operations web app (services, staff time blocks, visits/invoices, and customer messaging) built with a Blade/Vite frontend.

### Tech stack

- **Backend**: Laravel 11 (PHP 8.2+), Eloquent, Sanctum
- **Frontend**: Vite, SCSS, Tailwind, Alpine.js, Bootstrap 5
- **UI libraries**: FullCalendar, DataTables, Select2/Choices, ApexCharts
- **Background jobs**: Laravel Queue (default: `database`)
- **QR codes**: `simplesoftwareio/simple-qrcode`

### Getting started (local)

#### Prerequisites

- **PHP**: 8.2+
- **Composer**
- **Node.js**: 18+ (recommended) and npm
- **Database**: MySQL/MariaDB (recommended) or SQLite

#### Setup

1) Install backend dependencies:

```bash
composer install
```

2) Install frontend dependencies:

```bash
npm install
```

3) Create your environment file:

- Copy your existing `.env` template (team/internal) or create a new `.env`.
- At minimum you’ll need the standard Laravel keys:
  - `APP_NAME`, `APP_ENV`, `APP_KEY`, `APP_DEBUG`, `APP_URL`
  - `DB_CONNECTION`, `DB_HOST`, `DB_PORT`, `DB_DATABASE`, `DB_USERNAME`, `DB_PASSWORD`
  - `QUEUE_CONNECTION` (SkedWise defaults to `database`)
- **Note**: SkedWise uses relative paths and does not require `BASE_URL` or `ASSET_URL` in `.env`. The application automatically adapts to the deployment environment (root domain or subdirectory).

Generate an app key:

```bash
php artisan key:generate
```

4) Run migrations:

```bash
php artisan migrate
```

5) Build frontend assets:

```bash
npm run dev
```
or
```bash
yarn dev
```

6) Start the app:

```bash
php artisan serve
```

### Development workflow

Laravel + Vite can be run together via the Composer dev script:

```bash
composer run dev
```

This starts:

- The Laravel dev server
- A queue listener
- Log viewer (Pail)
- Vite dev server

### Queues

SkedWise is configured to use **database-backed queues** by default.

- Create the jobs tables (if not already present):

```bash
php artisan queue:table
php artisan migrate
```

- Run a worker:

```bash
php artisan queue:work
```

### SMS / Messaging

SkedWise includes an SMS sending service (`App\Services\SMSService`).

- Provider credentials are stored in the database (see models like `App\Models\SMSCred` / `App\Models\SMSLog`).
- Multiple “channels” are supported (e.g. OTP vs receipts vs general messaging) depending on the configured credentials.

If SMS is not configured for your environment, the app will log errors such as “SMS Service is not setup!”.

### Testing

PHPUnit is configured to load **`.env.testing`**.

- Create a `.env.testing` file with your test database configuration.
- Run the test suite:

```bash
php artisan test
```

### Common commands

- **Format**: `./vendor/bin/pint`
- **Run tests**: `php artisan test`
- **Clear caches**:

```bash
php artisan optimize:clear
```
