<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\LoginLog;
use Carbon\Carbon;

class CleanupLoginLogs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'login-logs:cleanup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete login logs older than 3 months';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $cutoffDate = Carbon::now()->subMonths(3);
        
        $deleted = LoginLog::where('login_time', '<', $cutoffDate)->delete();
        
        $this->info("Deleted {$deleted} login log entries older than 3 months.");
        
        return Command::SUCCESS;
    }
}
