<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;


class SyncBusinessMonthlySummary extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    // protected $signature = 'app:sync-business-monthly-summary';
    protected $signature = 'app:sync-business-monthly-summary
                        {--range : Apply date range filter}';


    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
     public function handle()
    {
        try {

        Log::info('Business Monthly Summary command started');

        $useDateRange = $this->option('range');

        if ($useDateRange) {
            // $fromDate = Carbon::now()->subMonth()->startOfMonth()->toDateString(); 
            $fromDate = Carbon::now()->startOfMonth()->toDateString(); 
            $toDate   = Carbon::now()->endOfMonth()->toDateString();    
        }

        $dateWhere = '';
        if ($useDateRange) {
            $dateWhere = " AND (DATE(v.created_on) BETWEEN '{$fromDate}' AND '{$toDate}'
                            OR DATE(v.updated_at) BETWEEN '{$fromDate}' AND '{$toDate}') ";
        }

        $business_data = DB::table('business')
            ->select('id_business', 'business_name', 'ho_accounts', 'ho')
            ->get();

        $allAccountMains = [
            'Revenue',
            'Liabilities',
            'Equity',
            'Non Financial',
            'Expenses',
            'Assets'
        ];

        $allMonths = [
            1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr',
            5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug',
            9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec'
        ];

        $finalData = [];

        foreach ($business_data as $biz) {

            if ($biz->ho_accounts == 'Yes') {
                $business_id_for_account_head =
                    DB::table('business')
                        ->where('ho', 'Yes')
                        ->value('id_business');
            } else {
                $business_id_for_account_head = $biz->id_business;
            }

            // ================= SQL QUERY =================
            
            $sql = "
                SELECT
                    m.account_main,
                    v.business_id,
                    business.business_name,
                    YEAR(v.voucher_date)  AS year,
                    MONTH(v.voucher_date) AS month_num,
                    MONTHNAME(v.voucher_date) AS month,
                    SUM(
                        CASE
                            WHEN m.account_main IN ('Revenue','Liabilities','Equity','Non Financial')
                                THEN (d.credit - d.debit)
                            WHEN m.account_main IN ('Expenses','Assets')
                                THEN (d.debit - d.credit)
                            ELSE 0
                        END
                    ) AS balance
                FROM account_vouchers v
                INNER JOIN business ON business.id_business = v.business_id
                INNER JOIN account_voucher_detail d ON v.id_account_vouchers = d.account_voucher_id
                INNER JOIN account_heads h ON d.account_head_id = h.id_account_heads
                INNER JOIN account_sub_control sc ON h.account_sub_control_id = sc.id_account_sub_control
                INNER JOIN account_control c ON sc.account_control_id = c.id_account_control
                INNER JOIN account_main m ON c.account_main_id = m.id_account_main
                WHERE
                    v.voucher_status = 'Active'
                    AND h.account_head_status = 'Active'
                    AND m.account_main IN ('Assets','Expenses','Revenue','Liabilities','Equity','Non Financial')
                    AND h.business_id = {$business_id_for_account_head}
                    AND business.id_business = {$biz->id_business}

                    $dateWhere
                GROUP BY
                    m.account_main,
                    v.business_id,
                    business.business_name,
                    YEAR(v.voucher_date),
                    MONTH(v.voucher_date)
                ORDER BY
                    v.business_id ASC,
                    month_num ASC
            ";

            $results = DB::select($sql);

            // ================= GROUP DATA =================
            $grouped = [];

            foreach ($results as $r) {
                $grouped[$r->business_id]['business_name'] = $r->business_name;
                $grouped[$r->business_id][$r->year][$r->account_main][$r->month_num] = $r->balance;
            }

            // ================= ZERO FILL MONTHS =================
            foreach ($grouped as $businessId => $businessData) {

                foreach ($businessData as $year => $yearData) {

                    if ($year == 'business_name') continue;

                    foreach ($allAccountMains as $accountMain) {
                        foreach ($allMonths as $monthNum => $monthName) {

                            $balance = $yearData[$accountMain][$monthNum] ?? 0;

                            $finalData[] = [
                                'business_id' => $businessId,
                                'account_main' => $accountMain,
                                'year' => $year,
                                'month_num' => $monthNum,
                                'month_name' => $monthName,
                                'balance' => $balance,
                                'created_at' => now(),
                                'updated_at' => now(),
                            ];
                        }
                    }
                }
            }
        }

        // ================= UPSERT =================
        if (!empty($finalData)) {
            DB::table('business_account_monthly_summary')->upsert(
                $finalData,
                ['business_id', 'account_main', 'year', 'month_num'],
                ['balance', 'month_name', 'updated_at']
            );
        }


       
        // ========================> Updating Income < =======================

        $entities = ['grosstotal_retail','grosstotal_recurring','grosstotal_training','grosstotal_voucher','grosstotal_service','total_invoice_value','sale_discount_service','sale_discount_retail','invoice_discount']; //invoice_discount ==  Franchise Invoice Discount
        $account_mappings = DB::table('account_event_mapping as aem')
        ->join('account_heads as ah', 'ah.id_account_heads', '=', 'aem.account_head_id')
        ->whereIn('aem.entity_name', $entities)
        ->whereIn('aem.account_event_id', [1,37])
        ->select(
            'aem.business_id',
            'aem.entity_name',
            'aem.account_head_id',
            'ah.account_head'
        )
        ->get()
        ->groupBy('business_id')
        ->map(function ($rows) {
            return $rows->keyBy('entity_name');
        });
        
        foreach ($business_data as $biz) {
              $business_id_for_account_head = $biz->ho_accounts == 'Yes' ? $business_data->firstWhere('ho','Yes')->id_business : $biz->id_business;
            $heads = $account_mappings[$business_id_for_account_head] ?? null;
            if (!$heads || !isset($heads['grosstotal_retail']) || !isset($heads['total_invoice_value'])  || !isset($heads['grosstotal_voucher']) || !isset($heads['grosstotal_training'])  || !isset($heads['grosstotal_recurring'])  || !isset($heads['grosstotal_service']) || !isset($heads['sale_discount_retail']) || !isset($heads['sale_discount_service']) || !isset($heads['invoice_discount'])) {
                // return response()->json(['success' => false, 'message' => 'One or more accounts not found']);
                // continue;
            }

            $account_head_ids = collect($heads)->pluck('account_head_id')->toArray();
            $sale_income_data = DB::table('account_voucher_detail as avd')
                    ->join('account_vouchers as av', 'av.id_account_vouchers', '=', 'avd.account_voucher_id')
                    ->where('av.voucher_status', 'Active')
                    ->where('av.business_id', $biz->id_business)
                    ->whereIn('avd.account_head_id', $account_head_ids);

                if ($useDateRange) {
                    $sale_income_data->where(function ($q) use ($fromDate, $toDate) {
                        $q->whereBetween(DB::raw('DATE(av.created_on)'), [$fromDate, $toDate])
                        ->orWhereBetween(DB::raw('DATE(av.updated_at)'), [$fromDate, $toDate]);
                    });
                }

               $sale_income_data = DB::select("
                                SELECT
                                    'Revenue' AS account_main,
                                    av.business_id,
                                    YEAR(av.voucher_date) AS year,
                                    MONTH(av.voucher_date) AS month_num,
                                    MONTHNAME(av.voucher_date) AS month,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS gift_vocuher_sale,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS training_sale,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS recurring_sale,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS service_sale,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS retail_sale,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS franchise_sale,


                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS sale_discount_service,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS sale_discount_retail,
                                    SUM(CASE WHEN avd.account_head_id = ? THEN IFNULL(avd.credit,0)-IFNULL(avd.debit,0) ELSE 0 END) AS invoice_discount

                                FROM account_voucher_detail avd
                                JOIN account_vouchers av ON av.id_account_vouchers = avd.account_voucher_id
                                WHERE av.voucher_status = 'Active'
                                AND av.business_id = ?
                                GROUP BY av.business_id, year, month_num, month
                            ", [
                                $heads['grosstotal_voucher']->account_head_id ?? 0,
                                $heads['grosstotal_training']->account_head_id ?? 0,
                                $heads['grosstotal_recurring']->account_head_id ?? 0,
                                $heads['grosstotal_service']->account_head_id ?? 0,
                                $heads['grosstotal_retail']->account_head_id ?? 0,
                                $heads['total_invoice_value']->account_head_id ?? 0,

                                $heads['sale_discount_service']->account_head_id ?? 0,
                                $heads['sale_discount_retail']->account_head_id ?? 0,
                                $heads['invoice_discount']->account_head_id ?? 0,
                                $biz->id_business
                            ]);
                    
                    if(isset($sale_income_data) && !empty($sale_income_data)){
                        foreach ($sale_income_data as $data) {
                        $updateData = [
                            'gift_vocuher_sale'  => $data->gift_vocuher_sale,
                            'training_sale'      => $data->training_sale,
                            'recurring_sale'     => $data->recurring_sale,
                            'service_sale'       => $data->service_sale,
                            'retail_sale'        => $data->retail_sale,
                            'franchise_sale'     => $data->franchise_sale,

                            'service_sale_discount'     => $data->sale_discount_service,
                            'retail_sale_discount'     => $data->sale_discount_retail,
                            'franchise_sale_discount'     => $data->invoice_discount,
                            'updated_at'         => now(),
                        ];
                        
                        DB::table('business_account_monthly_summary')
                            ->where('business_id', $data->business_id)
                            ->where('account_main', $data->account_main)
                            ->where('year', $data->year)
                            ->where('month_num', $data->month_num)
                            ->update($updateData);
                    }
                }
        }

        Log::info('Business Monthly Summary command completed successfully');

        return Command::SUCCESS;

    } catch (\Throwable $e) {

            Log::error('Business Monthly Summary command failed', [
                'message' => $e->getMessage(),
                'file'    => $e->getFile(),
                'line'    => $e->getLine(),
                'trace'   => $e->getTraceAsString(),
            ]);
            
            $this->error('Business Monthly Summary failed ❌ Check logs');

            return Command::FAILURE;
        }
    }
}
