<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\ProductsStockService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SyncProductStockCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'stock:sync-mis';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Synchronize product stock into MIS stock table for all stores';

    /**
     * Execute the console command.
     */
    public function handle(ProductsStockService $productsStockService)
    {
        Log::info('MIS Stock Sync Command STARTED');
        
        try {
            $stores = DB::table('business_stores')
                ->select('id_business_stores', 'business_id')
                ->get();

            if ($stores->isEmpty()) {
                Log::info('No stores found');
                $this->info('No stores found');
                return;
            }

            foreach ($stores as $store) {
                Log::info("Processing Store ID: {$store->id_business_stores}");
                $this->info("Processing Store ID: {$store->id_business_stores}");

                $productsStock = $productsStockService
                    ->gettingProductsStock(
                        $store->id_business_stores,
                        $store->business_id
                    );

                if ($productsStock->isEmpty()) {
                    Log::info("No stock for Store ID: {$store->id_business_stores}");
                    continue;
                }

                foreach ($productsStock as $stock) {
                    DB::table('mis_store_product_stock')->updateOrInsert(
                        [
                            'product_id' => $stock['product_id'],
                            'store_id' => $stock['store_id'],
                            'batch_id' => $stock['batch_id'],
                        ],
                        [
                            'batch_number' => $stock['batch_number'],
                            'batch_date' => $stock['batch_date'],
                            'business_id' => $stock['business_id'],
                            'business_name' => $stock['business_name'],
                            'product' => $stock['product'],
                            'category' => $stock['category'],
                            'business_brand_name' => $stock['business_brand_name'],
                            'store' => $stock['store'],
                            'addition_qty' => $stock['addition_qty'],
                            'purchased_qty' => $stock['purchased_qty'],
                            'transfer_in_qty' => $stock['transfer_in_qty'],
                            'transfer_out_qty' => $stock['transfer_out_qty'],
                            'sold_qty' => $stock['sold_qty'],
                            'used_qty' => $stock['used_qty'],
                            'returned_qty' => $stock['returned_qty'],
                            'franchise_sale_qty' => $stock['franchise_sale_qty'],
                            'instock' => $stock['instock'],
                            'average_batch_unit_price' => $stock['average_batch_unit_price'],
                            'total_value' => $stock['total_value'],
                            'measure_unit' => $stock['measure_unit'],
                            'qty_per_unit' => $stock['qty_per_unit'],
                            'unit_type' => $stock['unit_type'],
                            'updated_at' => now()
                        ]
                    );
                }

                Log::info("Store Sync COMPLETED: {$store->id_business_stores}");
                $this->info("Store Sync COMPLETED: {$store->id_business_stores}");
            }

            Log::info('MIS Stock Sync Command FINISHED');
            $this->info('MIS Stock Sync Command FINISHED');

        } catch (\Throwable $e) {
            Log::error('MIS Stock Sync Command ERROR: ' . $e->getMessage());
            $this->error('MIS Stock Sync Command ERROR: ' . $e->getMessage());
        }
    }
}