<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\RoleSyncService;

class SyncRolesToSpatie extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'spatie:sync-roles 
                            {--users-only : Only sync user role assignments}
                            {--roles-only : Only sync roles (not user assignments)}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync roles and user-role assignments from legacy system to Spatie Permission tables';

    /**
     * Execute the console command.
     */
    public function handle(RoleSyncService $syncService): int
    {
        $this->info('Starting synchronization from legacy system to Spatie Permission...');

        $usersOnly = $this->option('users-only');
        $rolesOnly = $this->option('roles-only');

        try {
            if (!$usersOnly) {
                $this->info('Syncing roles...');
                $rolesCount = $syncService->syncAllRoles();
                $this->info("✓ Synced {$rolesCount} roles to Spatie.");
            }

            if (!$rolesOnly) {
                $this->info('Syncing user role assignments...');
                $usersCount = $syncService->syncAllUsers();
                $this->info("✓ Synced role assignments for {$usersCount} users to Spatie.");
            }

            $this->info('');
            $this->info('Synchronization completed successfully!');
            
            return Command::SUCCESS;
        } catch (\Exception $e) {
            $this->error('An error occurred during synchronization:');
            $this->error($e->getMessage());
            $this->error($e->getTraceAsString());
            
            return Command::FAILURE;
        }
    }
}
