<?php

namespace App\Http\Controllers;


use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business;
use App\Models\AccountVouchers;
use App\Models\AccountEventMapping;
use Illuminate\Support\Facades\Bus;

class AccountVoucherController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function create_account_voucher(Request $request)
    {
        $id_account_heads = $request->id_account_head;
        $voucher_date = $request->voucher_date;
        $description = $request->description;
        $business_id= session('business_id');
        $created_by = session('user_name');
        $invoice_id = $request->invoice_id;
        $voucher_type = $request->voucher_type;
        $sale_type = $request->sale_type;
        $voucher_amount = $request->amount;
        $cost_center = $request->cost_center;
        $cost_center_name = $request->cost_center_name;
        $business_partner = $request->business_partner;
        $business_partner_id = $request->business_partner_id;
        $business_partner_name = $request->business_partner_name;
        $bank_name = $request->bank_name;
        $payment_mode = $request->payment_mode;
        $auto_voucher = $request->auto_voucher;

        if($voucher_date == null || $business_partner_id == null || $description == null){
            return response()->json([
                'status' => 'error',
                'message' => 'Missing required fields'
            ]);
        }

       
        $account_voucher = new AccountVouchers();
        $account_voucher->voucher_type = $voucher_type;
        $account_voucher->created_by = $created_by;
        $account_voucher->created_on = date('Y-m-d H:i:s');
        $account_voucher->invoice_id = $invoice_id;
        $account_voucher->sale_type = $sale_type;        
        $account_voucher->id_account_head = $id_account_heads;
        $account_voucher->voucher_date = $voucher_date;
        $account_voucher->description = $description;
        $account_voucher->business_id = session('business_id');
        $account_voucher->voucher_amount = $voucher_amount;
        $account_voucher->cost_center = $cost_center;
        $account_voucher->cost_center_name = $cost_center_name;
        $account_voucher->business_partner = $business_partner;
        $account_voucher->business_partner_id = $business_partner_id;
        $account_voucher->business_partner_name = $business_partner_name;
        $account_voucher->bank_name = $bank_name;
        $account_voucher->payment_mode = $payment_mode;
        $account_voucher->auto_voucher = $auto_voucher;

        $account_voucher->save();
        $new_voucher_id = $account_voucher->id_account_vouchers;

       // return $new_voucher_id;
       
        return response()->json([
            "message_type" => "success",
            "message_btn" => "success",
            'message' => 'Account voucher created successfully',
            'data' => $account_voucher,
            'new_voucher_id' => $new_voucher_id
        ]);
    }
}
