<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business;
use App\Models\AccountEvents;
use App\Models\AccountEventMapping;
use App\Models\AccountHeads;

use Illuminate\Support\Facades\Bus;

class AccounteventsController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function get_event_by_entity(Request $request)
    {
        $entity = $request->entity_name;
        $event_id = $request->event_id;

        if($entity == null){

            return [];

        }

        $account_head = AccountEventMapping::select('id_account_event_mapping', 'account_event_id', 'account_head_id', 'account_head')
        ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
        ->where('account_event_mapping.business_id', '=', session('business_id'))
        ->where('account_heads.business_id', '=', session('business_id'))
        ->where('entity_name', '=', $entity)
        ->first();

        return $account_head;

    }

    public function account_events(Request $request)
    {   
        if (session('ho_accounts') == 'Yes' && session('ho') == 'No') {
            return response()->view('error.403', ['message' => 'Your account is handled by the Head Office'], 403);
        }
        
        $business_id = session('business_id');
        if($request->has('business_id')){
            $business_id = $request->business_id;
        } 

        if(session('ho')=='Yes' && session('user_role')=='Super User'){
            $branches = Business::where('common_products', session('common_products'))->get();
        } else {
            $branches = Business::where('id_business', $business_id)->get();
        }

        $events = AccountEvents::select('*')
        ->get();

        foreach($events as $key => $event){
            $mapping = AccountEventMapping::where('account_event_id', $event->id_account_events)
            ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
            ->where('account_event_mapping.business_id', $business_id)
            ->orderBy('account_event_mapping.transaction_type', 'ASC') 
            ->orderBy('account_event_mapping.id_account_event_mapping', 'ASC')
            ->get();            
            $events[$key]->mapping = $mapping;
        }

       // echo '<pre>'; print_r($events); exit;
        $business = Business::find($business_id);

        $account_heads = AccountHeads::where('business_id', $business_id)->where('account_head_status', 'Active')->get();

        return view('supervision.account_events', compact('business', 'events', 'account_heads', 'branches'));
    }

    public function get_mapping($id_account_event_mapping)
    {
        $mapping = AccountEventMapping::where('id_account_event_mapping', $id_account_event_mapping)
        ->select('account_event_mapping.*', 'account_heads.account_head', 'account_events.event_name', 'account_event_mapping.business_id')
        ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
        ->leftJoin('account_events', 'account_events.id_account_events', '=', 'account_event_mapping.account_event_id')
        ->first();            

        return response()->json($mapping);
    }

    public function save_mapping(Request $request)
    {
        try{
            $id_account_event_mapping = $request->id_account_event_mapping;
            $account_head_id = $request->account_head_id;
            $transaction_type = $request->transaction_type;
            $entity_name = $request->entity_name;
            $business_id = $request->business_id;

            if($id_account_event_mapping > 0 || $id_account_event_mapping != ''){
                // Update existing mapping
                $mapping = AccountEventMapping::find($id_account_event_mapping);
                if($mapping){
                    $mapping->account_head_id = $account_head_id;
                    $mapping->transaction_type = $transaction_type;
                    $mapping->entity_name = $entity_name;
                    $mapping->business_id = $business_id;
                    $mapping->save();
                }

                return response()->json([
                    'success' => true,
                    'message' => 'Mapping updated successfully.',
                    'mapping' => $mapping,
                    'message_btn' => 'btn btn-success'
                ]);
            } else {
                // Create new mapping
                $mapping = new AccountEventMapping();
                $mapping->account_head_id = $account_head_id;
                $mapping->transaction_type = $transaction_type;
                $mapping->entity_name = $entity_name;
                $mapping->business_id = $business_id;
                $mapping->account_event_id = $request->account_event_id;
                $mapping->description = $request->description;
                $mapping->mapped_by = session('user_name');

                $mapping->save();
                return response()->json([
                    'success' => true,
                    'message' => 'Mapping created successfully.',
                    'mapping' => $mapping,
                    'message_btn' => 'btn btn-success'
                ]);

            }
            
        } catch (\Exception $e) {
            return response()->json(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }
}


