<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\View\View;
use App\Models\User;
use App\Models\LoginLog;
use App\Services\RoleSyncService;
use Illuminate\Support\Facades\DB;

/**
 * Controller to handle authenticated sessions.
 */

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(Request $request)
    {
       
        $request->validate([
            'user_name' => 'required|string',
            'user_password' => 'required|string',
        ]);
               
        $user = User::where('user_name', $request->user_name)
        ->with(['roles', 'business']) // assuming relationships are defined
        ->first();

        // echo "<pre>";
        // print_r($user->toArray());
        // die();
        
        if (!$user || $user->user_status !== 'Active') {
            return back()->withErrors([
                'message' => 'The provided User does not exist.',
            ]);
        } elseif (md5($request->user_password) != $user->user_password) {
            return back()->withErrors([
                'message' => 'The provided Password does not match our records.',
            ]);
        }
        
        Auth::login($user);
        $request->session()->regenerate();

        $userrole = $user->roles->pluck('name')->first();
        $roleid = $user->roles->pluck('id')->first();

        //Save custom session values
        session([
            'user_id' => $user->id_users,
            'user_name' => $user->user_name,
            'user_role' => $userrole,
            'role_id' => $roleid,
            'business_name' => $user->business->business_name ?? null,
            'business_id' => $user->business->id_business,
            'business_logo' => $user->business->business_logo ?? null,
            'user_image' => $user->user_image ?? null,
            'switch' => $user->business->switch ?? "No",
            'ho' => $user->business->ho ?? "No",
            'common_products' => $user->business->common_products ?? "No",
            'common_services' => $user->business->common_services ?? "No",
        ]);
        
        // echo "<pre>";
        // print_r($user->toArray());
        // die();
        // Sync user roles to Spatie Permission system  
        // try {
        //     app(RoleSyncService::class)->syncUserRolesToSpatie($user);
        // } catch (\Exception $e) {
        //     Log::warning('Failed to sync user roles to Spatie on login: ' . $e->getMessage());
        // }

        // Mark all previous active sessions for this user as logged out
        LoginLog::where('user_id', $user->id_users)
            ->whereNull('logout_time')
            ->update(['logout_time' => now()]);

        // Log the new login
        LoginLog::create([
            'user_id' => $user->id_users,
            'user_name' => $user->user_name,
            'business_id' => $user->business->id_business ?? null,
            'ip_address' => $request->ip(),
            'user_agent' => $request->userAgent(),
            'login_time' => now(),
            'session_id' => $request->session()->getId(),
        ]);
       
       return redirect()->route('welcome');
    }


    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        $sessionId = $request->session()->getId(); // current session id
    
            // Update logout time in login log
            if (Auth::check()) {
                LoginLog::where('session_id', $sessionId)
                    ->whereNull('logout_time')
                    ->update(['logout_time' => now()]);
            }

            Auth::guard('web')->logout();

            // Delete current session from DB
            DB::table('sessions')->where('id', $sessionId)->delete();

            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return redirect('/logout');
    }  
}
