<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\BlockEvent;

class BlockEventsController extends Controller
{
    public function block_events(Request $request)
    {
        $business_id = session('business_id');

        // Match scheduler behavior: if common_services is enabled, use HO business's reasons
        if (session('common_services') == "Yes") {
            $ho_business = DB::table('business')->where('ho', 'Yes')->first();
            $business_id = $ho_business->id_business ?? session('business_id');
        }

        $blockEvents = BlockEvent::where('business_id', $business_id)
            ->orderBy('id_block_events', 'ASC')
            ->get();

        return view('block_events.block_events_listing', compact('blockEvents', 'business_id'));
    }

    public function save_or_update(Request $request)
    {
        try {
            $request->validate([
                'id_block_events' => 'nullable|integer',
                'block_event_name' => 'required|string|max:255',
                'block_event_desc' => 'required|string',
            ]);

            $business_id = session('business_id');
            if (session('common_services') == "Yes") {
                $ho_business = DB::table('business')->where('ho', 'Yes')->first();
                $business_id = $ho_business->id_business ?? session('business_id');
            }

            $id = $request->input('id_block_events');
            // Duration is not maintained from this screen anymore (blocking is done via start/end on scheduler).
            // Keep existing duration on updates; default to 00:00:00 on create.
            $duration = '00:00:00';
            if (!empty($id)) {
                $duration = BlockEvent::where('id_block_events', $id)->value('block_event_duration') ?? '00:00:00';
            }

            $blockEvent = BlockEvent::updateOrCreate(
                ['id_block_events' => $id],
                [
                    'business_id' => $business_id,
                    'block_event_name' => $request->input('block_event_name'),
                    'block_event_desc' => $request->input('block_event_desc'),
                    'block_event_duration' => $duration,
                ]
            );

            return response()->json([
                'success' => true,
                'message' => 'Block time reason saved successfully',
                'block_event' => $blockEvent,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ], 500);
        }
    }
}
