<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Bus;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\DB;

class BusinessController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;


    public function ajax_businesses(Request $request)
    {
        $businesses = Business::where('common_products', 'Yes')
        ->select('id_business', 
        'business_name', 'business_logo', 'business_type_id', 'business_address',
        'business_phone1', 'business_email', 
        'common_products', 'common_services', 'ho',
        'ho_accounts'
         )
        ->get()
        ->toArray();

        echo json_encode($businesses);
        exit;
    }

    public function business_search(Request $request)
    {
        $searchTerm = $request->input('term');

        $business = Business::where('business_name', 'LIKE', '%' . $searchTerm . '%')
            ->select('id_business as id', 'business_name as text', 'business_logo', 'business_type_id', 'business_address', 'business_phone1', 'business_email', 'common_products', 'common_services', 'ho')
            ->get();

        return response()->json($business);
    }

    public function b_switch(Request $request)
    {
       
        //return $request->all();

        $business_id = $request->input('id_business');
        $business_name = $request->input('business_name');
        $ho = $request->input('business_ho');
        $common_products = $request->input('common_products');
        $common_services = $request->input('common_services');
        $business_type = $request->input('business_type');
        $ho_accounts = $request->input('ho_accounts');
        
       //return $ho;

        session(['business_id' => $business_id, 'business_name' => $business_name, 'ho' => $ho, 'common_products' => $common_products, 'common_services' => $common_services, 'business_type' => $business_type, 'ho_accounts' => $ho_accounts]);
        return redirect()->route('welcome')->with('success', 'Business switched successfully.');
    }

    public function get_business_hours(Request $request)
    {
        $business_id = session('business_id');

        $business = Business::where('id_business', $business_id)
            ->select('business_opening_time', 'business_closing_time')
            ->first();

        if ($business) {
            return response()->json([
                'start_time' => $business->business_opening_time,
                'end_time' => $business->business_closing_time,
            ]);
        } else {
            return response()->json(['error' => 'Business not found'], 404);
        }
    }

    public function branches(Request $request)
    {
        $branches = Business::select('id_business', 'business_name', 'business_logo', 'business_type_id', 'business_owner',
        'business_address', 'business_phone1', 'business_email', 'common_products', 'common_services', 'ho',
        'hrm_installed', 'receipts_installed', 'loyalty_enable', 'coaching', 'business_type.business_type', 'business_type.id_business_type'
        );
        $branches = $branches->leftJoin('business_type', 'business_type.id_business_type', '=', 'business.business_type_id');
        if(session('ho') == "No"){
            $branches = $branches->where('id_business', session('business_id'));
        } else {
            $branches = $branches->where('common_products', 'Yes');
        }        
        $branches = $branches->get();

        $business_types = DB::table('business_type')->get();

        return view('business.branches', compact('branches', 'business_types'));
    }

    public function getBranchFinancialData(Request $request)
    {
        // Get date range from request (used only if fiscal year closing exists)
        $requestStartDate = $request->input('start_date');
        $requestEndDate = $request->input('end_date');
        
        // Get all branches based on permissions
        $branchQuery = Business::select('id_business', 'business_name');
        if(session('ho') == "No"){
            $branchQuery->where('id_business', session('business_id'));
        } else {
            $branchQuery->where('ho_accounts', 'Yes');
        }
        $branches = $branchQuery->get();

        $financialData = [];
        
        foreach ($branches as $branch) {
            $businessId = $branch->id_business;
            
            // Get the last fiscal year closing date for this specific branch
            $lastClosing = DB::table('fiscal_year_closings')
                ->where('business_id', $businessId)
                ->where('status', 'Active')
                ->orderBy('closing_date', 'desc')
                ->value('closing_date');
            
            // Determine start date and end date based on fiscal year closing
            if ($lastClosing) {
                // If fiscal year closing exists, use it as start date
                $startDate = date('Y-m-d', strtotime($lastClosing));
                // End date: use request end date if provided, otherwise current date
                $endDate = $requestEndDate ? date('Y-m-d', strtotime($requestEndDate)) : date('Y-m-d');
            } else {
                // If no fiscal year closing exists, default to current month (1st to today)
                $startDate = date('Y-m-01'); // First day of current month
                $endDate = date('Y-m-d'); // Current date (today)
            }
            
            // Calculate Revenue from account vouchers (filtered by date range)
            $revenue = DB::table('account_voucher_detail as avd')
                ->join('account_vouchers as av', function ($join) {
                    $join->on('avd.account_voucher_id', '=', 'av.id_account_vouchers')
                        ->where('av.voucher_status', '=', 'Active');
                })
                ->join('account_heads as ah', 'ah.id_account_heads', '=', 'avd.account_head_id')
                ->join('account_sub_control as sc', 'sc.id_account_sub_control', '=', 'ah.account_sub_control_id')
                ->join('account_control as ac', 'ac.id_account_control', '=', 'sc.account_control_id')
                ->join('account_main as am', 'am.id_account_main', '=', 'ac.account_main_id')
                ->whereLike('am.account_main', 'Revenue')
                ->where('av.business_id', $businessId)
                ->whereRaw("DATE(av.voucher_date) BETWEEN ? AND ?", [$startDate, $endDate])
                ->selectRaw('SUM(COALESCE(avd.credit, 0)) - SUM(COALESCE(avd.debit, 0)) AS Revenue')
                ->groupBy('av.business_id', 'am.id_account_main')
                ->value('Revenue');
            
            // Calculate Expenses from account vouchers (filtered by date range)
            $expenses = DB::table('account_voucher_detail as avd')
            ->join('account_vouchers as av', function ($join) {
                $join->on('avd.account_voucher_id', '=', 'av.id_account_vouchers')
                    ->where('av.voucher_status', '=', 'Active');
            })
            ->join('account_heads as ah', 'ah.id_account_heads', '=', 'avd.account_head_id')
            ->join('account_sub_control as sc', 'sc.id_account_sub_control', '=', 'ah.account_sub_control_id')
            ->join('account_control as ac', 'ac.id_account_control', '=', 'sc.account_control_id')
            ->join('account_main as am', 'am.id_account_main', '=', 'ac.account_main_id')
            ->whereLike('am.account_main', 'Expenses')
            ->where('av.business_id', $businessId)
            ->whereRaw("DATE(av.voucher_date) BETWEEN ? AND ?", [$startDate, $endDate])
            ->selectRaw('SUM(COALESCE(avd.debit, 0)) - SUM(COALESCE(avd.credit, 0)) AS Expenses')
            ->groupBy('av.business_id', 'am.id_account_main')
            ->value('Expenses');
            
            // Ensure values are numeric and handle null cases
            $revenue = is_numeric($revenue) ? (float)$revenue : 0;
            $expenses = is_numeric($expenses) ? (float)$expenses : 0;
            
            // Calculate profit: Revenue - Expenses (can be negative if expenses exceed revenue)
            $profit = $revenue - $expenses;
            
            // Ensure profit is numeric and preserve sign (negative values are valid)
            if (!is_numeric($profit)) {
                $profit = 0;
            } else {
                $profit = (float)$profit;
            }
            
            $financialData[] = [
                'branch_id' => $businessId,
                'branch_name' => $branch->business_name,
                'last_closing' => $lastClosing ? date('Y-m-d', strtotime($lastClosing)) : null,
                'start_date' => $startDate,
                'end_date' => $endDate,
                'revenue' => round($revenue, 2),
                'expenses' => round($expenses, 2),
                'profit' => round($profit, 2) // This will preserve negative sign
            ];
        }
        
        return response()->json($financialData);
    }

    public function uploadimage(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // max 2MB
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('images/business'), $filename);

            return response()->json(['filename' => $filename]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }

    public function update_image(Request $request)
    {
        
        if(empty($request->id_business)){
            return response()->json(['error' => 'ID Business is required'], 400);
        }

        $businessimage = "blank.png";
        if($request->input('business_image')!=null && $request->input('business_image')!=""){
            $businessimage = $request->input('business_image');
        } else {
            $businessimage = $request->input('existing_image');
        }

        $business = Business::where('id_business',  $request->id_business)->first();
        if ($business) {
            $business->business_logo = $businessimage;
            $business->save();

            return response()->json(['success' => true, 'message' => 'Business logo updated successfully']);
        }

        return response()->json(['error' => true, 'message' => 'Business not found'], 404);
    }

    public function existing_images(Request $request)
    {
       $path = public_path('images/business');
        $urls = [];

        if (File::exists($path)) {
            foreach (File::files($path) as $file) {
                $urls[] = asset('images/business/' . $file->getFilename());
            }
        }

        return response()->json($urls);
    }

    public function update(Request $request)
    {
        if(empty($request->id_business)){
            return response()->json(['error' => 'ID Business is required'], 400);
        }

        $business = Business::find($request->id_business);
        if ($business) {
            $business->business_type_id = $request->input('business_type_id', $business->business_type_id);
            $business->business_name = $request->input('business_name', $business->business_name);
            $business->business_address = $request->input('business_address', $business->business_address);
            $business->business_phone1 = $request->input('business_phone1', $business->business_phone1);
            $business->business_phone2 = $request->input('business_phone2', $business->business_phone2);
            $business->business_phone3 = $request->input('business_phone3', $business->business_phone3);
            $business->business_phone4 = $request->input('business_phone4', $business->business_phone4);
            $business->business_owner = $request->input('business_owner', $business->business_owner);
            $business->business_owner_contact = $request->input('owner_contact', $business->business_owner_contact);
            $business->business_address = $request->input('business_address', $business->business_address);
            $business->business_area = $request->input('business_area', $business->business_area);
            $business->payment_terms = $request->input('payment_terms', $business->payment_terms);

            $business->business_email = $request->input('business_email', $business->business_email);
            $business->common_products = $request->input('common_products', $business->common_products);
            $business->common_services = $request->input('common_services', $business->common_services);
            $business->ho = $request->input('ho', $business->ho);
            $business->save();

            return response()->json(['success' => true, 'message' => 'Business details updated successfully']);
        }

        return response()->json(['error' => true, 'message' => 'Business not found'], 404);
    }


    public function update_settings(Request $request)
    {
        if(empty($request->id_business)){
            return response()->json(['error' => 'ID Business is required'], 400);
        }

        $business = Business::find($request->id_business);
        if ($business) {

           
            // Settings
            $business->business_name = $request->input('settings_business_name', $business->business_name);
            $business->business_opening_time = $request->input('business_opening_time', $business->business_opening_time);
            $business->business_closing_time = $request->input('business_closing_time', $business->business_closing_time);
            $business->tax_optional = $request->input('tax_optional', $business->tax_optional);
            $business->rec_allow_prev = $request->input('rec_allow_prev', $business->rec_allow_prev);
            $business->show_cash_reg = $request->input('show_cash_reg', $business->show_cash_reg);
            $business->allow_balance = $request->input('allow_balance', $business->allow_balance);
            $business->backdated_invoice = $request->input('backdated_invoice', $business->backdated_invoice);
            $business->invoiced_drag = $request->input('invoiced_drag', $business->invoiced_drag);
            $business->allow_invoice_cancel = $request->input('allow_invoice_cancel', $business->allow_invoice_cancel);
            $business->cc_charge = $request->input('cc_charge', $business->cc_charge);
            $business->allow_price_update = $request->input('allow_price_update', $business->allow_price_update);
            $business->allow_stock_update = $request->input('allow_stock_update', $business->allow_stock_update);
            $business->show_professional = $request->input('show_professional', $business->show_professional);
            $business->allow_visit_cancel = $request->input('allow_visit_cancel', $business->allow_visit_cancel);
            $business->allow_visit_move = $request->input('allow_visit_move', $business->allow_visit_move);
            $business->allow_cancel_advance = $request->input('allow_cancel_advance', $business->allow_cancel_advance);

            //Modules
            $business->receipts_installed = $request->input('receipts_installed', $business->receipts_installed);
            $business->referral_installed = $request->input('referral_installed', $business->referral_installed);
            $business->loyalty_sms = $request->input('loyalty_sms', $business->loyalty_sms);
            $business->hrm_installed = $request->input('hrm_installed', $business->hrm_installed);
            $business->flexi_pricing_enabled = $request->input('flexi_pricing_enabled', $business->flexi_pricing_enabled);

            $business->save();

            return response()->json(['success' => true, 'message' => 'Business settings updated successfully']);
        }

        return response()->json(['error' => true, 'message' => 'Business not found'], 404);
    }

    public function get_branch($id_business)
    {
        try {
            $branch = Business::findOrFail($id_business);
            return response()->json($branch);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Branch not found'], 404);
        }
    }
   
    public function getBranchesByType(Request $request)
    {
        $business_type_id = $request->input('business_type_id');
        if($business_type_id == ""){
            $branches = Business::select('id_business', 'business_name')
            ->where('business.common_products', 'Yes')            
            ->get();
        } else {
            $branches = Business::select('id_business', 'business_name')
            ->where('business_type_id', $business_type_id)
            ->where('business.common_products', 'Yes')
            ->get();
        }

        return response()->json($branches);
    }
}


