<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Pest\Support\View;
use App\Models\Cities;
use Illuminate\Support\Facades\DB;
class CityController extends Controller
{
    public function cities_listing(Request $request){
        $business_id = session('business_id');
        $citiesQuery = Cities::with('areas');
        if (session('ho') == 'No') {
            $citiesQuery->where('business_id', $business_id);
        }
        $cities = $citiesQuery->get();
      return view('city.cities_listing',compact('cities'));    
    }

    public function save_or_update(Request $request)
    {
        $request->validate([
            'city'     => 'required|string|max:255',
            'province' => 'required|string|max:255',
            'country'  => 'required|string|max:255',
        ]);

        DB::beginTransaction();

        try {
            $id = $request->id_cities;
            $data = [
                'city'        => $request->city,
                'province'    => $request->province,
                'country'     => $request->country,
                'business_id' => session('business_id'),
            ];

            if ($id) {
                DB::table('cities')
                    ->where('id_cities', $id)
                    ->update($data);

                $message = 'City updated successfully!';
            } else {
                DB::table('cities')->insert($data);
                $message = 'City added successfully!';
            }
            DB::commit();
            
            return response()->json([
                'success' => true,
                'message' => $message,
            ]);

        } catch (\Throwable $e) {
            DB::rollBack();

            return response()->json([
                'success' => false,
                'message' => 'Something went wrong!',
                'error'   => $e->getMessage(), 
            ], 500);
        }
    }
    public function area_save_or_update(Request $request)
    {
        $request->validate([
            'city_id'     => 'required',
            'city_area' => 'required'
        ]);

        DB::beginTransaction();

        try {
            $id = $request->id_city_areas;
            $data = [
                'city_id'        => $request->city_id,
                'city_area'      => $request->city_area,
                'city'           =>   DB::table('cities')->where('id_cities',$request->city_id)->first()->city ?? '',
            ];
            if ($id) {
                DB::table('city_areas')
                    ->where('id_city_areas', $id)
                    ->update($data);
                $message = 'Area updated successfully!';
            } else {
                DB::table('city_areas')->insert($data);
                $message = 'Area added successfully!';
            }
            DB::commit();

            return response()->json([
                'success' => true,
                'message' => $message,
            ]);

        } catch (\Throwable $e) {
            DB::rollBack();

            return response()->json([
                'success' => false,
                'message' => 'Something went wrong!',
                'error'   => $e->getMessage(), 
            ], 500);
        }
    }

}
