<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business;
use App\Models\ConcentCategory;
use App\Models\ConcentForms;
use App\Models\ConcentFormData;
use App\Models\Customers;
use App\Models\Staff;
use App\Models\CustomerVisits;

use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;

use Illuminate\Support\Facades\Bus;

class ConsentFormsController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function consent_forms(Request $request)
    {

        //if $request->visit_id is set, then pass it to the view along with customer name and id
        if(isset($request->visit_id)) {
            $visit_id = $request->visit_id;
            $customer_name = $request->customer_name;
            $customer_id = $request->customer_id;
        } else {
            $visit_id = null;
            $customer_name = null;
            $customer_id = null;
        }

        $consent_categories = ConcentCategory::all();
       
        $data = [];
        foreach($consent_categories as $category) {
            $forms = ConcentForms::where('category_id', $category->id_concent_category)->where('form_status', '=', 'Active')->get();
            $data[] = [
                'category' => $category,
                'forms' => $forms
            ];
        }
      
        return view('consent_forms.consent_forms', compact('data', 'visit_id', 'customer_name', 'customer_id'));
    }

    public function consent_form(Request $request)
    {
        $visit_id   = $request->visit_id;
        $form_id     = $request->id_concent_form;
        $customer_id = $request->customer_id;

        $consent_form = ConcentForms::where('id_concent_forms', $form_id)->firstOrFail();

        // DECODE STRUCTURE JSON
        $consent_structure = json_decode($consent_form->form_structure);
        //return $consent_structure;
       

        $customerdetails = Customers::where('id_customers', $customer_id)->firstOrFail();

        $staff = Staff::where('business_id', session('business_id'))
            ->where('staff_active', 'Y')
            ->get();

        return view(
            'consent_forms.consent_form',
            compact('consent_form', 'consent_structure', 'customerdetails', 'staff', 'visit_id', 'customer_id')
        );
    }

    public function save_consent_form(Request $request)
    {

        $customer_visit = CustomerVisits::select('*')
            ->join ('customers', 'customer_visits.customer_id', '=', 'customers.id_customers')
            ->where('id_customer_visits', $request->visit_id)->first();

        $consultant = Staff::where('id_staff', $request->staff_id)->first();

        //return $request->all();
        $form = new ConcentFormData();
        $form->concent_form_id = $request->concent_form_id;
        $form->customer_id = $customer_visit->customer_id;
        $form->customer_name = $customer_visit->customer_name;
        $form->customer_cell = $customer_visit->customer_cell;
        $form->customer_area = $customer_visit->customer_area;
        $form->customer_email = $customer_visit->customer_email;
        $form->visit_id = $request->visit_id;
        $form->staff_id = $request->staff_id;
        $form->form_title = $request->form_title;
        $form->event_date = $request->event_date;
        $form->visit_date = $customer_visit->customer_visit_date;
        $form->concent_date = date('Y-m-d H:i:s');
        $form->consultant_name = $consultant->staff_firstname . ' ' . $consultant->staff_lastname;
        $form->customer_signature = $request->customer_signature;
        $form->consultant_signature = $request->consultant_signature;
        $form->concent_data = $request->concent_data;
        $form->save();

        return response()->json([
            'status' => 'success',
            'concent_form_data_id' => $form->id_concent_form_data,
        ]);
    }

    public function signed_consent_form($id_concent_form_data)
    {
        $form_data = ConcentFormData::where('id_concent_form_data', $id_concent_form_data)->firstOrFail();

        //$consent_form = ConcentForms::where('id_concent_forms', $form_data->concent_form_id)->firstOrFail();

        // DECODE STRUCTURE JSON
        $consent_structure = json_decode($form_data->concent_data);

        return view('consent_forms.signed_form', compact('form_data', 'consent_structure'));
    }

    public function consent_list(Request $request)
    {

        $id_customers = $request->id_customers;
        $start = $request->start_date ?? now()->startOfMonth()->toDateString();
        $end = $request->end_date ?? now()->endOfMonth()->toDateString();

        

        return view('consent_forms.consent_list', compact('start', 'end', 'id_customers'));
    }


    public function consent_list_data(Request $request)
    {
        $query = ConcentFormData::query();

        // Customer filter
        if ($request->filled('customer_id')) {
            $query->where('customer_id', $request->customer_id);
        }

        
        // Date range filter
        else if ($request->filled('date_range')) {
            //check if "to" exists in the date_range string
            if (strpos($request->date_range, 'to') === false) {
                $start = $request->date_range;
                $end = $request->date_range;
            } else {
                // assuming dateRange = "YYYY-MM-DD to YYYY-MM-DD"
                [$start, $end] = array_map('trim', explode(' to ', $request->date_range));
            }
            

            $query->where(
                'concent_date', ">=", $start . ' 00:00:00'
            )->where(
                'concent_date', "<=", $end . ' 23:59:59'
            );

            

        }

        return DataTables::of($query)

            ->editColumn('visit_date', function ($row) {
                return $row->visit_date
                    ? Carbon::parse($row->visit_date)->format('d-m-Y')
                    : '';
            })

            ->editColumn('concent_date', function ($row) {
                return $row->concent_date
                    ? Carbon::parse($row->concent_date)->format('d-m-Y H:i')
                    : '';
            })

            // Consultant signature (already stored as full data URI)
            ->editColumn('consultant_signature', function ($row) {
                return $row->consultant_signature ?: null;
            })

            // Customer signature (already stored as full data URI)
            ->editColumn('customer_signature', function ($row) {
                return $row->customer_signature ?: null;
            })
            ->addColumn('actions', function ($row) {
                $viewUrl = route('signed_consent_form', ['id_concent_form_data' => $row->id_concent_form_data]);
                return '<a href="' . $viewUrl . '" class="btn btn-sm btn-primary" target="_blank">View</a>';
            })
            

            // Tell Yajra these columns contain raw HTML (img tags)
            ->rawColumns(['consultant_signature', 'customer_signature', 'actions'])

            ->make(true);
    }


}