<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business;
use App\Models\Coupon;
use App\Models\CouponServices;
use App\Models\CouponCategory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Bus;

class CouponController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;


    public function validate_coupon(Request $request)
    {
        $couponno = $request->coupon;
        
        if(null != $couponno){
            $coupon = Coupon::select('id_coupons', 'coupon_number', 'coupon_status', 'coupon_category_id',
            'coupon_category', 'coupon_category_desc', 'coupon_type', 'discount_perc', 'fixed_amount', 'coupon_category_prefix',
            DB::RAW("case when coupon_validity >= now() then 'Valid' when coupon_validity < now() then 'Expired' end as validity")
            )
            ->Join('coupon_category', 'coupon_category.id_coupon_category', '=', 'coupons.coupon_category_id')
            ->whereRaw('UPPER(coupon_number) = ?', [strtoupper($couponno)])

            ->where('coupon_category.business_id', '=',  session('business_id'))
            ->where('coupon_status', '=', 'open')
            ->first();

            //dd($coupon);

            if($coupon != null){
                $services = CouponServices::select('*')
                ->join('business_services', 'business_services.id_business_services', '=', 'coupon_services.service_id')
                ->where('coupon_category_id', '=', $coupon->coupon_category_id)
                ->get();
            }else {
                $services = [];
            }

           // dd($voucher);
            return response()->json([
                "message" => "success",
                "message_type" => "success",
                "message_btn" => "success",
                "coupon" => $coupon,
                "services" => $services
            ]);

        } else {
            return response()->json([
                "message" => "Coupon Number Not Passed To API",            
                "message_type" => "error",
                "message_btn" => "danger"
                
            ]);
        }

    }

}


