<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business;
use App\Models\PackageCategory;
use App\Models\PackageType;
use App\Models\PackageServices;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Bus;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\DB;

class DealpackagesController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function deal_packages(Request $request)
    {

        $business_id = 0;
        if(session('common_services') =="Yes"){
            $query = DB::table('business')
                ->where('ho', 'Yes')
                ->first();
            $business_id = $query->id_business;
        } else {
            $business_id = session('business_id');
        } 

        $business_data=Business::select("ho", "business_name", "id_business", "common_services", "common_products")
        ->where('id_business', session('business_id'))->first();

        if ($business_data->common_services == 'Yes' && $business_data->ho == 'No') {
            // Redirect unauthorized users to a dedicated page
           return response()->view('error.403', ['message' => 'Your deals  are managed by the Head Office.'], 403);
        }

        $package_types = PackageType::where('business_id', $business_id)
        ->leftJoin('business_type', 'business_type.id_business_type', '=', 'package_type.business_type_id')
        ->orderBy('order_id', 'ASC')    
        ->get();

        $business_types = DB::table('business_type')
        ->select('business_type.id_business_type', 'business_type.business_type');
         $business_types = $business_types->join("business", "business.business_type_id", "=", "business_type.id_business_type");
        if(session('common_services')=="Yes"){
            $business_types = $business_types->where('business.common_services', '=', "Yes");
        } else {
            $business_types = $business_types->where('business.id_business', '=', session('business_id'));
        }
        $business_types = $business_types->get();
        $business_with_common_services =  DB::table('business')->select('id_business','business_name')->where('common_services','Yes')->get();
        // Logic to handle deal packages
        return view('services.deal_packages', compact('business_id', 'package_types', 'business_types','business_with_common_services'));
    }

    //// Package Services Management ///
    public function update_package_type_order(Request $request)
    {
      
        $order = $request->input('order');

        foreach ($order as $index => $item) {
            PackageType::where('id_package_type', $item['id_package_type'])->update(['order_id' => $index + 1]);
        }

        return response()->json(['success' => true, 'message' => 'Package type order updated successfully']);
    }

    public function package_type_uploadimage(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // max 2MB
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('images/services/types'), $filename);

            return response()->json(['filename' => $filename]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }

    public function update_package_type_image(Request $request)
    {
        $id_package_type = $request->input('id_package_type');
        $image_filename = $request->input('service_type_image');

        if($image_filename == null || $image_filename == ""){
            $image_filename = $request->input('existing_type_image');
        }

        $package_type = PackageType::find($id_package_type);
        if ($package_type) {
            $package_type->service_type_image = $image_filename;
            $package_type->save();

            return response()->json(['success' => true, 'message' => 'Package type image updated successfully']);
        }

        return response()->json(['error' => 'Package type not found'], 404);
    }

    public function get_package_type($id_package_type)
    {
        if(empty($id_package_type)){
            return response()->json([
                "message" => "Error",
                "service_type" => null
            ]);
        }

        $package_type = PackageType::select("*", DB::RAW('COALESCE(service_type_image, "nu.png") as service_type_image'))
        ->leftJoin('business_type', 'business_type.id_business_type', '=', 'package_type.business_type_id')
        ->where('id_package_type', $id_package_type)
        ->first();

        $package_type_business_mapping = DB::table('package_type_business_mapping')
        ->where('package_type_id',$id_package_type)
        ->get() ?? [];
        return response()->json([
            "message" => "Success",
            "package_type" => $package_type,
            "package_type_business_mapping" => $package_type_business_mapping,
        ]);
    }

    public function save_package_type(Request $request)
    {
        try {
            // Validation
            $request->validate([
                'service_type' => 'required|string|max:255',
                'order_id' => 'required|integer',
                'expiry_date' => 'required',
            ]);

            // Prepare identifier
            $id = $request->input('id_package_type');

            // Insert or update using updateOrCreate
            $package_type = PackageType::updateOrCreate(
                ['id_package_type' => $id], // Make sure this matches your actual primary key column name
                [
                    'service_type' => $request->input('service_type'),
                    'expiry_date' => $request->input('expiry_date'),
                    'order_id' => $request->input('order_id', 0),
                    'business_id' => session('business_id'),
                    'service_type_image' => $request->input('service_type_image', 'nu.png'),
                    'service_type_active' => $request->input('service_type_active', 'Yes'),
                    // 'business_type_id' => $request->input('business_type_id', null),
                    'business_type_id' => null,
                ]
            );

           $packageTypeId = $package_type->id_package_type;
           if(isset($request->package_type_visibility_unchecked)){
                foreach ($request->package_type_visibility_unchecked as $businessId) {
                    $exists = DB::table('package_type_business_mapping')
                        ->where('business_id', $businessId)
                        ->where('package_type_id', $packageTypeId)
                        ->exists();

                    if (!$exists) {
                        DB::table('package_type_business_mapping')->insert([
                            'business_id'     => $businessId,
                            'package_type_id' => $packageTypeId,
                            'is_visible'      => 'No',
                            'created_by'      => session('user_name'),
                            'created_at'      => now(),
                        ]);
                    }
                }
            }

            if(isset($request->package_type_visibility_checked)){
                foreach ($request->package_type_visibility_checked as $businessId) {
                    DB::table('package_type_business_mapping')
                        ->where('business_id', $businessId)
                        ->where('package_type_id', $packageTypeId)
                        ->update([
                            'is_visible' => 'Yes',
                            'updated_at' => now(),
                        ]);
                }
            }

            return response()->json([
                'success' => true,
                'message' => 'Service type saved successfully',
                'id_service_type' => $package_type->id_package_type,
                'service_type' => $package_type
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => 'An error occurred: ' . $e->getMessage()
            ], 500);
        }
    }


    public function get_package_categories_by_service_type(Request $request)
    {
        $id_package_type = $request->input('id_package_type');

        $package_categories = PackageCategory::where('package_type_id', $id_package_type)
            // ->where('business_id', $business_id)
            ->orderBy('order_id', 'ASC')
            ->get();

        return response()->json([
            'package_category' => $package_categories,
            'success' => true,
            'message' => 'Package categories retrieved successfully',
            'message_btn' => 'btn btn-primary',
        ]);
    }

    public function update_category_order(Request $request)
    {
      
        $order = $request->input('order');

        foreach ($order as $index => $item) {
            DB::table('package_category')
                ->where('id_package_category', $item['id_package_category'])
                ->update(['order_id' => $index + 1]);
        }

        return response()->json([
            'success' => true, 'message' => 'Package category order updated successfully',
            'return_type_id' => $request->input('return_type_id')
        
        ]);
    }

    public function get_existing_package_category_images(Request $request)
    {
        $path = public_path('images/services/categories');
        $urls = [];

        if (File::exists($path)) {
            foreach (File::files($path) as $file) {
                $urls[] = asset('images/services/categories/' . $file->getFilename());
            }
        }

        return response()->json($urls);
    }

    public function category_uploadimage(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // max 2MB
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('images/services/categories'), $filename);

            return response()->json(['filename' => $filename]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }

    public function update_package_category_image(Request $request)
    {
        $id_package_category = $request->input('id_package_category');
        $id_package_type = $request->input('id_package_type');
        $image_filename = $request->input('service_category_image');

        if($image_filename == null || $image_filename == ""){
            $image_filename = $request->input('existing_category_image');
        }

        $package_category = PackageCategory::find($id_package_category);
        if ($package_category) {
            $package_category->service_category_image = $image_filename;
            $package_category->save();

            return response()->json([
                'success' => true, 
                'message' => 'Package category image updated successfully',
                'id_package_type' => $package_category->package_type_id,
            ]);
        }

        return response()->json(['error' => 'Package category not found'], 404);
    }

    public function get_package_category($id_package_category)
    {
        if(empty($id_package_category)){
            return response()->json([
                "message" => "Error",
                "service_category" => null
            ]);
        }

        $package_category = PackageCategory::where('id_package_category', $id_package_category)
        ->first();

        return response()->json([
            "message" => "Success",
            "package_category" => $package_category
        ]);
    }

    public function save_package_category(Request $request)
    {
        try {
            // Validation
            $request->validate([
                'service_category' => 'required|string|max:255',
                'order_id' => 'required|integer',
                'package_type_id' => 'required|integer',
                'service_category_image' => 'nullable|string|max:255',
            ]);

            // Prepare identifier
            $id = $request->input('id_package_category');

            // Insert or update using updateOrCreate
            $package_category = PackageCategory::updateOrCreate(
                ['id_package_category' => $id], // Make sure this matches your actual primary key column name
                [
                    'service_category' => $request->input('service_category'),
                    'order_id' => $request->input('order_id'),
                    'package_type_id' => $request->input('package_type_id'),
                    'business_id' => session('business_id'),
                    'service_category_active' => $request->input('service_category_active', 'Yes'),
                    'service_category_image' => $request->input('service_category_image', 'nu.png'),
                ]
            );

            return response()->json([
                'success' => true,
                'message' => 'Package category saved successfully',
                'id_package_category' => $package_category->id_package_category,
                'package_category' => $package_category
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => 'An error occurred: ' . $e->getMessage()
            ], 500);
        }
    }

    public function get_services_by_category(Request $request)
    {
        $id_package_category = $request->input('id_package_category');

        $services = PackageServices::select('package_services.*', DB::raw('COALESCE(package_category.service_category_image, "nu.png") as service_image'), 'business_services.id_business_services', 'business_services.service_name', 'business_services.service_active')
        ->leftJoin('business_services', 'business_services.id_business_services', '=', 'package_services.service_id')
        ->join('package_category', 'package_category.id_package_category', '=', 'package_services.package_category_id')
            ->where('package_category_id', $id_package_category)
            // ->where('business_id', $business_id)
            ->orderBy('package_services.package_service_optional', 'ASC')
            ->orderBy('package_services.option_for', 'ASC')
            ->get();

        return response()->json([
            'services' => $services,
            'success' => true,
            'message' => 'Services retrieved successfully',
            'message_btn' => 'btn btn-primary',
        ]);
    }

    public function get_service($id_package_service)
    {
        if(empty($id_package_service)){
            return response()->json([
                "message" => "Error",
                "service" => null
            ]);
        }

        $service = PackageServices::select('package_services.*', 
        DB::raw('COALESCE(package_category.service_category_image, "nu.png") as service_image'), 
        'business_services.service_name', 'business_services.service_active', 'package_category.service_category')
        ->leftJoin('business_services', 'business_services.id_business_services', '=', 'package_services.service_id')
        ->join('package_category', 'package_category.id_package_category', '=', 'package_services.package_category_id')
        ->where('package_services.id_package_services', $id_package_service)
        ->first();


        $package_services_business_mapping = DB::table('package_services_business_mapping')->where('package_services_id',$id_package_service)->get();

        return response()->json([
            "message" => "Success",
            "service" => $service ,
            "package_services_business_mapping" => $package_services_business_mapping 
        ]);
    }

    public function save_package_service(Request $request){
        try {
            // Validation
            $request->validate([
                'package_category_id' => 'required|integer',
                'service_id' => 'required|integer',
                'package_service_qty' => 'required|integer|min:1',
                'package_service_rate' => 'nullable|numeric',
                'package_service_optional' => 'required|string|max:3',
                'package_services_active' => 'required|string|max:3',
            ]);

            // Prepare identifier
            $id = $request->input('id_package_services');
            
            // Insert or update using updateOrCreate
            $package_service = PackageServices::updateOrCreate(
                ['id_package_services' => $id], // Make sure this matches your actual primary key column name
                [
                    'package_category_id' => $request->input('package_category_id'),
                    'service_id' => $request->input('service_id'),
                    'package_service_qty' => $request->input('package_service_qty'),
                    'service_rate' => $request->input('service_rate'),
                    'package_service_optional' => $request->input('package_service_optional', 'No'),
                    'package_services_active' => $request->input('package_services_active', 'Yes'),
                ]
            );

            $packageServiceId = $package_service->id_package_services;

            // Decode JSON arrays 
            $checked = json_decode($request->package_services_visibility_checked, true) ?? [];
            $unchecked = json_decode($request->package_services_visibility_unchecked, true) ?? [];

            foreach ($unchecked as $row) {
                $businessId = $row['business_id'];
                $price = isset($row['price']) ? $row['price'] : null;

                $exists = DB::table('package_services_business_mapping')
                    ->where('business_id', $businessId)
                    ->where('package_services_id', $packageServiceId)
                    ->exists();

                if ($exists) {
                    DB::table('package_services_business_mapping')
                        ->where('business_id', $businessId)
                        ->where('package_services_id', $packageServiceId)
                        ->update([
                            'is_visible' => 'No',
                            'price'      => $price !='' ? $price : null,
                            'updated_at' => now(),
                        ]);
                } else {
                    DB::table('package_services_business_mapping')->insert([
                        'business_id'         => $businessId,
                        'package_services_id' => $packageServiceId,
                        'is_visible'          => 'No',
                        'price'               => $price !='' ? $price : null,
                        'created_by'          => session('user_name'),
                        'created_at'          => now(),
                    ]);
                }
            }


            foreach ($checked as $row) {
                $businessId = $row['business_id'];
                $price = isset($row['price']) ? $row['price'] : null;

                $exists = DB::table('package_services_business_mapping')
                    ->where('business_id', $businessId)
                    ->where('package_services_id', $packageServiceId)
                    ->exists();

                if ($exists) {
                    DB::table('package_services_business_mapping')
                        ->where('business_id', $businessId)
                        ->where('package_services_id', $packageServiceId)
                        ->update([
                            'is_visible' => 'Yes',
                            'price'      => $price !='' ? $price : null,
                            'updated_at' => now(),
                        ]);
                } else {
                    DB::table('package_services_business_mapping')->insert([
                        'business_id'         => $businessId,
                        'package_services_id' => $packageServiceId,
                        'is_visible'          => 'Yes',
                        'price'               => $price !='' ? $price : null,
                        'created_by'          => session('user_name'),
                        'created_at'          => now(),
                    ]);
                }
            }


            // $return_package = PackageServices::select('package_category.service_category')
            // ->join('package_category', 'package_category.id_package_category', '=', 'package_services.package_category_id')
            // ->where('package_services.id_package_services', $package_service->id_package_services)
            // ->first();

            return response()->json([
                'success' => true,
                'message' => 'Package service saved successfully',
                'id_package_service' => $package_service->id_package_services,
                'package_service' => $package_service,
                'return_category_name' => $request->return_category_name,
                'return_category_id' => $request->return_category_id,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => 'An error occurred: ' . $e->getMessage()
            ], 500);
        }
    }

    public function save_service_option(Request $request){
        try {
            // Validation
            $request->validate([
                'id_package_services' => 'required|integer',
                'service_id' => 'required|integer',                
            ]);

            // Get the oringinal service to copy details from
            $original_service = PackageServices::where('id_package_services', $request->input('id_package_services'))->first();
            if(!$original_service){
                return response()->json([
                    'error' => true,
                    'message' => 'Original service not found'
                ], 404);
            }

            $price = optional(
                DB::table('package_services_business_mapping')
                    ->where('business_id', session('business_id'))
                    ->where('package_services_id', $request->input('id_package_services'))
                    ->where('is_visible', 'Yes')
                    ->whereNotNull('price')
                    ->first()
            )->price ?? $original_service->service_rate;


            // get count of existing options for this service
            $existing_options_count = PackageServices::where('option_for', $request->input('id_package_services'))->where('package_services_active', 'Yes')->count();

            // Insert new service option
            $package_service_option = new PackageServices();
            $package_service_option->package_category_id = $original_service->package_category_id;
            $package_service_option->service_id = $request->input('service_id');
            $package_service_option->package_option_number = $existing_options_count + 1;
            $package_service_option->package_service_qty = $original_service->package_service_qty;
            $package_service_option->service_rate = $price;
            $package_service_option->package_service_optional = 'Yes';
            $package_service_option->package_services_active = 'Yes';
            $package_service_option->option_for = $request->input('id_package_services');
            $package_service_option->save();
            return response()->json([
                'success' => true,
                'message' => 'Service option saved successfully',
                'id_package_service_option' => $package_service_option->id_package_services,
                'package_service_option' => $package_service_option,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => 'An error occurred: ' . $e->getMessage()
            ]);
        }
    }

    public function deactivate_package_service($id_package_services, Request $request)
    {
        //$id_package_service = $request->input('id_package_service');
        try{
            $package_service = PackageServices::find($id_package_services);
            if ($package_service) {
                $package_service->package_services_active = 'No';
                $package_service->save();

                return response()->json(['success' => true, 'message' => 'Package service deactivated successfully']);
            }

            return response()->json(['error' => 'Package service not found'], 404);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => 'An error occurred: ' . $e->getMessage()
            ]);
        }
    }

    public function open_all_packages_list(Request $request)
    {
        // Determine business_id
        if (session('common_services') == "Yes") {
            $query = DB::table('business')
                ->where('ho', 'Yes')
                ->first();
            $business_id = $query->id_business ?? 0;
        } else {
            $business_id = session('business_id');
        }

        // Fetch all package data
        $package_types = PackageType::where('package_type.business_id', $business_id)
            ->select(
                'business_type.business_type',
                'package_type.id_package_type',
                'package_type.service_type',
                'package_type.service_type_active',
                'package_services.option_for',
                DB::raw('COALESCE(package_type.service_type_image, "nu.png") as service_type_image'),
                'package_category.id_package_category',
                'package_category.service_category',
                'package_category.service_category_active',
                DB::raw('COALESCE(package_category.service_category_image, "nu.png") as service_category_image'),
                'package_services.id_package_services',
                'package_services.package_service_qty',
                'package_services.service_rate',
                'package_services.package_service_optional',
                'package_services.package_services_active',
                'business_services.id_business_services',
                'business_services.service_name',
                'business_services.service_active'
            )
            ->leftJoin('package_category', 'package_category.package_type_id', '=', 'package_type.id_package_type')
            ->leftJoin('package_services', 'package_services.package_category_id', '=', 'package_category.id_package_category')
            ->leftJoin('business_services', 'business_services.id_business_services', '=', 'package_services.service_id')
            ->leftJoin('business_type', 'business_type.id_business_type', '=', 'package_type.business_type_id')
            ->orderBy('id_package_type', 'ASC')
            ->orderBy('id_package_category', 'ASC')
            ->orderBy('id_package_services', 'ASC')
            ->get();
        
        // Convert to plain objects to allow safe dynamic property assignment
        // Convert to plain objects safely
        $package_types = $package_types->map(function ($item) {
            return (object) $item->toArray();
        });

        //return $package_types;
        // Build index only for valid services
        $indexed = [];
        foreach ($package_types as $service) {
            if (!empty($service->id_package_services)) {
                $service->options = [];
                $indexed[$service->id_package_services] = $service;
            }
        }

        // Build final nested list
        $final = [];
        foreach ($package_types as $service) {
            // Skip invalid services (no id)
            if (empty($service->id_package_services)) {
                continue;
            }

            // Attach options to their parent if applicable
            if (!empty($service->option_for) && isset($indexed[$service->option_for])) {
                $indexed[$service->option_for]->options[] = $service;
            } else {
                $final[] = $service;
            }
        }
        //return $final;
        return view('services.all_packages_list', [
            'business_id' => $business_id,
            'package_types' => $final
        ]);
    }


}