<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\CustomerVisits;
use App\Models\Business;

class FeedbackController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;


    public function visitors(Request $request)
    {

        $day = $request->day ?? date('Y-m-d');

        $business_id = $request->business_id ?? session('business_id');

        $visits = CustomerVisits::select(
            'customer_visits.id_customer_visits', 
            'customer_visits.visit_color',
            'customer_visits.customer_id', 
            'customer_visits.visit_status',
            'customers.customer_name', 
            'customers.customer_cell', 
            'visit_services.id_visit_services',
            'visit_services.s_type',
            'visit_services.s_category',
            'visit_services.service_name',
            'visit_services.visit_service_start', 
            'visit_services.visit_service_end', 
            'visit_services.visit_service_status'
            )
            ->join('visit_services', 'customer_visits.id_customer_visits', '=', 'visit_services.customer_visit_id')
            ->join('customers', 'customer_visits.customer_id', '=', 'customers.id_customers')
            ->where('customer_visits.business_id', '=', $business_id)
            ->whereDate('visit_services.visit_service_start', '=', $day)
            ->whereIn('customer_visits.visit_status', ['open', 'invoiced'])        
            ->orderBy('id_customer_visits', 'asc', 'visit_services.visit_service_start', 'asc')
            ->get();

        if(session('ho')=="Yes"){
            $ho_business_id = Business::where('ho', 'Yes')->pluck('id_business')->toArray();
        }else{
            $ho_business_id = [session('business_id')];
        }

        $branches = DB::table('business')
            ->whereIn('id_business', $ho_business_id)
            ->get();

        return view('feedback.day_visitors_list', compact('visits', 'business_id', 'branches'));
    }

    public function give_feedback(Request $request)
    {
        $visit_service_id = $request->visit_service_id;

        // Additional logic to retrieve visit/service details can be added here

        return view('feedback.give_feedback', compact('visit_service_id'));
    }

    public function save_feedback(Request $request)
    {
        $data = $request->validate([
            'customer_id' => 'required|integer',
            'invoice_id' => 'nullable|integer',
            'visit_id' => 'required|integer',
            'business_id' => 'required|integer',
            'qos' => 'required|integer|min:1|max:5',
            'atmosphere' => 'required|integer|min:1|max:5',
            'experience' => 'required|integer|min:1|max:5',
            'valueformoney' => 'required|integer|min:1|max:5',
            'recommendable' => 'required|boolean',
            'comment' => 'nullable|string',
            'feedback_type' => 'required|string',
            // Add validation for signatures if needed
        ]);

        $data['created_on'] = now();

        \App\Models\Feedback::create($data);

        return redirect()->route('visitors')->with('success', 'Feedback submitted successfully.');
    }
}
