<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


use App\Models\Business;
use App\Models\OrderVouchers;
use App\Models\Customers;
use App\Models\AccountVouchers;
use App\Models\AccountVoucherDetail;
use App\Models\AccountEventMapping;


use Illuminate\Support\Facades\Bus;
use Carbon\Carbon;


class GiftVoucherController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;


    public function validate_voucher(Request $request)
    {
        $voucher_no = $request->voucher_no;
        
        if(null != $voucher_no){
            $voucher = OrderVouchers::select('order_vouchers.*', 'id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_email')
            ->leftJoin('customers', 'customers.id_customers', '=', 'order_vouchers.customer_id')
            ->where('voucher_number', '=', $voucher_no)
            ->where('valid_until', '>=', date('Y-m-d H:i:s'))
            ->first();

           // dd($voucher);
            return response()->json([
                "message" => "success",
                "message_type" => "success",
                "message_btn" => "success",
                "data" => $voucher
            ]);

        } else {
            return response()->json([
                "message" => "Voucher Number Not Passed To API",            
                "message_type" => "error",
                "message_btn" => "danger"
                
            ]);
        }

    }

    public function gift_vouchers(Request $request)
    {
        $business_id = session('business_id');
        $business = Business::find($business_id);

        $today = date('Y-m-d');

        return view('gift_vouchers.gift_vouchers', compact('business', 'today'));
    }

    public function todays_vouchers(Request $request)
    {
        $business_id = session('business_id');
        $business = Business::find($business_id);

        $today = date('Y-m-d');

        return view('todays_vouchers.todays_vouchers', compact('business', 'today'));
    }

   public function giftvouchersdata(Request $request)
    {
        $business_id = session('business_id');
        $today = $request->filled('start_date');
        
        // Check if this is Today's Vouchers (uses DATE =) or Gift Vouchers (uses DATE >=)
        // DataTables sends boolean as string "true" or "false" in GET requests
        $isTodaysVouchers = false;
        if ($request->filled('is_todays_vouchers')) {
            $flagValue = $request->get('is_todays_vouchers');
            // Handle boolean true, string "true", integer 1, or string "1"
            $isTodaysVouchers = ($flagValue === true || 
                                $flagValue === 'true' || 
                                $flagValue === 1 || 
                                $flagValue === '1');
        }

        $query = OrderVouchers::select(
            'order_vouchers.id_order_vouchers',
            'order_vouchers.voucher_number',
            DB::raw('DATE_FORMAT(order_vouchers.voucher_date, "%d-%m-%Y") as voucher_date'),
            DB::raw('DATE_FORMAT(order_vouchers.valid_until, "%d-%m-%Y") as valid_until'),
            'order_vouchers.amount',
            'order_vouchers.type',
            'order_vouchers.remaining_amount',
            'order_vouchers.service_names',
            'order_vouchers.voucher_status',
            'customers.customer_name',
            'customers.customer_cell',
            'customers.customer_email'
        )
        ->leftJoin('customers', 'customers.id_customers', '=', 'order_vouchers.customer_id')
        ->where('order_vouchers.business_id', '=', $business_id);

        // Date filter - use DATE = for Today's Vouchers, DATE >= for Gift Vouchers
        if ($request->filled('start_date')) {
            $startDate = date('Y-m-d', strtotime($request->get('start_date')));
            if ($isTodaysVouchers) {
                // Today's Vouchers: exact date match
                $query->whereDate('order_vouchers.voucher_date', '=', $startDate);
            } else {
                // Gift Vouchers: greater than or equal to date
                $query->whereDate('order_vouchers.voucher_date', '>=', $startDate);
            }
        }

        // Optional search (DataTables global search)
        if ($search = $request->get('search')['value'] ?? null) {
            $query->where(function ($q) use ($search) {
                $q->where('order_vouchers.voucher_code', 'like', "%{$search}%")
                ->orWhere('customers.customer_name', 'like', "%{$search}%")
                ->orWhere('customers.customer_cell', 'like', "%{$search}%")
                ->orWhere('customers.customer_email', 'like', "%{$search}%");
            });
        }

        // Total records count
        $recordsTotal = $query->count();

        // Pagination
        $start = $request->get('start', 0);
        $length = $request->get('length', 10);
        $data = $query->skip($start)->take($length)->get();

        return response()->json([
            'draw' => intval($request->get('draw')),
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsTotal,
            'data' => $data,
            'today' => $today
        ]);
    }

    public function gift_voucher($id_gift_voucher)
    {
        
        $voucher = OrderVouchers::select('order_vouchers.*', 'id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_email')
            ->leftJoin('customers', 'customers.id_customers', '=', 'order_vouchers.customer_id')
            ->where('order_vouchers.id_order_vouchers', '=', $id_gift_voucher)
            ->first();

        return response()->json([
            "message" => "success",
            "message_type" => "success",
            "message_btn" => "success",
            "data" => $voucher
        ]);
    }

    public function gift_voucher_print($id_gift_voucher)
    {
        
        $voucher = OrderVouchers::select('order_vouchers.*', 'id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_email')
            ->leftJoin('customers', 'customers.id_customers', '=', 'order_vouchers.customer_id')
            ->where('order_vouchers.id_order_vouchers', '=', $id_gift_voucher)
            ->first();

        $business_id = session('business_id');
        $business = Business::find($voucher->business_id);

        $services = [];
        if($voucher->type == "service" && $voucher->service_ids != null){
            $service_ids = explode(",", $voucher->service_ids);
            $services = DB::table('business_services')->whereIn('id_business_services', $service_ids)->get();
        }
    
        return view('gift_vouchers.gift_voucher_print', compact('business', 'voucher', 'services'));
    }

    public function create_gift_voucher(Request $request)
    {
        //return response()->json($request->data);
        try {
            DB::beginTransaction();

            $data=$request->data;
            //return response()->json($data);

            $business_id = session('business_id');
            $id_customer = $data['id_customer'];

            //get customer
            $customer = Customers::find($id_customer);

            $gift_voucher_type = $data['gift_voucher_type'];
            $amount_or_service_price = $data['amount_or_service_price'];
            $tax = $data['tax'];
            $cc_fee = $data['cc_fee'];
            $services = $data['services'];

            $service_names = $data['service_names'];
            $payment_mode = $data['payment_mode'];
            $valid_until = $data['valid_until'];

            $paid_cash = 0;
            $paid_card = 0;
            $paid_check = 0;
            $paid_online = 0;
            if($data['payment_mode'] == "Cash"){
                $paid_cash = $amount_or_service_price + $tax;
            } else if($data['payment_mode'] == "Card"){
                $paid_card = $amount_or_service_price + $tax + $cc_fee;
            } else if($data['payment_mode'] == "D-Card"){
                $paid_card = $amount_or_service_price + $tax;            
            } else if($data['payment_mode'] == "Check"){
                $paid_check = $amount_or_service_price + $tax;
            } else if($data['payment_mode'] == "Online"){
                $paid_online = $amount_or_service_price + $tax;
            }

            // Get the next voucher number
            $last_voucher = OrderVouchers::select('order_vouchers.*');
            if(session('common_products')=="Yes"){
                $last_voucher = $last_voucher->where('business.ho', '=', "Yes");
            } else {
                $last_voucher = $last_voucher->where('order_vouchers.business_id', '=', $business_id);
            }
            $last_voucher =  $last_voucher->join('business', 'business.id_business', '=', 'order_vouchers.business_id')
                ->orderBy('id_order_vouchers', 'desc')
                ->first();
            
            $next_voucher_number = $last_voucher ? $last_voucher->id_order_vouchers + 1 : 1;

            $voucher_number = 'C' . $next_voucher_number;

            $voucher = new OrderVouchers();
            $voucher->business_id = $business_id;
            $voucher->customer_id = $id_customer;
            $voucher->voucher_number = $voucher_number;
            $voucher->voucher_heading = $data['voucher_heading'] ?? 'Gift Voucher';
            $voucher->type = $gift_voucher_type;
            $voucher->amount = $amount_or_service_price + $tax;
            $voucher->voucher_date = date('Y-m-d H:i:s');
            $voucher->valid_until = $valid_until;
            $voucher->service_ids = $services;
            $voucher->service_names = $service_names;
            $voucher->remaining_service_ids = $services ?? '';
            $voucher->voucher_tax = $tax;
            $voucher->remaining_amount = $amount_or_service_price + $tax;
            $voucher->created_by = session('user_name');
            $voucher->voucher_value = $amount_or_service_price;
            $voucher->voucher_cccharge = $data['cc_fee'];
            $voucher->paid_cash = $paid_cash;
            $voucher->paid_card = $paid_card;
            $voucher->paid_check = $paid_check;
            $voucher->paid_online = $paid_online;
            $voucher->instrument_number = $data['instrument_number'];
            $voucher->payment_mode = $data['payment_mode'];
            $voucher->voucher_status = 'open';

            $voucher->save();

            if ($voucher->id_order_vouchers) {
                //Create Account Voucher
                $account_voucher = new AccountVouchers();
                $account_voucher->voucher_date = Carbon::now();            
                $account_voucher->voucher_type = 2; //Receipt
                $account_voucher->voucher_status = 'Active';
                $account_voucher->created_by = session('user_name');
                $account_voucher->created_on = date('Y-m-d H:i:s');
                $account_voucher->order_voucher_id = $voucher->id_order_vouchers;
                $account_voucher->sale_type = 'voucher';        
                $account_voucher->id_account_head = 24; //1 = Accounts Receivable
                $account_voucher->voucher_date = Carbon::now();
                $account_voucher->description = 'Gift Voucher sold with Voucher '.$voucher->voucher_number.' on '.Carbon::now().', for '.$customer->customer_name.' customer ID : '.$id_customer;
                $account_voucher->business_id = $voucher->business_id;
                $account_voucher->voucher_amount = $amount_or_service_price + $tax;
                $account_voucher->cost_center = 1;
                $account_voucher->cost_center_name = 'Front Desk';
                $account_voucher->business_partner = '1';
                $account_voucher->business_partner_id = $id_customer;
                $account_voucher->business_partner_name = $customer->customer_name;        
                $account_voucher->payment_mode = $voucher->payment_mode;
                $account_voucher->auto_voucher = 'Yes';

                $account_voucher->save();
                $new_voucher_id = $account_voucher->id_account_vouchers;

                //Create Account Voucher Detail
                //Get the event mappings for Invoice Creation id_events = 1
                //business id for Ho if 'ho_accounts' = 'Yes'            
                if(session('ho_accounts')=='Yes'){
                    $new_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                } else {
                    $new_business_id = $voucher->business_id;
                }
                $event_mappings = AccountEventMapping::where('account_event_id', 1)->where('business_id', $new_business_id)->get();
                $debit_amounts = [];
                $credit_amounts = [];
                $debit_accounts = array();
                $credit_accounts = array();

                foreach($event_mappings as $mapping){                    
                    if($mapping['transaction_type']=='debit'){
                        array_push($debit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    } else {
                        array_push($credit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    }
                   
                    if($mapping['transaction_type']=='debit'){
                        //make debit entry data
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Cash'  ? $paid_cash : 0 ]);}
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Mixed'  ? $paid_cash : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Card'  || $payment_mode == 'D-Card' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Mixed' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_check'){array_push($debit_amounts, [ 'entity_name' => 'paid_check', 'amount' => $payment_mode == 'Check' ? $paid_check : 0 ]);}
                        if($mapping['entity_name']=='paid_online'){array_push($debit_amounts, [ 'entity_name' => 'paid_online', 'amount' => $payment_mode=="Online" ? $paid_online : 0 ]);}
             
                    } else if($mapping['transaction_type']=='credit'){
                        //make credit entry data
                        if($mapping['entity_name']=='cc_fee'){array_push($credit_amounts, [ 'entity_name' => 'cc_fee', 'amount' => $cc_fee ]);}   
                        if($mapping['entity_name']=='sales_tax'){array_push($credit_amounts, [ 'entity_name' => 'sales_tax', 'amount' => $tax ]);}
                        if($mapping['entity_name']=='grosstotal_voucher'){array_push($credit_amounts, [ 'entity_name' => 'grosstotal_voucher', 'amount' => $amount_or_service_price ]);}
                     
                    }
                }
                //get the sum of debit amounts and credit amounts
                $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;

                if($debit_sum == null || $credit_sum == null || $debit_sum != $credit_sum){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit and Credit amounts do not match. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "btn btn-danger"
                    ]);
                } else if($debit_sum == 0 || $credit_sum == 0){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit or Credit amounts are zero. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "btn btn-danger"
                    ]);
                }else{                    
                    //Insert voucher Details
                    foreach($debit_accounts as $debit){
                        $debit_parts = explode("|", $debit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $debit_parts[0];
                        $entity = $debit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->debit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $debit_amounts));
                        $new_voucher_details->credit = 0;    
                        if($new_voucher_details->debit != 0){                                            
                            $new_voucher_details->save();
                        }
                    }
                    foreach($credit_accounts as $credit){
                        $credit_parts = explode("|", $credit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $credit_parts[0];
                        $new_voucher_details->debit = 0;
                        $entity = $credit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->credit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $credit_amounts));
                        if($new_voucher_details->credit != 0){           
                            $new_voucher_details->save();
                        }
                    }
                }
            }
            DB::commit();
            return response()->json([
                "message" => "Gift Voucher Created Successfully",
                "message_type" => "success",
                "message_btn" => "btn btn-success",
                "data" => $voucher
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                "message" => "Error Creating Gift Voucher: " . $e->getMessage(),
                "message_type" => "error",
                "message_btn" => "btn btn-danger"
            ]);
        }
    } 
    
    public function update_gift_voucher(Request $request)
    {
       // return $request->voucher_id;
        try {
            DB::beginTransaction();

            $id_gift_voucher = $request->voucher_id;
            $voucher = OrderVouchers::find($id_gift_voucher);

            if(!$voucher){
                return response()->json([
                    "message" => "Gift Voucher Not Found",
                    "message_type" => "error",
                    "message_btn" => "btn btn-danger"
                ]);
            }

            $voucher->valid_until = $request->valid_until;
            $voucher->voucher_status = $request->voucher_status;
            $voucher->remaining_amount = $request->remaining_amount;
            $voucher->voucher_heading = $request->voucher_heading;
            $voucher->voucher_number = $request->voucher_number;

            $voucher->save();

            DB::commit();
            return response()->json([
                "message" => "Gift Voucher Updated Successfully",
                "message_type" => "success",
                "message_btn" => "btn btn-success",
                "data" => $voucher
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                "message" => "Error Updating Gift Voucher: " . $e->getMessage(),
                "message_type" => "error",
                "message_btn" => "btn btn-danger"
            ]);
        }
    }

}


