<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Bus;
use App\Models\Invoice;
use App\Models\Business;
use App\Models\BusinessTaxes;
use App\Models\CustomerVisits;
use App\Models\VisitAdvance;
use App\Models\VisitServices;
use App\Models\Customers;
use App\Models\AccountEventMapping;
use App\Models\AccountVoucherDetail;
use App\Models\AccountVouchers;
use App\Models\CustomerOrders;
use App\Models\Discount;
use App\Models\InvoiceDetails;
use App\Models\InvoiceProducts;
use App\Models\InvoiceVisitProducts;
use App\Models\InvoiceStaff;
use App\Models\OrderProducts;
use App\Models\Services;
use App\Models\ServicesProducts;
use App\Models\SMSCred;
use App\Models\VisitServiceStaff;
use App\Models\Staff;
use App\Models\Products;
use App\Models\OrderVouchers;
use App\Models\Stores;
use App\Models\onlineOrderLog;

use App\Services\SMSService;
use App\Services\productBatchService;

use Carbon\Carbon;

new \App\Models\InvoiceDetails;
new \App\Models\AccountVouchers;
new \App\Models\SMSCred;

new \App\Services\SMSService;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Pest\ArchPresets\Custom;

use Illuminate\Support\Facades\Session;

class InvoiceController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function today_invoices(Request $request, $feedback_status=null, $sort_order='asc', $invoice_status='valid', $sh=false, $mdate=null, $customer_id=null)
    {

        // handle date
        if (empty($request->customer_id)) {
            $today = $request->start_date ?? date('Y-m-d');            
        }

        $business = Business::select('id_business', 'business_name', 'imsfiscal', 'imsfiscal_r', 'srb_fiscal_service', 'srb_fiscal_sale', 'sh_hide', 's_min_sh')
            ->where('id_business', session('business_id'))
            ->first();

        return view('invoicing.today_invoices', compact('today', 'feedback_status', 'invoice_status', 'sort_order', 'sh', 'customer_id', 'business'));
    }

    public function todayinvoicesdata(Request $request)
    {
        $baseQuery = Invoice::select(
                '*',
                DB::raw('DATE_FORMAT(invoice_date, "%h:%i") as invoice_time'),
                DB::raw('DATE_FORMAT(invoice_date, "%d-%c-%Y") as invoice_date_formatted'),
                DB::raw('DATE_FORMAT(visit_time, "%d-%c-%Y %H:%i") as visit_time_formatted')
            )
            ->where('business_id', session('business_id'));

        // --- filters ---
        if (empty($request->mdate)) {
            $today = $request->start_date ?? date('Y-m-d');
            $baseQuery->whereDate('invoice_date', '=', $today);
        } else {
            $today = $request->mdate;
        }

        $baseQuery->when($request->filled('feedback_status'), fn($q) =>
            $q->where('feedback_status', $request->feedback_status)
        );

        $baseQuery->when($request->invoice_status === 'valid', fn($q) =>
            $q->where('invoice_status', 'valid')
        );

        $baseQuery->when($request->filled('customer_id'), fn($q) =>
            $q->where('invoice.customer_id', $request->customer_id)
        );

        if ($request->boolean('sh') || session('role') === "Sh-Users") {
            $baseQuery->where('invoice.invoice_seq', '>', 0);
        }

        // --- searching ---
        if (!empty($request->search['value'])) {
            $search = $request->search['value'];
            $baseQuery->where(function ($q) use ($search) {
                $q->where('invoice_number', 'like', "%{$search}%")
                ->orWhere('customer_name', 'like', "%{$search}%")
                ->orWhere('invoice_type', 'like', "%{$search}%")
                ->orWhere('invoice_status', 'like', "%{$search}%")
                ->orWhere('remarks', 'like', "%{$search}%")
                ->orWhere('discount_remarks', 'like', "%{$search}%")
                ->orWhere('instrument_number', 'like', "%{$search}%")
                ->orWhere('payment_mode', 'like', "%{$search}%")
                ;
            });
        }

        // --- clone for totals (before pagination/ordering) ---
        $totalsQuery = (clone $baseQuery);
        
        // add your extra where condition only for totals
        $totalsQuery->where('invoice_status', 'valid');
        
        $totals = $totalsQuery
            ->selectRaw('round(SUM(paid_amount),2) as total_paid, round(SUM(balance),2) as total_balance')
            ->first();

        // --- ordering ---
        if ($request->has('order')) {
            $columns = $request->columns;
            foreach ($request->order as $order) {
                $colIndex = $order['column'];
                $colName  = $columns[$colIndex]['data'];
                $dir      = $order['dir'];
                $baseQuery->orderBy($colName, $dir);
            }
        } else {
            $baseQuery->orderBy('id_invoice', 'asc');
        }

        // --- pagination ---
        $recordsTotal = $baseQuery->count();
        $start  = $request->start ?? 0;
        $length = $request->length ?? 10;

        if ($length != -1) {
            $baseQuery->skip($start)->take($length);
        }

        $invoices = $baseQuery->get();

        return response()->json([
            "draw" => intval($request->draw),
            "recordsTotal" => $recordsTotal,
            "recordsFiltered" => $recordsTotal,
            "data" => $invoices,
            "totals" => [
                "paid_amount" => $totals->total_paid ?? 0,
                "balance"     => $totals->total_balance ?? 0,
            ]
        ]);
    }

    public function existing_invoice($invoice_id)
    {
        $invoice = Invoice::find($invoice_id);
        if (!$invoice) {
            return redirect()->back()->with('error', 'Invoice not found.');
        }

        $checkquery = Invoice::where('id_invoice', $invoice_id)->first();
        if ($checkquery->invoice_type == 'service') {
            $query = Invoice::select(
                'invoice.*', 'invoice.discount as idiscount', 'invoice.cc_charge as icc_charge', 
                'invoice_details.discounted_price as ddiscounted_price', 'invoice_details.service_name as dservice_name', 
                'invoice_details.price as dprice', 'invoice_details.taxes as dtaxes', 'invoice_details.final_price as dfinal_price',
                'invoice_details.service_type as dservice_type', 'invoice_details.service_category as dservice_category',
                'invoice_details.discount as dservice_discount', 
                'invoice_details.service_addition as dservice_addition', 'invoice_staff.*',
                 'business.business_name', 'business.business_logo', 'business.business_address',
                  'business.business_phone1 as business_phone', 'business.business_email',
                DB::raw('DATE_FORMAT(invoice_date, "%h:%i") as invoice_time'),
                DB::raw('DATE_FORMAT(invoice_date, "%d-%c-%Y") as invoice_date_formatted'),
                DB::raw('DATE_FORMAT(visit_time, "%d-%c-%Y %H:%i") as visit_time_formatted'),
                DB::raw('GROUP_CONCAT(distinct(invoice_staff.staff_name) ORDER BY invoice_staff.additional_staff desc SEPARATOR "<br>") as staff_names'),
                DB::raw('GROUP_CONCAT(distinct(invoice_visit_products.product_name) SEPARATOR "<br>") as invoice_products')
            )
            ->join('business', 'invoice.business_id', '=', 'business.id_business')
            ->leftJoin('invoice_details', 'invoice.id_invoice', '=', 'invoice_details.invoice_id')
            ->leftJoin('invoice_staff', 'invoice_details.id_invoice_details', '=', 'invoice_staff.invoice_detail_id')            
            ->leftJoin('invoice_visit_products', function ($join) {
                    $join->on('invoice.id_invoice', '=', 'invoice_visit_products.invoice_id')
                        ->on('invoice_visit_products.service_id', '=', 'invoice_details.service_id');
                })
            
            ->groupBy('invoice.id_invoice', 'invoice_details.id_invoice_details', 'invoice_number', 'invoice_details.service_id',
            'invoice_date', 'customer_id', 'invoice.customer_name', 'invoice.customer_cell', 'invoice.customer_email', 
            'invoice.customer_address', 'invoice.business_id')           
            ;
            if($checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number) {
                $query = $query->where('id_invoice', $checkquery->org_invoice_id);
            } else {
                $query = $query->where('id_invoice', $invoice_id);
            }
            //return $query->toSql(); exit();
        } elseif($checkquery->invoice_type == 'sale')  {
            $query = Invoice::select(
                'invoice.*', 'invoice.discount as idiscount', 'invoice.cc_charge as icc_charge', 'invoice_products.discounted_price as ddiscounted_price', 
                'invoice_products.product_name', 'invoice_products.price', 'invoice_products.brand_name',
                'invoice_products.discount as dservice_discount', 'invoice_products.service_addition as dservice_addition', 
                'invoice_products.invoice_qty', 'invoice_products.staff_name as staff_names', 'invoice_products.batch_id', 'invoice_products.batch as batch_number',
                'invoice_products.taxes as dtaxes', 'invoice_products.final_price', 'invoice.other_charges as iother_charges',
                'business.business_name', 'business.business_logo', 'business.business_address', 'business.business_phone1 as business_phone', 'business.business_email',
                DB::raw('DATE_FORMAT(invoice_date, "%h:%i") as invoice_time'),
                DB::raw('DATE_FORMAT(invoice_date, "%d-%c-%Y") as invoice_date_formatted'),
                DB::raw('DATE_FORMAT(visit_time, "%d-%c-%Y %H:%i") as visit_time_formatted')              
                
            )
            ->join('business', 'invoice.business_id', '=', 'business.id_business')
            ->leftJoin('invoice_products', 'invoice.id_invoice', '=', 'invoice_products.invoice_id')        
           
            ->groupBy('invoice.id_invoice', 'invoice_products.id_invoice_products')           
            ;
             if($checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number) {
                $query = $query->where('invoice_number', $checkquery->reference_invoice_number);
            } else {
                $query = $query->where('id_invoice', $invoice_id);
            }
        }

        $invoice = $query->get();
            // return $invoice;
        $business = DB::table('business')
            ->where('id_business', session('business_id'))
            ->first();
        
        // Assuming you have a view named 'invoicing.existing_service_invoice'
        return view('invoicing.existing_invoice', compact('invoice', 'business', 'checkquery'));
    }
   
    public function recovery_invoices(Request $request)
    {
       
        return view('invoicing.recovery_invoices');
    }

    public function recoveryinvoicesdata(Request $request)
    {
        
        $baseQuery = Invoice::select(
                '*',
                DB::raw('DATE_FORMAT(invoice_date, "%h:%i") as invoice_time'),
                DB::raw('DATE_FORMAT(invoice_date, "%d-%c-%Y") as invoice_date_formatted'),
                DB::raw('DATE_FORMAT(visit_time, "%d-%c-%Y %H:%i") as visit_time_formatted')
            )
            ->where('business_id', session('business_id'))
            ->where('is_recovery', '=', 'Yes')
            ->where('invoice_status', '=', 'valid');

        // --- filters ---
        if (empty($request->mdate)) {
            // $today = $request->start_date ?? date('Y-m-d');
            // $baseQuery->whereDate('invoice_date', '=', $today);
        } else {
            $today = $request->mdate;
        }

       
        $baseQuery->when($request->filled('customer_id'), fn($q) =>
            $q->where('invoice.customer_id', $request->customer_id)
        );

        if ($request->boolean('sh') || session('role') === "Sh-Users") {
            $baseQuery->where('invoice.invoice_seq', '>', 0);
        }

        // --- searching ---
        if (!empty($request->search['value'])) {
            $search = $request->search['value'];
            $baseQuery->where(function ($q) use ($search) {
                $q->where('invoice_number', 'like', "%{$search}%")
                ->orWhere('customer_name', 'like', "%{$search}%")
                ->orWhere('invoice_type', 'like', "%{$search}%")
                ->orWhere('invoice_status', 'like', "%{$search}%")
                ->orWhere('remarks', 'like', "%{$search}%")
                ->orWhere('discount_remarks', 'like', "%{$search}%")
                ->orWhere('instrument_number', 'like', "%{$search}%")
                ->orWhere('payment_mode', 'like', "%{$search}%")
                ;
            });
        }

        // --- clone for totals (before pagination/ordering) ---
        $totalsQuery = (clone $baseQuery);

        
        $totals = $totalsQuery
            ->selectRaw('round(SUM(paid_amount),2) as total_paid, round(SUM(balance),2) as total_balance')
            ->first();

        // --- ordering ---
        if ($request->has('order')) {
            $columns = $request->columns;
            foreach ($request->order as $order) {
                $colIndex = $order['column'];
                $colName  = $columns[$colIndex]['data'];
                $dir      = $order['dir'];
                $baseQuery->orderBy($colName, $dir);
            }
        } else {
            $baseQuery->orderBy('id_invoice', 'asc');
        }

        // --- pagination ---
        $recordsTotal = $baseQuery->count();
        $start  = $request->start ?? 0;
        $length = $request->length ?? 10;

        if ($length != -1) {
            $baseQuery->skip($start)->take($length);
        }

       // print_r($baseQuery->toSql()); exit();
        $invoices = $baseQuery->get();

        return response()->json([
            "draw" => intval($request->draw),
            "recordsTotal" => $recordsTotal,
            "recordsFiltered" => $recordsTotal,
            "data" => $invoices,
            "totals" => [
                "paid_amount" => $totals->total_paid ?? 0,
                "balance"     => $totals->total_balance ?? 0,
            ]
        ]);
    }

    public function new_recovery_invoice($id_invoice = null){

        if(empty($id_invoice) || $id_invoice < 1 || null == $id_invoice){
             return back()->withErrors([
                'message' => 'Invoice ID not passed to the API.',
            ]);
        }

        //Get the original Invoice against which the new recovery will be made
        $invoice = Invoice::select('*', 'invoice.business_id')        
        ->where('id_invoice', '=', $id_invoice)
        ->first();

       
        if(!$invoice){
             return back()->withErrors([
                'message' => 'Original Invoice not found.',
            ]);
        }

        if($invoice->invoice_type=="service"){
            $invoice_services = InvoiceDetails::select('*')
            ->where('invoice_id', '=', $id_invoice)
            ->get();
        } else {
            $invoice_services = InvoiceProducts::select('*')
            ->where('invoice_id', '=', $id_invoice)
            ->get();
        }



        $business = Business::select('id_business', 'business_name', 'business_logo', 'business_address', 'business_phone1', 'business_email', 'cc_charge', 'imsfiscal', 'imsfiscal_r', 'srb_fiscal_service', 'srb_fiscal_sale', 'sh_hide', 's_min_sh', 'l_point_discount')
        ->where('id_business', '=', $invoice->business_id)
        ->first();

        

        //get customer loyatly
        $customer = Customers::select('id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_area', 
        DB::RAW('COALESCE(customers.customer_address, "") as customer_address'), 'customers.customer_email',
        DB::RAW('CASE WHEN sum(loyalty_earned) - sum(loyalty_used)  > 0 THEN round(sum(loyalty_earned) - sum(loyalty_used)) ELSE 0 END  as loyalty_points')
        )
        ->leftJoin('invoice', "invoice.customer_id", "=", "customers.id_customers")
        ->where('id_customers', '=', $invoice->customer_id)
        ->where('invoice.invoice_status', '=', 'valid')
        ->groupby('id_customers')
        ->first();


        if(session('ho_accounts')=='Yes'){
            $common_business_id = Business::where('business.ho', 'Yes')->value('id_business');
        } else {
            $common_business_id = $invoice->business_id;
        }
         //Get retained amount
         $account_head = AccountEventMapping::select('id_account_event_mapping', 'account_event_id', 'account_head_id', 'account_head')
        ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
        ->where('account_event_mapping.business_id', '=',  $common_business_id)
        ->where('account_heads.business_id', '=', $common_business_id)
        ->where('entity_name', '=', 'retained_amount')
        ->where('account_event_id', '=', '1')
        ->first();

        $retained_account = $account_head->account_head_id;
        if(null != $retained_account && $retained_account > 0){
            $query = AccountVoucherDetail::select('account_head_id', DB::RAW('sum(credit) - sum(debit) as retained_amount'))
            ->join('account_vouchers', 'account_vouchers.id_account_vouchers', '=', 'account_voucher_detail.account_voucher_id')
            ->where('account_head_id', '=', $retained_account)
            ->where('account_vouchers.business_partner_id', '=', $invoice->customer_id)
            ->groupby('account_head_id')
            ->first();

            //print_r($query->toSql()); exit();
            if($query){
                $retained_amount = $query->retained_amount;
            }else{
                $retained_amount = "0";    
            }

        } else {
            $retained_amount = "0";
        }


        // Assuming you have a view named 'invoicing.new_recovery_invoice'
        return view('invoicing.new_recovery_invoice', compact('invoice', 'business', 'invoice_services',  'customer', 'retained_amount'));

    }

    public function new_service_invoice($visit_id = null){
        
        if(empty($visit_id) || $visit_id < 1 || null == $visit_id){
             return back()->withErrors([
                'message' => 'Visit ID not passed to the API.',
            ]);
        }
        
        $visit = CustomerVisits::select('id_customer_visits', 'discount', 'advance_comment', 'business_id', 'customer_id',
        DB::raw('date_format(customer_visit_date, "%Y-%m-%d %H:%i") as customer_visit_date')
        )
        ->where('id_customer_visits', "=", $visit_id)
        ->first();
        
        $business_id = $visit->business_id;

        $visit_services = VisitServices::select('visit_services.*', 
        DB::RAW("GROUP_CONCAT(visit_service_staffs.staff_name ORDER BY additional_staff asc  SEPARATOR '<br>') as staff"),
        DB::RAW("Case when visit_service_staffs.requested = 'Yes' THEN 'checked' ELSE '' END as requested")
        )
        ->leftJoin('visit_service_staffs', 'id_visit_services', '=', 'visit_service_id')
        ->where('visit_services.customer_visit_id', "=", $visit_id)
        ->where('visit_service_status', "=", "Active")
        ->where('visit_service_staff_status', "=", "Active")
        ->groupby('id_visit_services')
        ->get();

        //get customer loyatly
        $customer = Customers::select('id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_area', 
        DB::RAW('COALESCE(customers.customer_address, "") as customer_address'), 'customers.customer_email',
        DB::RAW('CASE WHEN sum(loyalty_earned) - sum(loyalty_used)  > 0 THEN round(sum(loyalty_earned) - sum(loyalty_used)) ELSE 0 END  as loyalty_points')
        )
        ->leftJoin('invoice', function($join){ 
            $join->on('invoice.customer_id', '=', 'customers.id_customers')
              ->where('invoice.invoice_status', '=', 'valid');
        })
        ->where('id_customers', '=', $visit->customer_id)
        ->groupby('id_customers');

        $customer = $customer->first();
       // print_r($customer); exit();

        $business_id_for_account_head = session('ho_accounts') == 'Yes' ? DB::table('business')->where('ho', 'yes')->value('id_business'): session('business_id');

         //Get retained amount
         $account_head = AccountEventMapping::select('id_account_event_mapping', 'account_event_id', 'account_head_id', 'account_head')
        ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
        ->where('account_event_mapping.business_id', '=', $business_id_for_account_head)
        ->where('account_heads.business_id', '=', $business_id_for_account_head)
        ->where('entity_name', '=', 'retained_amount')
        ->where('account_event_id', '=', '1')
        ->first();

        $retained_account = $account_head->account_head_id ?? 0;
        if(null != $retained_account && $retained_account > 0){
            $query = AccountVoucherDetail::select('account_head_id', DB::RAW('sum(credit) - sum(debit) as retained_amount'))
            ->join('account_vouchers', 'account_vouchers.id_account_vouchers', '=', 'account_voucher_detail.account_voucher_id')
            ->where('account_head_id', '=', $retained_account)
            ->where('account_vouchers.business_partner_id', '=', $visit->customer_id)
            ->where('account_vouchers.business_id', session('business_id'))
            ->groupby('account_head_id')
            ->first();

            //print_r($query->toSql()); exit();
            if($query){
                $retained_amount = $query->retained_amount;
            }else{
                $retained_amount = "0";    
            }

        } else {
            $retained_amount = "0";
        }
        
        //Get visit advance
        $visit_advance = VisitAdvance::select(DB::RAW("SUM(advance_amount) as advance_amount"))
        ->where('customer_visit_id', "=", $visit_id)
        ->where('advance_status', "=", "Active")
        ->first();

        //check if all required fields exist in business table
        $columns = [
            'id_business',
            'business_name',
            'business_logo',
            'payment_terms',
            'cc_charge',
            'l_point_discount',
            'allow_balance',
        ];

        if (Schema::hasColumn('business', 'imsfiscal')) {
            $columns[] = 'imsfiscal';
        }

        if (Schema::hasColumn('business', 'srb_fiscal_service')) {
            $columns[] = 'srb_fiscal_service';
        }

        if (Schema::hasColumn('business', 'loyalty_otp')) {
            $columns[] = 'loyalty_otp';
        }

        $business = Business::select($columns)
            ->where('id_business', $business_id)
            ->first();
       // dd($business);

        $business_taxes = BusinessTaxes::select('id_business_taxes', 'tax_name', 'tax_active', 'tax_percentage', 'tax_invoice_type', 'tax_payment_mode',)
        ->where('business_id', '=', $business_id)
        ->where('tax_active', '=', 'Y')
        ->where('tax_invoice_type', '=', 'service')
        ->get();


        $discount_types = Discount::select('id_discount_reasons', 'discount_reason', 'discount_perc', 'fixed_amount')
        ->where('active', '=', 'Yes')
        ->where('business_id',  $business_id)
        ->get();

        // Assuming you have a view named 'invoicing.new_service_invoice'
        return view('invoicing.new_service_invoice', compact('visit', 'visit_services', 'visit_advance', 'business', 'customer', 'retained_amount', 'discount_types', 'business_taxes'));
    }

     public function new_retail_invoice(Request $request,$order_id = null)
     {        
        if(empty($order_id) || $order_id < 1 || null == $order_id){
            // return back()->withErrors([
            //     'message' => 'Order ID not passed to the API.',
            // ]);
            $business_id = session('business_id');
            $order =[];
            $order_products =[];
            $customer =[];
            $retained_amount = 0;
            $loyalty_points = 0;
            $retained_account = 0;

            //get staff list
            $staffs = Staff::select('id_staff', 'staff_fullname', 'staff_image')
            ->where('staff_active', '=', 'Y')
            ->where('staff_scheduler', '=', 'On')
            ->where('business_id', $business_id)->get();

        } else {
        
            $order = CustomerOrders::select('id_customer_order', 'order_type', 'delivery_charges', 'order_extra', 'business_id', 'customer_id', 'created_by', 'order_status', 'online_order_log_id', 'shipping_address', 'billing_address',
            DB::raw('date_format(customer_order_date, "%Y-%m-%d %H:%i") as customer_order_date')
            )
            ->where('id_customer_order', "=", $order_id)            
            ->first();

            //if no order found
            if(!$order){
                return back()->withErrors([
                    'message' => 'Order not found or already closed.',
                ]);
            }

            if($order->order_status == 'invoiced'){
                //redirect to existing invoice
                $existing_invoice = Invoice::where('visit_id', '=', $order->id_customer_order)->where('invoice_type', '=', 'sale')
                ->where('invoice_status', '=', 'valid')
                ->first();

                if($existing_invoice){
                    return redirect()->route('existing_invoice', $existing_invoice->id_invoice);
                } else {
                    return back()->withErrors([
                        'message' => 'Order already invoiced but invoice not found. Please contact system administrator.',
                    ]);
                }
            }
            
            $business_id = $order->business_id;

            //get products in the order
            $order_products = OrderProducts::select('order_products.*', 
            'business_products.price', 'business_products.purchase_price', 'business_products.unit_type',
            'business_products.product_type', 'order_products.product_sale_tax_percentage AS product_sales_tax', 'business_products.track_inventory', 'business_products.product_image',            
            'order_products.staff_id', 'business_brands.business_brand_name', 'business_products.product',
            DB::RAW("order_products.staff_name as staff")
            )
            ->join('business_products', 'business_products.id_business_products', '=', 'order_products.product_id')
            ->join('business_brands', 'business_brands.id_business_brands', '=', 'business_products.brand_id')
            ->where('order_products.customer_order_id', "=", $order_id)
            ->where('order_products.order_product_status', "=", "Active")
            ->groupby('id_order_products')
            ->get();

            //get customer loyatly
            $customer = Customers::select('id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_area', 
            DB::RAW('COALESCE(customers.customer_address, "") as customer_address'), 'customers.customer_email',
            DB::RAW('CASE WHEN sum(loyalty_earned) - sum(loyalty_used)  > 0 THEN round(sum(loyalty_earned) - sum(loyalty_used)) ELSE 0 END  as loyalty_points')
            )
            ->leftJoin('invoice', function($join){ 
                $join->on('invoice.customer_id', '=', 'customers.id_customers')
                ->where('invoice.invoice_status', '=', 'valid');
            })
            ->where('id_customers', '=', $order->customer_id)
            ->groupby('id_customers');
            $customer = $customer->first();
        // print_r($customer); exit();

            if(session('ho_accounts')=="Yes"){
                $common_business_id = Business::where('ho', '=', "Yes")->value('id_business');
            } else {
                $common_business_id = $order->business_id;
            }
            //Get retained amount
            $account_head = AccountEventMapping::select('id_account_event_mapping', 'account_event_id', 'account_head_id', 'account_head')
            ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
            ->where('account_event_mapping.business_id', '=', $common_business_id)
            ->where('account_heads.business_id', '=', $common_business_id)
            ->where('entity_name', '=', 'retained_amount')
            ->where('account_event_id', '=', '1')
            ->first();

            $retained_account = $account_head->account_head_id;
            if(null != $retained_account && $retained_account > 0){
                $query = AccountVoucherDetail::select('account_head_id', DB::RAW('sum(credit) - sum(debit) as retained_amount'))
                ->join('account_vouchers', 'account_vouchers.id_account_vouchers', '=', 'account_voucher_detail.account_voucher_id')
                ->where('account_head_id', '=', $retained_account)
                ->where('account_vouchers.business_partner_id', '=', $order->customer_id)
                ->where('account_vouchers.business_id', session('business_id'))
                ->groupby('account_head_id')
                ->first();

                //print_r($query->toSql()); exit();
                if($query){
                    $retained_amount = $query->retained_amount;
                }else{
                    $retained_amount = "0";    
                }

            } else {
                $retained_amount = "0";
            }
            $staffs=[];
        }
        
        //check if all required fields exist in business table
        $columns = [
            'id_business',
            'business_name',
            'business_logo',
            'payment_terms',
            'cc_charge',
            'l_point_discount',
            'allow_balance',
        ];

        if (Schema::hasColumn('business', 'imsfiscal')) {
            $columns[] = 'imsfiscal';
        }

        if (Schema::hasColumn('business', 'srb_fiscal_service')) {
            $columns[] = 'srb_fiscal_service';
        }

        if (Schema::hasColumn('business', 'loyalty_otp')) {
            $columns[] = 'loyalty_otp';
        }

        $business = Business::select($columns)
            ->where('id_business', $business_id)
            ->first();
        // dd($business);

        //Tax is assigned with product still check if any other tax is active for retail invoice
        $business_taxes = BusinessTaxes::select('id_business_taxes', 'tax_name', 'tax_active', 'tax_percentage', 'tax_invoice_type', 'tax_payment_mode',)
        ->where('business_id', '=', $business_id)
        ->where('tax_active', '=', 'Y')
        ->where('tax_invoice_type', '=', 'sale')
        ->get();

        $discount_types = Discount::select('id_discount_reasons', 'discount_reason', 'discount_perc', 'fixed_amount')
        ->where('active', '=', 'Yes')
        ->where('business_id',  $business_id)
        ->get();

        $stores = Stores::select('business_stores.*',
            'business.business_name'
        )
        ->join('business', 'business_stores.business_id', '=', 'business.id_business')
        ->where('business_id', session('business_id'))->get();
        
        // Read shipping and billing addresses directly from customer_orders table
        $shipping_address = $order->shipping_address ?? null;
        $billing_address = $order->billing_address ?? null;

        //-THIS PART IS FOR RETAIL POS FOR DISPLAY THIS INVOICE IN MODAL
         $ajax_request = request()->ajax();
        //-THIS PART IS FOR RETAIL POS FOR DISPLAY THIS INVOICE IN MODAL

        // Assuming you have a view named 'invoicing.new_service_invoice'

        $customer_order_advance = VisitAdvance::select(DB::raw("SUM(advance_amount) as advance_amount"))
            ->where('customer_order_id', $order_id)
            ->where('advance_status', 'Active')
            ->first();
        $advance_amount = $customer_order_advance->advance_amount ?? 0;

        return view('invoicing.new_retail_invoice', compact('order', 'order_products', 'staffs', 'business', 'customer', 'retained_amount', 'discount_types', 'business_taxes','stores', 'shipping_address', 'billing_address','ajax_request','advance_amount'));
        
    }

    public function create_service_invoice(Request $request){

        // echo '<pre>';
        // print_r($request->paid_ratained);
        // echo '</pre>';
        // exit;
        try {
            DB::beginTransaction();

            //Check if retained amount used is actually available
            $total_retained_available = 0;
            $business_id_for_account_head = session('ho_accounts') == 'Yes' ? DB::table('business')->where('ho', 'yes')->value('id_business'): session('business_id');
            if($request->paid_ratained != null && $request->paid_ratained > 0){
                $account_head = AccountEventMapping::select('id_account_event_mapping', 'account_event_id', 'account_head_id', 'account_head')
                ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
                ->where('account_event_mapping.business_id', '=', $business_id_for_account_head)
                ->where('account_heads.business_id', '=', $business_id_for_account_head)
                ->where('entity_name', '=', 'retained_amount')
                ->where('account_event_id', '=', '1')
                ->first();
    
                $retained_account = $account_head->account_head_id ?? 0;
                if(null != $retained_account && $retained_account > 0){
                    $query = AccountVoucherDetail::select('account_head_id', DB::RAW('sum(credit) - sum(debit) as retained_amount'))
                    ->join('account_vouchers', 'account_vouchers.id_account_vouchers', '=', 'account_voucher_detail.account_voucher_id')
                    ->where('account_head_id', '=', $retained_account)
                    ->where('account_vouchers.business_partner_id', '=', $request->id_customers)
                    ->where('account_vouchers.business_id', session('business_id'))
                    ->groupby('account_head_id')
                    ->first();
    
                    //print_r($query->toSql()); exit();
                    if($query){
                        $total_retained_available = $query->retained_amount;
                    }else{
                        $total_retained_available = "0";    
                    }
    
                } else {
                    $total_retained_available = "0";
                }
    
                if($total_retained_available < $request->paid_ratained){
                    DB::rollBack();
                    return response()->json([
                        'message' => 'Retained amount used is more than available.',
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }
            }
            
 

            $id_customer_visits = $request->id_customer_visits;
            $visit_time = $request->visit_date;
            $customer_id = $request->id_customers;
            $invoice_type = $request->invoice_type;
            $is_recovery = $request->is_recovery;
            $reference_invoice_number = $request->reference_invoice_number;
            $paid_earlier = $request->paid_earlier;

            $sub_total = $request->sub_total;
            $discount_remarks = $request->invoice_discount_type;
            $discount_reason = $request->invoice_discount_type;

            $discount = $request->invoice_discount;
            $tax_total = $request->taxes;
            $other_charges = $request->invoice_other_charges;
            $advance_amount = $request->advance;
            $total_amount = $request->total_amount;
            $total_payable   = $request->total_payable;
            $rounded_adjustment = $request->rounded_adjustment != null ? $request->rounded_adjustment : 0;

            $gross_wo_tax = round(((float)$sub_total  + (float)$other_charges) - (float)$discount,2);
            
             $payment_mode = $request->payment_mode;   
            $paid_amount = $request->paid_amount;
            ///Get paid cash and paid card if mode is mixed
            $paid_cash = 0;
            $paid_card = 0;
            $paid_check = 0;
            $paid_online = 0;
            $paid_voucher = $request->paid_voucher != null ? $request->paid_voucher : 0;
            $paid_loyalty = 0;
            $paid_retained = 0;

            if($payment_mode == "Mixed"){
                $paid_cash = $request->paid_cash;
                $paid_card = $request->paid_card;
                $paid_amount = $paid_amount ==0 ? (float)$paid_cash + (float)$paid_card : $paid_amount;
            } else if($payment_mode=="Cash") {
                $paid_cash = $request->paid_amount;
            } else if($payment_mode=="Card" || $payment_mode=="D-Card"){
                $paid_card = $request->paid_amount;
            } else if($payment_mode=="Debit Card"){
                $paid_card = $request->paid_amount;
            } else if($payment_mode=="Check"){
                $paid_check = $request->paid_amount;
            } else if($payment_mode=="Online"){
                $paid_online = $request->paid_amount;
            } 

            $retain_enabled = $request->retain == null ? "No" : $request->retain; //Yes / No
            $retained_amount_used = $request->paid_ratained; //For compatibility        
            $paid_retained = $request->paid_ratained;

            $retaining_now = $retain_enabled == "Yes" ? (float)$request->return_cash : 0;
            $return_amount = $retain_enabled == "No" ? (float)$request->return_cash : 0;

            $paid_loyalty = $request->paid_loyalty;
            $loyalty_used = $request->paid_loyalty; //For compatibility

            $cc_charge = $request->cc_fee != null ? $request->cc_fee : 0;
            $cc_tip = $request->cc_tip != null ? $request->cc_tip : 0;

            $pos_fee = $request->pos_fee != null ? $request->pos_fee : 0;
            $balance = $request->balance;
            

            $voucher_number = $request->voucher_number;

            $coupon_number = $request->coupon_number;
            $instrument_number = $request->instrument_number  && $request->instrument_number != ''  ? $request->instrument_number : ($request->voucher_number != null && $request->voucher_number != '' ? $request->voucher_number : ($request->coupon_number != null && $request->coupon_number != '' ? $request->coupon_number : ''));

            $remarks = $request->invoice_remarks;


            ///Get the actual visit
            $visit = CustomerVisits::select('id_customer_visits', 'customer_id', 'customer_visits.business_id', 'customer_name', 'customer_cell',
            'customer_address', 'customer_email', 'customer_area', 'visit_extra')
            ->join('customers', 'customers.id_customers', '=', 'customer_visits.customer_id')        
            ->where('id_customer_visits', '=', $id_customer_visits)
            ->orderBy('id_customer_visits', 'asc')
            ->first();

            //Get the visit services
            $visit_services = VisitServices::select('service_id', 'service_name', 'service_flag', 'id_service_type', 'id_service_category', 
            's_type', 's_category', 's_rate', 
            DB::RAW('date_format(visit_service_start, "%Y-%m-%d %H:%i:%s") as visit_service_start')
            )
            ->where('visit_services.customer_visit_id', '=', $id_customer_visits)
            ->where('visit_service_status', '=', 'Active')
            ->get();
            
            //Check if services posted are actually part of the visit
            $service_ids = collect($visit_services)->pluck('service_id')->toArray();
            $posted_service_ids = collect($request->services)->pluck('service_id')->toArray();
            if(count($posted_service_ids) != count($service_ids)){
                DB::rollBack();
                return response()->json([
                    'message' => 'Services have been changed in the Visit.',
                    "message_type" => "error",
                    "message_btn" => "danger"
                ]);
            }
            foreach($posted_service_ids as $psid){
                if(!in_array($psid, $service_ids)){
                    DB::rollBack();
                    return response()->json([
                        'message' => 'One or more services posted are not part of the visit.',
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }
            }

            //Get business config
            $business = Business::select('id_business', 'business_name', 'backdated_invoice', 'tax_mode', 'sh_hide', 's_min_sh',
            'l_point_value', 'l_point_discount', 'loyalty_sms', 'loyalty_enable', 's_loyalty', 'r_loyalty_enable', 'receipts_installed')
            ->where('id_business', '=', $visit->business_id)
            ->first();

            //Calculate loyalty
            $total_loyalty_available = 0;        
            if($business->loyalty_enable == 'Y'){
                //calculate total available loyalty for the customer
                $loyalty = Invoice::select('customer_id',             
                DB::RAW('CASE WHEN sum(loyalty_earned) - sum(loyalty_used)  > 0 THEN round(sum(loyalty_earned) - sum(loyalty_used)) ELSE 0 END  as loyalty_points')
                )->where('customer_id', '=', $request->id_customers)
                ->where('invoice_status', '=', 'valid')
                ->groupby('customer_id')
                ->first();

                $total_loyalty_available = $loyalty ? $loyalty->loyalty_points : 0;
                //Now check if loyalty points are being used
                if($request->paid_loyalty != null && $request->paid_loyalty > 0){
                    //Check if loyalty points used are actually available across all businesses
                    if(null == $loyalty){
                        DB::rollBack();
                        return response()->json([
                            "message" => "Customer does not exist anymore.",
                            "message_type" => "error",
                            "message_btn" => "danger"
                        ]);               
                    } elseif($loyalty->loyalty_points < $request->paid_loyalty){
                        DB::rollBack();
                        if($request->paid_loyalty > $loyalty->loyalty_points){
                            return response()->json([
                                'message' => 'Loyalty points used are more than available.',
                                "message_type" => "error",
                                "message_btn" => "danger"
                            ]);
                        }
                    } 
                }
            }
            
            $loyaltyvalue=$business->l_point_value;
            $loyaltyenabled=$business->loyalty_enable;
            $sloyaltyenabled=$business->s_loyalty;
            $rloyaltyenabled=$business->r_loyalty_enable;
            $loyaltyearned=0;
            if($invoice_type=="service"){
                if (! collect($request->services)->pluck('service_flag')->contains('packagetype')) {
                    if($loyaltyenabled=='Y' && $sloyaltyenabled=='Y') {                   
                        $loyaltyearned= round((Float)$gross_wo_tax / (Float)$loyaltyvalue);                   
                    } else {
                        $loyaltyearned=0;                
                    }
                } else {$loyaltyearned=0;}
                
                if($loyaltyearned < 0){$loyaltyearned=0;}
            }

            //get the shadow seq for compatibility
            // Default values
            $seq = 1;
            $day_seq = 1;

            // Query only once with proper coalesce
            $seq_query = Invoice::selectRaw('
                    COALESCE(MAX(invoice_seq), 0) + 1 AS seq,
                    COALESCE(MAX(invoice_day_seq), 0) + 1 AS day_seq
                ')
                ->whereDate('invoice_date', date('Y-m-d'))
                ->where('business_id', $visit->business_id)
                ->where('invoice_status', 'valid')
                ->first();

            if ($seq_query) {
                $seq = $seq_query->seq;
                $day_seq = $seq_query->day_seq;
            }

            // Apply special case handling
            if ($payment_mode !== 'Card' && $payment_mode !== 'Mixed' && $business->sh_hide === 'Yes') {
                if (!empty($business->s_min_sh)) {
                    if ($total_payable > $business->s_min_sh || $total_payable == 0) {
                        $seq = 0;
                    }
                } else {
                    $seq = 0;
                }
            }

            //Get the next Invoice # for the business
            $today = $business->backdated_invoice != null && $business->backdated_invoice != "No" ? date_format(date_create($visit_time), 'Y-m-d') : date('Y-m-d');

            $last_sequence = Invoice::where('business_id', $visit->business_id)
                ->whereDate('invoice_date', $today)
                ->max('invoice_day_seq');

            $next_sequence = $last_sequence ? $last_sequence + 1 : 1;
            // Save both invoice_day_seq and invoice_number
            $new_invoice_number = date('m') . "-" . date('d') . "-" . $next_sequence;

            $new_invoice_date = $business->backdated_invoice != null && $business->backdated_invoice != "No" ? date_format(date_create($visit_time), 'Y-m-d H:i:s') : date('Y-m-d H:i:s');

            //if loyalty used is more than don't give loyalty points
            if($paid_loyalty > 0 && $loyaltyearned > 0){
                $loyaltyearned = 0;
            }

            //Insert into invoice
            $new_invoice = new Invoice();
            $new_invoice->invoice_number = $new_invoice_number;
            $new_invoice->invoice_day_seq = $next_sequence;
            $new_invoice->invoice_date = $new_invoice_date;
            $new_invoice->invoice_day_seq = $next_sequence;
            $new_invoice->business_id = $visit->business_id;
            $new_invoice->customer_id = $customer_id;
            $new_invoice->customer_name = $visit->customer_name;
            $new_invoice->customer_address = $visit->customer_area;
            $new_invoice->customer_address = $visit->customer_area;
            $new_invoice->customer_cell = $visit->customer_cell;
            $new_invoice->customer_email = $visit->customer_email;
            $new_invoice->sub_total = $sub_total;
            $new_invoice->paid_amount = $paid_amount;
            $new_invoice->paid_amount = $paid_amount;
            $new_invoice->returnamount = $return_amount;
            $new_invoice->discount = $discount;
            $new_invoice->gross_amount = $total_amount; //Has tax
            $new_invoice->balance = $balance;
            $new_invoice->tax_total = $tax_total;
            $new_invoice->net_amount = $total_payable;
            $new_invoice->visit_id = $id_customer_visits;
            $new_invoice->invoice_status = 'valid';
            $new_invoice->invoice_type = $invoice_type;
            $new_invoice->payment_mode = $payment_mode;
            $new_invoice->instrument_number = $instrument_number;
            $new_invoice->is_recovery = ($balance === null || $balance == 0) ? "No" : "Yes";
            $new_invoice->reference_invoice_number = $reference_invoice_number != null ? $reference_invoice_number : "";
            $new_invoice->paid_earlier = $paid_earlier != null ? $paid_earlier : 0;        
            $new_invoice->discount_remarks = $discount_remarks;
            $new_invoice->loyalty_used = $loyalty_used;
            $new_invoice->visit_time = $visit_services[0]->visit_service_start;
            $new_invoice->advance_amount = $advance_amount;        
            $new_invoice->other_charges = $other_charges;        
            $new_invoice->rounded_adjustment = $rounded_adjustment;        
            $new_invoice->pos_fee = $pos_fee;
            $new_invoice->retained_used = $retain_enabled;        
            $new_invoice->retained_amount = $retaining_now > 0 ? $retaining_now : 0;        
            $new_invoice->retained_amount_used = $retained_amount_used;        
            $new_invoice->cctip = $cc_tip;        
            $new_invoice->loyalty_earned = $loyaltyearned;
            $new_invoice->paid_cash = $paid_cash;
            $new_invoice->paid_card = $paid_card;
            $new_invoice->paid_voucher = $paid_voucher;
            $new_invoice->paid_check = $paid_check;
            $new_invoice->paid_online = $paid_online;
            $new_invoice->paid_loyalty = $paid_loyalty;
            $new_invoice->paid_retained = $paid_retained;
            $new_invoice->cc_charge = $cc_charge;
            $new_invoice->total_payable = $total_payable;        
            $new_invoice->created_by = session('user_name');        
            $new_invoice->invoice_seq = $seq;
            $new_invoice->discount_reason = $discount_reason;
            $new_invoice->org_invoice_id = $request->org_invoice_id != null ? $request->org_invoice_id : null;
            $new_invoice->remarks = $remarks != null ? $remarks : "";
            $new_invoice->imsfiscal_invoice_number =  $request->imsfiscal_invoice_number != null ? $request->imsfiscal_invoice_number : null;
            $new_invoice->gross_wo_tax = $gross_wo_tax;
            $new_invoice->order_id = $request->order_id != null ? $request->order_id : "";
            $new_invoice->receipt_url = $request->receipt_url != null ? $request->receipt_url : "";
            $new_invoice->receipt_code = $request->receipt_code != null ? $request->receipt_code : "";
            $new_invoice->invoice_extra = $visit->visit_extra;
            $new_invoice->save();

            $new_id_invoice = $new_invoice->id_invoice;


            //Insert invoice details

            $total_service_discount = 0; $total_service_addition = 0; $total_org_price = 0;
            ///Itterate over Posted Service Details
            foreach($request->services as $service){
                // return $service;
                //Break invoice Discount per Service
                $invoice_discount_portion=0;
                if($discount > 0){
                    $invoice_discount_portion = $discount/sizeof($request->services);
                }
                
                $final_service_price = $service['final_service_price'] - $invoice_discount_portion;

                ///Calculate Tax per Service
                $tax_percentage = $tax_total * 100 / $gross_wo_tax ;
                $service_tax = $final_service_price * $tax_percentage/100;

                $total_service_discount = $total_service_discount + (float)$service['service_discount'];
                $total_service_addition = $total_service_addition + (float)$service['service_addition'];
                $total_org_price = $total_org_price + ((float)$service['visit_service_price'] + (float)$service['service_addition']);

                $new_invoice_details = new InvoiceDetails();
                $new_invoice_details->business_id = $visit->business_id;
                $new_invoice_details->invoice_id = $new_invoice->id_invoice;
                $new_invoice_details->service_id = $service['service_id'];
                $new_invoice_details->service_type = $service['service_type'];
                $new_invoice_details->service_category = $service['service_category'];
                $new_invoice_details->service_name = $service['service_name'];
                $new_invoice_details->staff = $service['staff'];
                $new_invoice_details->price = $service['visit_service_price'];
                $new_invoice_details->discount = $service['service_discount'];
                $new_invoice_details->discount_type = $service['service_discount_type'];
                $new_invoice_details->service_addition = $service['service_addition'];
                $new_invoice_details->discounted_price = $service['visit_service_price'] - $service['service_discount'] ;
                $new_invoice_details->invoice_discount = $invoice_discount_portion;
                $new_invoice_details->final_price = $final_service_price;
                $new_invoice_details->taxes = $service_tax;
                $new_invoice_details->paid = $final_service_price;
                $new_invoice_details->invoice_detail_date = date('Y-m-d H:i:s');
                
                $new_invoice_details->service_flag = $service['service_flag'];
                
                $new_invoice_details->membership = $service['membership'] != null ? $service['membership'] : "No";
                $new_invoice_details->visit_service_id = $service['visit_service_id'];
                $new_invoice_details->created_by = session('user_name');
                $new_invoice_details->save();
                $new_invoice_detail_id = $new_invoice_details->id_invoice_details;

                //Get the staff for each visit service
                $visit_service_staffs = VisitServiceStaff::select('id_visit_service_staffs', 'staff_id', 'staff_name',
                'additional_staff', 'block_other', 'requested')
                ->where('visit_service_id', '=', $service['visit_service_id'])
                ->where('visit_service_staff_status', '=', 'Active')
                ->get();
                // return $visit_service_staffs;
                //Insert Invoice Staff
                foreach($visit_service_staffs as $staff){

                    //Calculate commission if any
                    $commission = 0;

                    $service_details = Services::select('id_business_services', 'service_name', 'commission_type', 'commission_perc', 'commission_fixed', 'helper_perc', 'helper_fixed')
                    ->where('id_business_services', '=', $service['service_id'])
                    ->first();
                    
                    if($staff->additional_staff == "No"){
                        if($service_details->commission_type == "Percentage"){
                            
                            $commission = round($final_service_price * $service_details->commission_perc / 100,2);
                        
                        } elseif($service_details->commission_type == "Fixed"){
                            $commission = $service_details->commission_fixed;
                        }
                    } else {
                        if($service_details->commission_type == "Percentage"){
                            $commission = round($final_service_price * $service_details->helper_perc / 100,2);
                        } elseif($service_details->commission_type == "Fixed"){
                            $commission = $service_details->helper_fixed;
                        }   
                    }

                    $new_invoice_staff = new InvoiceStaff();
                    $new_invoice_staff->business_id = $visit->business_id;
                    $new_invoice_staff->invoice_id = $new_id_invoice;
                    $new_invoice_staff->invoice_detail_id = $new_invoice_detail_id;
                    $new_invoice_staff->staff_id = $staff->staff_id;
                    $new_invoice_staff->staff_name = $staff->staff_name;
                    $new_invoice_staff->additional_staff = $staff->additional_staff;
                    
                    $new_invoice_staff->requested = $service['requested'];
                    $new_invoice_staff->commission = $commission;
                    $new_invoice_staff->visit_staff_id = $staff->id_visit_service_staffs;
                    $new_invoice_staff->service_type = $new_invoice_details->service_type; //
                    $new_invoice_staff->service_category = $new_invoice_details->service_category; //
                    $new_invoice_staff->service_name = $new_invoice_details->service_name; //
                    $new_invoice_staff->staff_share = 0; //
                    
                    $new_invoice_staff->price = $staff->additional_staff == "No" ? $new_invoice_details->price : 0; //
                    $new_invoice_staff->discount = $staff->additional_staff == "No" ? $new_invoice_details->discount : 0; //
                    $new_invoice_staff->service_addition = $staff->additional_staff == "No" ? $new_invoice_details->service_addition : 0; //
                    $new_invoice_staff->discounted_price = $staff->additional_staff == "No" ? $new_invoice_details->discounted_price : 0; //
                    $new_invoice_staff->invoice_discount = $staff->additional_staff == "No" ? $new_invoice_details->invoice_discount : 0; //
                    $new_invoice_staff->final_price = $staff->additional_staff == "No" ? $final_service_price : 0 ; //
                    $new_invoice_staff->paid = $staff->additional_staff == "No" ? $new_invoice_details->paid : 0; //

                    $new_invoice_staff->created_by = session('user_name');
                    $new_invoice_staff->save();
                }

                ///Insert invoice visit products if any
                $visit_products = ServicesProducts::select('id_services_products', 'business_service_id', 'business_product_id', 'usage_qty',
                'business_products.product', 'business_products.measure_unit'
                )
                ->join('business_products', 'business_products.id_business_products', '=', 'services_products.business_product_id')
                ->where('status', '=', 'Y')
                ->where('services_products.business_service_id', '=', $service_details->id_business_services)
                ->get();

                foreach($visit_products as $product){

                    $new_invoice_visit_product = new InvoiceVisitProducts();
                    $new_invoice_visit_product->business_id = $visit->business_id;
                    $new_invoice_visit_product->invoice_id = $new_id_invoice;
                    $new_invoice_visit_product->customer_visit_id = $visit->id_customer_visits;
                    $new_invoice_visit_product->service_id = $service_details->id_business_services;
                    $new_invoice_visit_product->service_name = $service_details->service_name;
                    $new_invoice_visit_product->product_id = $product->business_product_id;
                    $new_invoice_visit_product->product_name = $product->product;
                    $new_invoice_visit_product->product_qty = $product->usage_qty;
                    $new_invoice_visit_product->product_unit = $product->measure_unit;
                    $new_invoice_visit_product->created_by = session('user_name');
                    $new_invoice_visit_product->save();
                    
                }


            }

            //Mark customer visit as Invoiced
            $update_visit = CustomerVisits::find($id_customer_visits);
            $update_visit->visit_status = "invoiced";
            $update_visit->save();


            //Create Account Voucher 
            if($new_id_invoice > 0){
            
                $account_voucher = new AccountVouchers();
                $account_voucher->voucher_date = $new_invoice_date;            
                $account_voucher->voucher_type = 2; //Receipt
                $account_voucher->voucher_status = 'Active';
                $account_voucher->created_by = session('user_name');
                $account_voucher->created_on = date('Y-m-d H:i:s');
                $account_voucher->invoice_id = $new_id_invoice;
                $account_voucher->sale_type = 'service';        
                $account_voucher->id_account_head = 24; //1 = Accounts Receivable
                $account_voucher->voucher_date = $new_invoice_date;
                $account_voucher->description = 'Service Sale Voucher against invoice '.$new_id_invoice.' on '.$new_invoice_date.', for '.$visit->customer_name.' customer ID : '.$customer_id;
                $account_voucher->business_id = $visit->business_id;
                $account_voucher->voucher_amount = $paid_amount;
                $account_voucher->cost_center = 1;
                $account_voucher->cost_center_name = 'Front Desk';
                $account_voucher->business_partner = '1';
                $account_voucher->business_partner_id = $customer_id;
                $account_voucher->business_partner_name = $visit->customer_name;
                
                $account_voucher->visit_id = $visit->id_customer_visits;            
                $account_voucher->payment_mode = $payment_mode;
                $account_voucher->auto_voucher = 'Yes';

                $account_voucher->save();
                $new_voucher_id = $account_voucher->id_account_vouchers;
            
                //Get the event mappings for Invoice Creation id_events = 1
                //business id for Ho if 'ho_accounts' = 'Yes'            
                if(session('ho_accounts')=='Yes'){
                    $new_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                } else {
                    $new_business_id = $visit->business_id;
                }
                $event_mappings = AccountEventMapping::where('account_event_id', 1)->where('business_id', $new_business_id)->get();
                $debit_amounts = [];
                $credit_amounts = [];
                $debit_accounts = array();
                $credit_accounts = array();
                foreach($event_mappings as $mapping){                    

                    if($mapping['transaction_type']=='debit'){
                        array_push($debit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    } else {
                        array_push($credit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    }
                   
                    if($mapping['transaction_type']=='debit'){
                        //make debit entry data
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Cash'  ? $paid_amount : 0 ]);}
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Mixed'  ? $paid_cash : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Card'  || $payment_mode == 'D-Card' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Mixed' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_check'){array_push($debit_amounts, [ 'entity_name' => 'paid_check', 'amount' => $payment_mode == 'Check' ? $paid_check : 0 ]);}
                        if($mapping['entity_name']=='paid_online'){array_push($debit_amounts, [ 'entity_name' => 'paid_online', 'amount' => $payment_mode=="Online" ? $paid_online : 0 ]);}
                        if($mapping['entity_name']=='paid_voucher'){array_push($debit_amounts, [ 'entity_name' => 'paid_voucher', 'amount' => $payment_mode == 'Voucher' ? $paid_voucher : 0 ]);}
                        if($mapping['entity_name']=='loyalty_used'){array_push($debit_amounts, [ 'entity_name' => 'loyalty_used', 'amount' => $paid_loyalty > 0 ? $paid_loyalty : 0 ]);}
                        if($mapping['entity_name']=='loyalty_expense'){array_push($debit_amounts, [ 'entity_name' => 'loyalty_expense', 'amount' => $loyaltyearned ]);}
                        if($mapping['entity_name']=='retained_amount_used'){array_push($debit_amounts, [ 'entity_name' => 'retained_amount_used', 'amount' => $retained_amount_used ]);}
                        if($mapping['entity_name']=='sale_discount_service'){array_push($debit_amounts, [ 'entity_name' => 'sale_discount_service', 'amount' => $discount + $total_service_discount ]);}
                        if($mapping['entity_name']=='balance'){array_push($debit_amounts, [ 'entity_name' => 'balance', 'amount' => $balance ]);}
                        if($mapping['entity_name']=='advance_adjusted'){array_push($debit_amounts, [ 'entity_name' => 'advance_adjusted', 'amount' => $advance_amount ]);}
                        

                    } else if($mapping['transaction_type']=='credit'){
                        //make credit entry data
                        if($mapping['entity_name']=='cc_fee'){array_push($credit_amounts, [ 'entity_name' => 'cc_fee', 'amount' => $cc_charge ]);}                    
                        if($mapping['entity_name']=='return_cash'){array_push($credit_amounts, [ 'entity_name' => 'return_cash', 'amount' => $retain_enabled == "No" ? $return_amount : 0 ]);}
                        if($mapping['entity_name']=='retained_amount'){array_push($credit_amounts, [ 'entity_name' => 'retained_amount', 'amount' => $retain_enabled=="Yes" ? $retaining_now : 0 ]);}                    
                        if($mapping['entity_name']=='loyalty_earned'){array_push($credit_amounts, [ 'entity_name' => 'loyalty_earned', 'amount' => $loyaltyearned ]);}
                        if($mapping['entity_name']=='sales_tax'){array_push($credit_amounts, [ 'entity_name' => 'sales_tax', 'amount' => $tax_total ]);}
                        if($mapping['entity_name']=='cc_tip'){array_push($credit_amounts, [ 'entity_name' => 'cc_tip', 'amount' => $cc_tip ]);}
                        if($mapping['entity_name']=='grosstotal_service'){array_push($credit_amounts, [ 'entity_name' => 'grosstotal_service', 'amount' => ($total_org_price + $other_charges) ]);}
                        
                    
                    }
                }
                //get the sum of debit amounts and credit amounts
                $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;

                //add rouding adjustment if any
                if($rounded_adjustment != 0){                    
                    if($debit_sum > $credit_sum){
                        array_push($credit_amounts, [ 'entity_name' => 'rounded_adjustment', 'amount' => $rounded_adjustment ]);
                        $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                        $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                    } else {
                        array_push($debit_amounts, [ 'entity_name' => 'rounded_adjustment', 'amount' => $rounded_adjustment ]);
                        $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                        $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                    }                    
                }
                // DB::rollBack(); //Rollback the transaction
                // return array_merge($debit_amounts, $credit_amounts);

                if($debit_sum == null || $credit_sum == null || $debit_sum != $credit_sum){
                    DB::rollBack(); //Rollback the transaction
                    Log::info('1');
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit and Credit amounts do not match. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                } else if($debit_sum == 0 || $credit_sum == 0){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit or Credit amounts are zero. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }else{                    
                    //Insert voucher Details
                    foreach($debit_accounts as $debit){
                        $debit_parts = explode("|", $debit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $debit_parts[0];
                        $entity = $debit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->debit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $debit_amounts));
                        $new_voucher_details->credit = 0;    
                        if($new_voucher_details->debit != 0){                                            
                            $new_voucher_details->save();
                        }
                    }
                    foreach($credit_accounts as $credit){
                        $credit_parts = explode("|", $credit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $credit_parts[0];
                        $new_voucher_details->debit = 0;
                        $entity = $credit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->credit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $credit_amounts));
                        if($new_voucher_details->credit != 0){           
                            $new_voucher_details->save();
                        }
                    }
                }
            }

            //  GIFT VOUCHER UPDATE
            if($request->voucher_number !='' && $request->voucher_number !=0){
                $gift_voucher_number = 'C' . $request->voucher_number; 
                $gift_vouche_remaining_amount =$request->gift_vouche_remaining_amount;
                $gift_voucher_remaining_services =$request->gift_voucher_remaining_services;
                DB::table('order_vouchers')
                ->where('voucher_number', $gift_voucher_number)
                ->update([
                    'remaining_amount'       => $gift_vouche_remaining_amount,
                    'remaining_service_ids'  => $gift_voucher_remaining_services,
                    'voucher_status'         => $gift_vouche_remaining_amount > 0 ? 'open' : 'closed',
                ]);
            }
           
            

            DB::commit(); //If we reach here, commit the transaction

            //Send SMS if enabled
            if($business->loyalty_sms == 'Yes'){
                if($business->receipts_installed == "Yes"){
                    $this->send_receipt_sms($new_id_invoice, $visit->customer_cell, $visit->customer_name, $invoice_type, $total_loyalty_available, $visit->business_id, $business->business_name);

                } else {
                    $this->send_invoice_sms($new_id_invoice, $total_loyalty_available);
                }                
            }


            return response()->json([           
                "message" => "Invoice Created with ID ".$new_id_invoice,            
                "message_type" => "success",
                "message_btn" => "success",
                "new_id_invoice" => $new_id_invoice
            ]);
        
        } catch (\Exception $e) {
            // If anything failed, rollback
            DB::rollBack();
            return response()->json([
                "message" => "Error creating invoice: " . $e->getMessage(),
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }
    }

    public function create_order_invoice(Request $request)
    {
        try {
            DB::beginTransaction();

            $business_store_id =  $request->business_store_id;

            if(session('ho_accounts')=="Yes"){
                $common_business_id = Business::where('ho', 'Yes')->value('id_business');
            } else {
                $common_business_id = session('business_id');
            }

            $cogs_total = 0;
            //Check if retained amount used is actually available
            $total_retained_available = 0;
            if($request->paid_retained != null && $request->paid_retained > 0){
                $account_head = AccountEventMapping::select('id_account_event_mapping', 'account_event_id', 'account_head_id', 'account_head')
                ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
                ->where('account_event_mapping.business_id', '=', $common_business_id)
                ->where('account_heads.business_id', '=', $common_business_id)
                ->where('entity_name', '=', 'retained_amount')
                ->where('account_event_id', '=', '1')
                ->first();
    
                $retained_account = $account_head->account_head_id;
                if(null != $retained_account && $retained_account > 0){
                    $query = AccountVoucherDetail::select('account_head_id', DB::RAW('sum(credit) - sum(debit) as retained_amount'))
                    ->join('account_vouchers', 'account_vouchers.id_account_vouchers', '=', 'account_voucher_detail.account_voucher_id')
                    ->where('account_head_id', '=', $retained_account)
                    ->where('account_vouchers.business_partner_id', '=', $request->id_customers)
                    ->where('account_vouchers.business_id', session('business_id'))
                    ->groupby('account_head_id')
                    ->first();
    
                    //print_r($query->toSql()); exit();
                    if($query){
                        $total_retained_available = $query->retained_amount;
                    }else{
                        $total_retained_available = "0";    
                    }
    
                } else {
                    $total_retained_available = "0";
                }
    
                if($total_retained_available < $request->paid_ratained){
                    DB::rollBack();
                    return response()->json([
                        'message' => 'Retained amount used is more than available.',
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }
            }

            $id_customer_orders = $request->id_customer_orders;
            $visit_time = $request->visit_date;
            $customer_id = $request->id_customers;
            $invoice_type = $request->invoice_type;
            $is_recovery = $request->is_recovery;
            $reference_invoice_number = $request->reference_invoice_number;
            $paid_earlier = $request->paid_earlier;

            $sub_total = $request->sub_total;
            $gross_wo_tax = $request->gross_wo_tax != null ? round((float)$request->gross_wo_tax, 2) : 0;
            $tax_total = $request->taxes;
            
            $advance_amount = $request->advance;
            $delivery_charges = $request->delivery_charges ?? 0;
            $total_amount = $request->total_amount;
            $total_payable   = $request->total_payable;
            $rounded_adjustment = $request->rounded_adjustment != null ? $request->rounded_adjustment : 0;
            
            $payment_mode = $request->payment_mode;   
            $paid_amount = $request->paid_amount;
            ///Get paid cash and paid card if mode is mixed
            $paid_cash = 0;
            $paid_card = 0;
            $paid_check = 0;
            $paid_online = 0;
            $paid_voucher = $request->paid_voucher != null ? $request->paid_voucher : 0;
            $paid_loyalty = 0;
            $paid_retained = 0;

            if($payment_mode == "Mixed"){
                $paid_cash = $request->paid_card;
                $paid_card = $request->paid_cash;
                $paid_amount = $paid_amount ==0 ? (float)$paid_cash + (float)$paid_card : $paid_amount;
            } else if($payment_mode=="Cash") {
                $paid_cash = $request->paid_amount;
            } else if($payment_mode=="Card" || $payment_mode=="D-Card"){
                $paid_card = $request->paid_amount;
            } else if($payment_mode=="Debit Card"){
                $paid_card = $request->paid_amount;
            } else if($payment_mode=="Check"){
                $paid_check = $request->paid_amount;
            } else if($payment_mode=="Online"){
                $paid_online = $request->paid_amount;
            } 

            $retain_enabled = $request->retain == null ? "No" : $request->retain; //Yes / No
            $retained_amount_used = $request->paid_ratained; //For compatibility        
            $paid_retained = $request->paid_ratained;

            $retaining_now = $retain_enabled == "Yes" ? (float)$request->return_cash : 0;
            $return_amount = $retain_enabled == "No" ? (float)$request->return_cash : 0;

            $paid_loyalty = $request->paid_loyalty;
            $loyalty_used = $request->paid_loyalty; //For compatibility

            $cc_charge = $request->cc_fee != null ? $request->cc_fee : 0;
            $cc_tip = $request->cc_tip != null ? $request->cc_tip : 0;

            $pos_fee = $request->pos_fee != null ? $request->pos_fee : 0;
            $balance = $request->balance;
            

            $voucher_number = $request->voucher_number;
            $coupon_number = $request->coupon_number;
            $instrument_number = $request->instrument_number  && $request->instrument_number != ''  ? $request->instrument_number : ($request->voucher_number != null && $request->voucher_number != '' ? $request->voucher_number : ($request->coupon_number != null && $request->coupon_number != '' ? $request->coupon_number : ''));

            $remarks = $request->invoice_remarks;
            $products = $request->products;

            //Get the actual order
            $order = CustomerOrders::select('customer_orders.*', 'business.id_business', 'business_name', 
            'customers.customer_name', 'customers.customer_cell', 'customers.customer_email', 'customers.customer_area',
            'customer_orders.shipping_address', 'customer_orders.billing_address')
            ->join('customers', 'customers.id_customers', '=', 'customer_orders.customer_id')
            ->join('business', 'business.id_business', '=', 'customer_orders.business_id')
            ->where('id_customer_order', $id_customer_orders)->where('order_status', 'open')
            ->first();

            $batchService = new productBatchService();
            $shortageList = [];  
            foreach ($products as $row) {
                $productId   = $row['product_id'];
                $requiredQty = floatval($row['product_quantity']);
                $batches = $batchService->findSufficientBatches($productId, $order->business_id, $business_store_id);
                $batches = json_decode($batches, true);
                $availableQty = 0;
                if (!empty($batches)) {
                    foreach ($batches as $b) {                        
                        $availableQty += floatval($b['instock'] ?? 0);
                    }
                }
                if ($availableQty < $requiredQty) { 
                    $product_batch_route = route('products.batches', $row['product_id']);
                    $product = Products::select('business_products.product', 'business_brands.business_brand_name as brand','track_inventory')
                    ->join('business_brands', 'business_brands.id_business_brands', '=', 'business_products.brand_id')
                    ->where('id_business_products', $row['product_id'])->first();
                    
                    if($product && $product->track_inventory == 'Yes'){
                        $shortageList[] = [
                            "product_batch_route"     => $product_batch_route,
                            "productid"     => $row['product_id'],
                            "productname"   => $row['product'] ?? '',
                            "required_qty"  => $requiredQty,
                            "available_qty" => $availableQty,
                            "shortage"      => $requiredQty - $availableQty
                        ];
                    }
                    continue;
                }

                $remainingQty = $requiredQty;
                foreach ($batches as $batch) {
                    if ($remainingQty <= 0) break;
                    $instock = floatval($batch['instock']);
                    if ($instock <= 0) continue;
                    $deductQty = min($instock, $remainingQty , $requiredQty); 
                    $remainingQty -= $deductQty;
                }
            }

            if (!empty($shortageList)) {
                DB::rollBack();
                return response()->json([
                    "message" => "Insufficient stock for products.",
                    "message_type" => "error",
                    "data" => $shortageList ,
                    "product_shortage" =>true ,
                    "success" => false 
                ]);
            }



            if(!$order){
                DB::rollBack();
                return response()->json([
                    'message' => 'Customer Order not found or already invoiced.',
                    "message_type" => "error",
                    "message_btn" => "danger"
                ]);
            }
            $delivery_charges = $request->delivery_charges ?? 0;
            //Get the order products
            $order_products = OrderProducts::where('customer_order_id', $id_customer_orders)
            ->where('order_product_status', 'Active')
            ->get();

            //check is the posted products match the order products
            $posted_products = collect($products);
            $order_products = collect($order_products);

            if (!$posted_products->isEmpty()) {
                $posted_products->each(function ($item) use ($order_products) {
                    $matched = $order_products->firstWhere('product_id', $item['product_id']);
                    if (!$matched) {
                        throw new \Exception("Product ID {$item['product_id']} does not match the order.");
                    }
                });
            } else {
                throw new \Exception("No products posted for invoicing.");
            }

            //Get business config
            $business = Business::select('id_business', 'business_name', 'backdated_invoice', 'tax_mode', 'sh_hide', 's_min_sh',
            'l_point_value', 'l_point_discount', 'loyalty_sms', 'loyalty_enable', 's_loyalty', 'r_loyalty_enable', 'receipts_installed')
            ->where('id_business', '=', $order->business_id)
            ->first();

            //Calculate loyalty
            $total_loyalty_available = 0;        
            if($business->loyalty_enable == 'Y'){
                //calculate total available loyalty for the customer
                $loyalty = Invoice::select('customer_id',             
                DB::RAW('CASE WHEN sum(loyalty_earned) - sum(loyalty_used)  > 0 THEN round(sum(loyalty_earned) - sum(loyalty_used)) ELSE 0 END  as loyalty_points')
                )->where('customer_id', '=', $request->id_customers)
                ->where('invoice_status', '=', 'valid')
                ->groupby('customer_id')
                ->first();

                $total_loyalty_available = $loyalty ? $loyalty->loyalty_points : 0;
                //Now check if loyalty points are being used
                if($request->paid_loyalty != null && $request->paid_loyalty > 0){
                    //Check if loyalty points used are actually available across all businesses
                    if(null == $loyalty){
                        DB::rollBack();
                        return response()->json([
                            "message" => "Customer does not exist anymore.",
                            "message_type" => "error",
                            "message_btn" => "danger"
                        ]);               
                    } elseif($loyalty->loyalty_points < $request->paid_loyalty){
                        DB::rollBack();
                        if($request->paid_loyalty > $loyalty->loyalty_points){
                            return response()->json([
                                'message' => 'Loyalty points used are more than available.',
                                "message_type" => "error",
                                "message_btn" => "danger"
                            ]);
                        }
                    } 
                }
            }
            
            $loyaltyvalue=$business->l_point_value;
            $loyaltyenabled=$business->loyalty_enable;
            $sloyaltyenabled=$business->s_loyalty;
            $rloyaltyenabled=$business->r_loyalty_enable;
            $loyaltyearned=0;
            if($invoice_type=="sale"){            
                if($loyaltyenabled=='Y' && $rloyaltyenabled=='Y') {                   
                    $loyaltyearned= round((Float)$gross_wo_tax / (Float)$loyaltyvalue);                   
                } else {
                    $loyaltyearned=0;                
                }                
                
                if($loyaltyearned < 0){$loyaltyearned=0;}
            }

            //get the shadow seq for compatibility
            // Default values
            $seq = 1;
            $day_seq = 1;

            // Query only once with proper coalesce
            $seq_query = Invoice::selectRaw('
                    COALESCE(MAX(invoice_seq), 0) + 1 AS seq,
                    COALESCE(MAX(invoice_day_seq), 0) + 1 AS day_seq
                ')
                ->whereDate('invoice_date', date('Y-m-d'))
                ->where('business_id', $order->business_id)
                ->where('invoice_status', 'valid')
                ->first();

            if ($seq_query) {
                $seq = $seq_query->seq;
                $day_seq = $seq_query->day_seq;
            }

            // Apply special case handling
            if ($payment_mode !== 'Card' && $payment_mode !== 'Mixed' && $business->sh_hide === 'Yes') {
                if (!empty($business->s_min_sh)) {
                    if ($total_payable > $business->s_min_sh || $total_payable == 0) {
                        $seq = 0;
                    }
                } else {
                    $seq = 0;
                }
            }

            //Get the next Invoice # for the business
            $today = $business->backdated_invoice != null && $business->backdated_invoice != "No" ? date_format(date_create($visit_time), 'Y-m-d') : date('Y-m-d');

            $last_sequence = Invoice::where('business_id', $order->business_id)
                ->whereDate('invoice_date', $today)
                ->max('invoice_day_seq');

            $next_sequence = $last_sequence ? $last_sequence + 1 : 1;
            // Save both invoice_day_seq and invoice_number
            $new_invoice_number = date('m') . "-" . date('d') . "-" . $next_sequence;

            $new_invoice_date = $business->backdated_invoice != null && $business->backdated_invoice != "No" ? date_format(date_create($visit_time), 'Y-m-d H:i:s') : date('Y-m-d H:i:s');

            //if loyalty used is more than don't give loyalty points
            if($paid_loyalty > 0 && $loyaltyearned > 0){
                $loyaltyearned = 0;
            }

            //Insert into invoice
            $new_invoice = new Invoice();
            $new_invoice->invoice_number = $new_invoice_number;
            $new_invoice->invoice_day_seq = $next_sequence;
            $new_invoice->invoice_date = $new_invoice_date;
            $new_invoice->invoice_day_seq = $next_sequence;
            $new_invoice->business_id = $order->business_id;
            $new_invoice->customer_id = $customer_id;
            $new_invoice->customer_name = $order->customer_name;
            // Use billing_address if available, otherwise shipping_address, otherwise fallback to customer_area
            $new_invoice->customer_address = $order->billing_address ?? $order->shipping_address ?? $order->customer_area;
            $new_invoice->customer_cell = $order->customer_cell;
            $new_invoice->customer_email = $order->customer_email;
            $new_invoice->sub_total = $sub_total;
            $new_invoice->paid_amount = $paid_amount;
            $new_invoice->paid_amount = $paid_amount;
            $new_invoice->returnamount = $return_amount;
            //$new_invoice->discount = $discount;
            $new_invoice->gross_amount = $total_amount; //Has tax
            $new_invoice->balance = $balance;
            $new_invoice->tax_total = $tax_total;
            $new_invoice->net_amount = $total_payable;
            $new_invoice->visit_id = $id_customer_orders;
            $new_invoice->invoice_status = 'valid';
            $new_invoice->invoice_type = $invoice_type;
            $new_invoice->payment_mode = $payment_mode;
            $new_invoice->instrument_number = $instrument_number;
            $new_invoice->is_recovery = ($balance === null || $balance == 0) ? "No" : "Yes";
            $new_invoice->reference_invoice_number = $reference_invoice_number != null ? $reference_invoice_number : "";
            $new_invoice->paid_earlier = $paid_earlier != null ? $paid_earlier : 0;        
           // $new_invoice->discount_remarks = $discount_remarks;
            $new_invoice->loyalty_used = $loyalty_used;
            $new_invoice->visit_time = $order->customer_order_date;
            $new_invoice->advance_amount = $advance_amount > 0 ? $advance_amount : 0;        
            $new_invoice->other_charges =  0;        
            $new_invoice->delivery_charges = $delivery_charges ?? 0;        
            $new_invoice->rounded_adjustment = $rounded_adjustment;        
            $new_invoice->pos_fee = $pos_fee;
            $new_invoice->retained_used = $retain_enabled;        
            $new_invoice->retained_amount = $retaining_now > 0 ? $retaining_now : 0;        
            $new_invoice->retained_amount_used = $retained_amount_used;        
            $new_invoice->cctip = $cc_tip;        
            $new_invoice->loyalty_earned = $loyaltyearned;
            $new_invoice->paid_cash = $paid_cash;
            $new_invoice->paid_card = $paid_card;
            $new_invoice->paid_voucher = $paid_voucher;
            $new_invoice->paid_check = $paid_check;
            $new_invoice->paid_online = $paid_online;
            $new_invoice->paid_loyalty = $paid_loyalty;
            $new_invoice->paid_retained = $paid_retained;
            $new_invoice->cc_charge = $cc_charge;
            $new_invoice->total_payable = $total_payable;        
            $new_invoice->created_by = session('user_name');        
            $new_invoice->invoice_seq = $seq;
            // $new_invoice->discount_reason = $discount_reason;
            $new_invoice->org_invoice_id = $request->org_invoice_id != null ? $request->org_invoice_id : null;
            $new_invoice->remarks = $remarks != null ? $remarks : "";
            $new_invoice->imsfiscal_invoice_number =  $request->imsfiscal_invoice_number != null ? $request->imsfiscal_invoice_number : null;
            $new_invoice->gross_wo_tax = $gross_wo_tax;
            $new_invoice->order_id = $request->order_id != null ? $request->order_id : "";
            $new_invoice->receipt_url = $request->receipt_url != null ? $request->receipt_url : "";
            $new_invoice->receipt_code = $request->receipt_code != null ? $request->receipt_code : "";
            $new_invoice->invoice_extra = $order->order_extra;
            $new_invoice->save();

            $new_id_invoice = $new_invoice->id_invoice;
            
            $remainingpaid=$paid_amount; 
            foreach ($products as $item) {

                // Get product details
                $product = Products::select('business_products.*', 'business_brands.business_brand_name as brand', 'track_inventory')
                    ->join('business_brands', 'business_brands.id_business_brands', '=', 'business_products.brand_id')
                    ->where('id_business_products', $item['product_id'])
                    ->first();

                $total_discount = 0; 
                $other_charges = 0; 
                $total_org_price = 0;
                $batch_quantity_needed = $item['product_quantity'];
                $sufficient_batches = [];

                // Check if inventory tracking is enabled
                if ($product->track_inventory =='Yes') {

                    $productBatchService = new productBatchService();

                    // Find sufficient batches
                    $sufficient_batches = json_decode($productBatchService->findSufficientBatches(
                        $item['product_id'],
                        $order->business_id,
                        $business_store_id
                    ));

                    // Calculate total stock across all batches
                    $total_avaiable_product_batches_stock = 0;
                    if (!empty($sufficient_batches)) {
                        foreach ($sufficient_batches as $batch) {
                            $total_avaiable_product_batches_stock += $batch->instock;
                        }
                    }

                    // If no batches or insufficient stock, rollback
                    if (empty($sufficient_batches) || $total_avaiable_product_batches_stock < $item['product_quantity']) {
                        DB::rollBack();
                        return response()->json([
                            "message" => "None of the batches have sufficient quantity for product: " . $product->product,
                            "message_type" => "error",
                            "message_btn" => "danger"
                        ]);
                    }

                    // Loop through batches to allocate quantity
                    foreach ($sufficient_batches as $batch) {
                        if ($batch_quantity_needed <= 0) break;

                        $quantity_to_deduct = min(floor($batch->instock), $batch_quantity_needed);

                        $total_price = ($item['unit_price'] - $item['discount'] + $item['addition']) * $quantity_to_deduct;
                        $tax = $item['tax'];

                        // Paid calculation
                        $product_paid = min($total_price + $tax, $remainingpaid);
                        $remainingpaid -= $product_paid;

                        // Insert invoice product record
                        $new_invoice_product = new InvoiceProducts();
                        $new_invoice_product->invoice_id = $new_id_invoice;
                        $new_invoice_product->business_id = $order->business_id;
                        $new_invoice_product->product_id = $item['product_id'];
                        $new_invoice_product->product_name = $product->product;
                        $new_invoice_product->brand_name = $product->brand;
                        $new_invoice_product->staff_id = $item['staff_id'];
                        $new_invoice_product->staff_name = $item['staff'];
                        $new_invoice_product->invoice_qty = $quantity_to_deduct;
                        $new_invoice_product->invoice_product_date = Carbon::now();
                        $new_invoice_product->price = $item['unit_price'];
                        $new_invoice_product->service_addition = $item['addition'];
                        $new_invoice_product->discount_type = $item['discount_type'];
                        $new_invoice_product->discount = $item['discount'];
                        $total_discount += $item['discount'];
                        $new_invoice_product->discounted_price = $total_price;
                        $new_invoice_product->final_price = $total_price + $tax;
                        $new_invoice_product->taxes = $tax;
                        $new_invoice_product->paid = $product_paid;
                        $new_invoice_product->commission = ($product->commission_type == 'Percentage') 
                            ? $total_price * ($product->commission / 100) 
                            : $product->commission * $quantity_to_deduct;
                        $new_invoice_product->category = $product->category;

                        // Set batch info
                        $new_invoice_product->batch = $batch->batch_no;
                        $new_invoice_product->batch_id = $batch->batch_id;
                        $new_invoice_product->cog_amount = $batch->batch_amount * $quantity_to_deduct;

                        $new_invoice_product->save();

                        $cogs_total += $batch->batch_amount * $quantity_to_deduct;
                        $batch_quantity_needed -= $quantity_to_deduct;
                    }

                } else {
                    // Inventory not tracked → batch info = 0
                    $total_price = ($item['unit_price'] - $item['discount'] + $item['addition']) * $item['product_quantity'];
                    $tax = $item['tax'];

                    $product_paid = min($total_price + $tax, $remainingpaid);
                    $remainingpaid -= $product_paid;

                    $new_invoice_product = new InvoiceProducts();
                    $new_invoice_product->invoice_id = $new_id_invoice;
                    $new_invoice_product->business_id = $order->business_id;
                    $new_invoice_product->product_id = $item['product_id'];
                    $new_invoice_product->product_name = $product->product;
                    $new_invoice_product->brand_name = $product->brand;
                    $new_invoice_product->staff_id = $item['staff_id'];
                    $new_invoice_product->staff_name = $item['staff'];
                    $new_invoice_product->invoice_qty = $item['product_quantity'];
                    $new_invoice_product->invoice_product_date = Carbon::now();
                    $new_invoice_product->price = $item['unit_price'];
                    $new_invoice_product->service_addition = $item['addition'];
                    $new_invoice_product->discount_type = $item['discount_type'];
                    $new_invoice_product->discount = $item['discount'];
                    $total_discount += $item['discount'];
                    $new_invoice_product->discounted_price = $total_price;
                    $new_invoice_product->final_price = $total_price + $tax;
                    $new_invoice_product->taxes = $tax;
                    $new_invoice_product->paid = $product_paid;
                    $new_invoice_product->commission = ($product->commission_type == 'Percentage') 
                        ? $total_price * ($product->commission / 100) 
                        : $product->commission * $item['product_quantity'];
                    $new_invoice_product->category = $product->category;

                    // Batch fields = 0 or null
                    $new_invoice_product->batch = 0;
                    $new_invoice_product->batch_id = 0;
                    $new_invoice_product->cog_amount = 0;

                    $new_invoice_product->save();
                }
            }
             
            //update order status to invoiced
            $order->order_status = 'invoiced';
            $order->save();

            //Create accounting voucher for the invoice
            if($new_id_invoice > 0){
            
                $account_voucher = new AccountVouchers();
                $account_voucher->voucher_date = $new_invoice_date;            
                $account_voucher->voucher_type = 2; //Receive Voucher
                $account_voucher->voucher_status = 'Active';
                $account_voucher->created_by = session('user_name');
                $account_voucher->created_on = date('Y-m-d H:i:s');
                $account_voucher->invoice_id = $new_id_invoice;
                $account_voucher->sale_type = 'sale';        
                $account_voucher->id_account_head = 24; //1 = Accounts Receivable
                $account_voucher->voucher_date = $new_invoice_date;
                $account_voucher->description = 'Retail Sale Voucher against invoice '.$new_id_invoice.' on '.$new_invoice_date.', for '.$order->customer_name.' customer ID : '.$order->customer_id;
                $account_voucher->business_id = $order->business_id;
                $account_voucher->voucher_amount = $paid_amount;
                $account_voucher->cost_center = 1;
                $account_voucher->cost_center_name = 'Front Desk';
                $account_voucher->business_partner = '1';
                $account_voucher->business_partner_id = $order->customer_id;
                $account_voucher->business_partner_name = $order->customer_name;                
                $account_voucher->visit_id = $order->id_customer_order;            
                $account_voucher->payment_mode = $payment_mode;
                $account_voucher->auto_voucher = 'Yes';
                $account_voucher->save();
                $new_voucher_id = $account_voucher->id_account_vouchers;
            
                //Get the event mappings for Invoice Creation id_events = 1
                //business id for Ho if 'ho_accounts' = 'Yes'            
                if(session('ho_accounts')=='Yes'){
                    $new_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                } else {
                    $new_business_id = $order->business_id;
                }
                $event_mappings = AccountEventMapping::where('account_event_id', 1)->where('business_id', $new_business_id)->get();
                $debit_amounts = [];
                $credit_amounts = [];
                $debit_accounts = array();
                $credit_accounts = array();
                foreach($event_mappings as $mapping){
                    
                    if($mapping['transaction_type']=='debit'){
                        array_push($debit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    } else {
                        array_push($credit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    }
                   
                    if($mapping['transaction_type']=='debit'){
                        //make debit entry data
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Cash'  ? $paid_amount : 0 ]);}
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Mixed'  ? $paid_cash : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Card'  || $payment_mode == 'D-Card' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Mixed' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_check'){array_push($debit_amounts, [ 'entity_name' => 'paid_check', 'amount' => $payment_mode == 'Check' ? $paid_check : 0 ]);}
                        if($mapping['entity_name']=='paid_online'){array_push($debit_amounts, [ 'entity_name' => 'paid_online', 'amount' => $payment_mode=="Online" ? $paid_online : 0 ]);}
                        if($mapping['entity_name']=='paid_voucher'){array_push($debit_amounts, [ 'entity_name' => 'paid_voucher', 'amount' => $payment_mode == 'Voucher' ? $paid_voucher : 0 ]);}
                        if($mapping['entity_name']=='loyalty_used'){array_push($debit_amounts, [ 'entity_name' => 'loyalty_used', 'amount' => $paid_loyalty > 0 ? $paid_loyalty : 0 ]);}
                        if($mapping['entity_name']=='loyalty_expense'){array_push($debit_amounts, [ 'entity_name' => 'loyalty_expense', 'amount' => $loyaltyearned ]);}
                        if($mapping['entity_name']=='retained_amount_used'){array_push($debit_amounts, [ 'entity_name' => 'retained_amount_used', 'amount' => $retained_amount_used ]);}
                        if($mapping['entity_name']=='sale_discount_retail'){array_push($debit_amounts, [ 'entity_name' => 'sale_discount_retail', 'amount' => $total_discount ]);}
                        if($mapping['entity_name']=='balance'){array_push($debit_amounts, [ 'entity_name' => 'balance', 'amount' => $balance ]);}
                        if($mapping['entity_name']=='advance_adjusted_against_product_order'){array_push($debit_amounts, [ 'entity_name' => 'advance_adjusted_against_product_order', 'amount' => $advance_amount ]);}

                    } else if($mapping['transaction_type']=='credit'){
                        //make credit entry data
                        if($mapping['entity_name']=='cc_fee'){array_push($credit_amounts, [ 'entity_name' => 'cc_fee', 'amount' => $cc_charge ]);}                    
                        if($mapping['entity_name']=='return_cash'){array_push($credit_amounts, [ 'entity_name' => 'return_cash', 'amount' => $retain_enabled == "No" ? $return_amount : 0 ]);}
                        if($mapping['entity_name']=='retained_amount'){array_push($credit_amounts, [ 'entity_name' => 'retained_amount', 'amount' => $retain_enabled=="Yes" ? $retaining_now : 0 ]);}                    
                        if($mapping['entity_name']=='loyalty_earned'){array_push($credit_amounts, [ 'entity_name' => 'loyalty_earned', 'amount' => $loyaltyearned ]);}
                        if($mapping['entity_name']=='sales_tax'){array_push($credit_amounts, [ 'entity_name' => 'sales_tax', 'amount' => $tax_total ]);}
                        if($mapping['entity_name']=='cc_tip'){array_push($credit_amounts, [ 'entity_name' => 'cc_tip', 'amount' => $cc_tip ]);}
                        if($mapping['entity_name']=='grosstotal_retail'){array_push($credit_amounts, [ 'entity_name' => 'grosstotal_retail', 'amount' => ($gross_wo_tax + $total_discount) ]);}
                        if($mapping['entity_name']=='delivery_charges'){array_push($credit_amounts, [ 'entity_name' => 'delivery_charges', 'amount' => $delivery_charges ]);}
                    }
                }
                //get the sum of debit amounts and credit amounts
                $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;

                //add rouding adjustment if any
                if($rounded_adjustment != 0){                    
                    if($debit_sum > $credit_sum){
                        array_push($credit_amounts, [ 'entity_name' => 'rounded_adjustment', 'amount' => $rounded_adjustment ]);
                        $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                        $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                    } else {
                        array_push($debit_amounts, [ 'entity_name' => 'rounded_adjustment', 'amount' => $rounded_adjustment ]);
                        $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                        $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                    }                    
                }
                // DB::rollBack(); //Rollback the transaction
                // return array_merge($debit_amounts, $credit_amounts);

                if($debit_sum == null || $credit_sum == null || $debit_sum != $credit_sum){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit and Credit amounts do not match. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                } else if($debit_sum == 0 || $credit_sum == 0){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit or Credit amounts are zero. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }else{                    
                    //Insert voucher Details
                    foreach($debit_accounts as $debit){
                        $debit_parts = explode("|", $debit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $debit_parts[0];
                        $entity = $debit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->debit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $debit_amounts));
                        $new_voucher_details->credit = 0;    
                        if($new_voucher_details->debit != 0){                                            
                            $new_voucher_details->save();
                        }
                    }
                    foreach($credit_accounts as $credit){
                        $credit_parts = explode("|", $credit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $credit_parts[0];
                        $new_voucher_details->debit = 0;
                        $entity = $credit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->credit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $credit_amounts));
                        if($new_voucher_details->credit != 0){           
                            $new_voucher_details->save();
                        }
                    }
                }            
                
                if($cogs_total > 0){

                    //Create Cost of Goods Sold account voucher
                    $cog_account_voucher = new AccountVouchers();
                    $cog_account_voucher->voucher_date = $new_invoice_date;
                    $cog_account_voucher->voucher_type = 3; //Journal Voucher
                    $cog_account_voucher->voucher_status = 'Active';
                    $cog_account_voucher->created_by = session('user_name');
                    $cog_account_voucher->created_on = date('Y-m-d H:i:s');
                    $cog_account_voucher->invoice_id = $new_id_invoice;
                    $cog_account_voucher->description = "Cost of Goods Sold for Invoice ID " . $new_id_invoice;
                    $cog_account_voucher->business_id = $order->business_id;
                    $cog_account_voucher->voucher_amount = $cogs_total;
                    $cog_account_voucher->cost_center = 1;
                    $cog_account_voucher->cost_center_name = 'Front Desk';
                    $cog_account_voucher->business_partner = '1';
                    $cog_account_voucher->business_partner_id = $order->customer_id;
                    $cog_account_voucher->business_partner_name = $order->customer_name;
                    $cog_account_voucher->auto_voucher = 'Yes';
                    $cog_account_voucher->payment_mode = $payment_mode;

                    $cog_account_voucher->save();

                    $new_cog_voucher_id = $cog_account_voucher->id_account_vouchers;

                    //Insert COGS voucher Details
                    //Get account heads for COGS and Inventory from account_event_mappings
                
                    $event_mappings = AccountEventMapping::where('account_event_id', 23)->where('business_id', $common_business_id)->get();
                    $debit_amounts = [];
                    $credit_amounts = [];
                    $debit_accounts = array();
                    $credit_accounts = array();
                    foreach($event_mappings as $mapping){
                        
                        if($mapping['transaction_type']=='debit'){
                            array_push($debit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                        } else {
                            array_push($credit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                        }

                    
                        
                        if($mapping['transaction_type']=='debit'){
                            //make debit entry data
                            if($mapping['entity_name']=='cogs'){array_push($debit_amounts, [ 'entity_name' => 'cogs', 'amount' => $cogs_total ]);}
                        } else if($mapping['transaction_type']=='credit'){
                            //make credit entry data
                            if($mapping['entity_name']=='inventory'){array_push($credit_amounts, [ 'entity_name' => 'inventory', 'amount' => $cogs_total ]);}                    
                        }

                    }
                    //get the sum of debit amounts and credit amounts
                    $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                    $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                    
                    if($debit_sum == null || $credit_sum == null || $debit_sum != $credit_sum){
                        DB::rollBack(); //Rollback the transaction
                        Log::info('3');
                        return response()->json([
                            "message" => "COGs debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit and Credit amounts do not match. Please contact system administrator.",
                            "message_type" => "error",
                            "message_btn" => "danger"
                        ]);
                    } 
                    else if($debit_sum == 0 || $credit_sum == 0){
                        DB::rollBack(); //Rollback the transaction
                        return response()->json([
                            "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit or Credit amounts are zero. Please contact system administrator.",
                            "message_type" => "error",
                            "message_btn" => "danger"
                        ]);
                    }
                    else{                    
                        //Insert voucher Details
                        foreach($debit_accounts as $debit){
                            $debit_parts = explode("|", $debit);
                            $new_cog_voucher_details = new AccountVoucherDetail();
                            $new_cog_voucher_details->account_voucher_id = $new_cog_voucher_id;
                            $new_cog_voucher_details->account_head_id = $debit_parts[0];
                            $entity = $debit_parts[2]; // this is 'paid_cash' etc.
                            $new_cog_voucher_details->debit = array_sum(array_map(function($item) use ($entity) {
                                return $item['entity_name'] === $entity ? $item['amount'] : 0;
                            }, $debit_amounts));
                            $new_cog_voucher_details->credit = 0;    
                            if($new_cog_voucher_details->debit != 0){                                            
                                $new_cog_voucher_details->save();
                            }
                        }
                        foreach($credit_accounts as $credit){
                            $credit_parts = explode("|", $credit);
                            $new_cog_voucher_details = new AccountVoucherDetail();
                            $new_cog_voucher_details->account_voucher_id = $new_cog_voucher_id;
                            $new_cog_voucher_details->account_head_id = $credit_parts[0];
                            $new_cog_voucher_details->debit = 0;
                            $entity = $credit_parts[2]; // this is 'paid_cash' etc.
                            $new_cog_voucher_details->credit = array_sum(array_map(function($item) use ($entity) {
                                return $item['entity_name'] === $entity ? $item['amount'] : 0;
                            }, $credit_amounts));
                            if($new_cog_voucher_details->credit != 0){           
                                $new_cog_voucher_details->save();
                            }
                        }
                    }
                }
            }
            
            //  GIFT VOUCHER UPDATE
            if($request->voucher_number !='' && $request->voucher_number !=0){
                $gift_voucher_number = 'C' . $request->voucher_number; 
                $gift_vouche_remaining_amount =$request->gift_vouche_remaining_amount;
                $gift_voucher_remaining_services =$request->gift_voucher_remaining_services;
                DB::table('order_vouchers')
                ->where('voucher_number', $gift_voucher_number)
                ->update([
                    'remaining_amount'       => $gift_vouche_remaining_amount,
                    'remaining_service_ids'  => $gift_voucher_remaining_services,
                    'voucher_status'         => $gift_vouche_remaining_amount > 0 ? 'open' : 'closed',
                ]);
            }

            DB::commit(); //If we reach here, commit the transaction

            return response()->json([
                "message" => 'New Order Invoice Created with ID '.$new_id_invoice,
                "message_type" => "success",
                "message_btn" => "success",
                "new_id_invoice" => $new_id_invoice
            ]);
        } catch (\Exception $e) {
            // If anything failed, rollback
            DB::rollBack();
            return response()->json([
                "message" => "Error creating invoice: " . $e->getMessage(),
                "message_type" => "error",               
                "message_btn" => "danger",
                "new_id_invoice" => 0
            ]);
        } 
    }

    public function create_recovery_invoice(Request $request){

       // return $request;
        $org_invoice_id = $request->input('original_invoice_id');
        
        $retain_enabled = $request->retain != null ? $request->retain : "No";
        $return_cash = $request->return_cash != null ? (float)$request->return_cash : 0;
        $retaining_now = $request->return_cash != null ? (float)$request->return_cash : 0;

        $retained_amount_used = $request->paid_retained != null ? (float)$request->paid_retained : 0;
       
        $rounded_adjustment = $request->rounded_adjustment != null ? (float)$request->rounded_adjustment : 0;

        $voucher_number = $request->voucher_number != null ? $request->voucher_number : '';
        
        $invoice_remarks = $request->remarks != null ? $request->remarks : '';

        $cc_fee = $request->cc_fee != null ? (float)$request->cc_fee : 0;

        $balance = $request->balance != null ? (float)$request->balance : 0;

        $payment_mode = $request->input('payment_mode');

        $paid_amount = $request->paid_amount != null ? (float)$request->paid_amount : 0;
        $paid_cash = $request->paid_cash != null ? (float)$request->paid_cash : 0;
        $paid_card = $request->paid_card != null ? (float)$request->paid_card : 0;
        $paid_voucher = $request->paid_voucher != null ? (float)$request->paid_voucher : 0;
        $paid_check = $request->paid_check != null ? (float)$request->paid_check : 0;
        $paid_online = $request->paid_online != null ? (float)$request->paid_online : 0;
        $paid_loyalty = $request->paid_loyalty != null ? (float)$request->paid_loyalty : 0;
        $paid_retained = $request->paid_retained != null ? (float)$request->paid_retained : 0;

         if($payment_mode == "Mixed"){
                $paid_cash = $request->paid_card;
                $paid_card = $request->paid_cash;
                $paid_amount = $paid_amount ==0 ? (float)$paid_cash + (float)$paid_card : $paid_amount;
            } else if($payment_mode=="Cash") {
                $paid_cash = $request->paid_amount;
            } else if($payment_mode=="Card" || $payment_mode=="D-Card"){
                $paid_card = $request->paid_amount;
            } else if($payment_mode=="Debit Card"){
                $paid_card = $request->paid_amount;
            } else if($payment_mode=="Check"){
                $paid_check = $request->paid_amount;
            } else if($payment_mode=="Online"){
                $paid_online = $request->paid_amount;
            } 

        $instrument_number = $request->input('instrument_number') != null ? $request->input('instrument_number') : '';
        $remarks = $request->input('remarks') != null ? $request->input('remarks') : '';

        if(empty($org_invoice_id) || $org_invoice_id < 1 || null == $org_invoice_id){
             return back()->withErrors([
                'message' => 'Original Invoice ID not passed to the API.',
            ]);
        }

        if($payment_mode == null || $payment_mode == ''){
             return back()->withErrors([
                'message' => 'Payment mode not selected.',
            ]);
        }

        //Fetch the original invoice
        $original_invoice = Invoice::select('invoice.*', 'business.sh_hide', 'business.s_min_sh')
        ->join('business', 'business.id_business', '=', 'invoice.business_id')
        ->where('id_invoice', $org_invoice_id);
        $original_invoice = $original_invoice->first();

        if(!$original_invoice){
            return response()->json([
                'message' => 'Original Invoice not found.',
                "message_type" => "error",
                "message_btn" => "danger",
            ]);
        }

        if($original_invoice->balance == null || $original_invoice->balance <= 0){
            return response()->json([
                'message' => 'Original Invoice does not have any balance to recover.',
                "message_type" => "error",
                "message_btn" => "danger",
            ]);
        }

        //get the shadow seq for compatibility
            // Default values
            $seq = 1;
            $day_seq = 1;

            // Query only once with proper coalesce
            $seq_query = Invoice::selectRaw('
                    COALESCE(MAX(invoice_seq), 0) + 1 AS seq,
                    COALESCE(MAX(invoice_day_seq), 0) + 1 AS day_seq
                ')
                ->whereDate('invoice_date', date('Y-m-d'))
                ->where('business_id', $original_invoice->business_id)
                ->where('invoice_status', 'valid')
                ->first();

            if ($seq_query) {
                $seq = $seq_query->seq;
                $day_seq = $seq_query->day_seq;
            }

            // Apply special case handling
            if ($payment_mode !== 'Card' && $payment_mode !== 'Mixed' && $original_invoice->sh_hide === 'Yes') {
                if (!empty($business->s_min_sh)) {
                    if ($paid_amount > $original_invoice->s_min_sh || $paid_amount == 0) {
                        $seq = 0;
                    }
                } else {
                    $seq = 0;
                }
            }

            //Get the next Invoice # for the business
            $today = date('Y-m-d');

            $last_sequence = Invoice::where('business_id', $original_invoice->business_id)
                ->whereDate('invoice_date', $today)
                ->max('invoice_day_seq');

            $next_sequence = $last_sequence ? $last_sequence + 1 : 1;
            // Save both invoice_day_seq and invoice_number
            $new_invoice_number = date('m') . "-" . date('d') . "-" . $next_sequence;

            $new_invoice_date = date('Y-m-d H:i:s');

        try{
            DB::beginTransaction();
            //Create a recovery invoice
            $recovery_invoice = NEW Invoice();
            $recovery_invoice->invoice_number = $new_invoice_number;
            $recovery_invoice->invoice_day_seq = $next_sequence;
            $recovery_invoice->invoice_seq = $seq;
            $recovery_invoice->customer_id = $original_invoice->customer_id;
            $recovery_invoice->customer_name = $original_invoice->customer_name;
            $recovery_invoice->customer_address = $original_invoice->customer_address;
            $recovery_invoice->customer_cell = $original_invoice->customer_cell;
            $recovery_invoice->customer_email = $original_invoice->customer_email;
            $recovery_invoice->invoice_date = $new_invoice_date;
            $recovery_invoice->visit_id = $original_invoice->visit_id;
            $recovery_invoice->invoice_type = $original_invoice->invoice_type;
            $recovery_invoice->reference_invoice_number = $original_invoice->invoice_number;
            $recovery_invoice->paid_earlier = $original_invoice->paid_amount + $original_invoice->paid_earlier;
            $recovery_invoice->org_invoice_id = $original_invoice->id_invoice;
            $recovery_invoice->business_id = $original_invoice->business_id;
            $recovery_invoice->sub_total = 0;
            $recovery_invoice->discount = 0;
            $recovery_invoice->paid_amount = $paid_amount > 0 ? $paid_amount : 0;
            $recovery_invoice->paid_cash = $payment_mode == "Cash" ? $paid_amount : 0;
            $recovery_invoice->paid_card = $payment_mode == "Card" || $payment_mode == "D-Card" ? $paid_amount : 0;
            $recovery_invoice->paid_voucher = $payment_mode == "Voucher" ? $paid_amount : 0;
            $recovery_invoice->paid_check = $payment_mode == "Check" ? $paid_amount : 0;
            $recovery_invoice->paid_online = $payment_mode == "Online" ? $paid_amount : 0;
            $recovery_invoice->paid_loyalty = $paid_loyalty > 0 ? $paid_loyalty : 0;
            $recovery_invoice->paid_retained = $paid_retained > 0 ? $paid_retained : 0;
            $recovery_invoice->loyalty_used = $paid_loyalty > 0 ? $paid_loyalty : 0;

            $recovery_invoice->retained_amount = 0;
            if ($retain_enabled === "Yes" && $retaining_now > 0) {
                $recovery_invoice->retained_amount = $retaining_now > 0 ? $retaining_now : 0;
            }
            $recovery_invoice->cc_charge = $cc_fee > 0 ? $cc_fee : 0;
            $recovery_invoice->total_payable = $original_invoice->balance >= 0 ? $original_invoice->balance + $cc_fee : 0;
            $recovery_invoice->advance_amount = 0;
            $recovery_invoice->other_charges = 0;
            $recovery_invoice->rounded_adjustment = $rounded_adjustment;
            $recovery_invoice->retained_used = $paid_retained > 0 ? "Yes" : "No";
            $recovery_invoice->returnamount = 0;
            if ($retain_enabled === "No" && $return_cash > 0) {
                $recovery_invoice->returnamount = $return_cash;
            }

            $recovery_invoice->retained_amount_used = $retained_amount_used > 0 ? $retained_amount_used : 0;
            $recovery_invoice->instrument_number = $instrument_number;
            $recovery_invoice->payment_mode = $payment_mode;
            $recovery_invoice->balance = $balance > 0 ? $balance : 0;
            $recovery_invoice->remarks = $invoice_remarks;
            // $recovery_invoice->retained_amount = $retained_amount_used > 0 ? $retained_amount_used : 0;
            $recovery_invoice->instrument_number = $voucher_number != "" ? $voucher_number : $instrument_number;
            $recovery_invoice->invoice_status = 'valid';
            
            $recovery_invoice->is_recovery = $balance > 0 ? "Yes" : "No";

            $recovery_invoice->sub_total=0;
            $recovery_invoice->discount=0;
            $recovery_invoice->other_charges=0;
            $recovery_invoice->gross_wo_tax=0;
            $recovery_invoice->tax_total=0;
            $recovery_invoice->gross_amount=0;
            $recovery_invoice->net_amount=0;
            $recovery_invoice->visit_time = $original_invoice->visit_time;
            $recovery_invoice->created_by = session('user_name');
            
            $recovery_invoice->save();
        
            $new_id_invoice = $recovery_invoice->id_invoice;

            //Update the original invoice is_recovery field to No
            $original_invoice->is_recovery = "No";
            $original_invoice->save();


            //Create Account Voucher
            if($new_id_invoice > 0){
                                    
                $account_voucher = new AccountVouchers();
                $account_voucher->voucher_date = date('Y-m-d H:i:s');            
                $account_voucher->voucher_type = 2; //Receipt
                $account_voucher->voucher_status = 'Active';
                $account_voucher->created_by = session('user_name');
                $account_voucher->created_on = date('Y-m-d H:i:s');
                $account_voucher->invoice_id = $new_id_invoice;
                $account_voucher->sale_type = $original_invoice->invoice_type;        
                $account_voucher->id_account_head = 24; //1 = Accounts Receivable
                $account_voucher->voucher_date = date('Y-m-d H:i:s');
                $account_voucher->description = 'Recovery Service Sale Voucher against original invoice '.$original_invoice->id_invoice.' with id '.$new_id_invoice.' on '.date('Y-m-d H:i:s').', for '.$original_invoice->customer_name.' customer ID : '.$original_invoice->customer_id;
                $account_voucher->business_id = $recovery_invoice->business_id;
                $account_voucher->voucher_amount = $paid_amount;
                $account_voucher->cost_center = 1;
                $account_voucher->cost_center_name = 'Front Desk';
                $account_voucher->business_partner = '1';
                $account_voucher->business_partner_id = $original_invoice->customer_id;
                $account_voucher->business_partner_name = $original_invoice->customer_name;
                $account_voucher->invoice_id = $new_id_invoice;
                $account_voucher->visit_id = $original_invoice->visit_id;            
                $account_voucher->payment_mode = $payment_mode;
                $account_voucher->auto_voucher = 'Yes';


                $account_voucher->save();
                $new_voucher_id = $account_voucher->id_account_vouchers;
            
                //Get the event mappings for Invoice Creation id_events = 1
                if(session('ho_accounts')=='Yes'){
                    $new_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                } else {
                    $new_business_id = $recovery_invoice->business_id;
                }
                $event_mappings = AccountEventMapping::where('account_event_id', 1)->where('business_id', $new_business_id)->get();
                
                $debit_amounts = [];
                $credit_amounts = [];
                $debit_accounts = array();
                $credit_accounts = array();
                foreach($event_mappings as $mapping){
                    

                    if($mapping['transaction_type']=='debit'){
                        array_push($debit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    } else {
                        array_push($credit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                    }
                   
                    if($mapping['transaction_type']=='debit'){
                        //make debit entry data
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Cash'  ? $paid_amount : 0 ]);}
                        if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $payment_mode == 'Mixed'  ? $paid_cash : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Card'  || $payment_mode == 'D-Card' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $payment_mode == 'Mixed' ? $paid_card : 0 ]);}
                        if($mapping['entity_name']=='paid_check'){array_push($debit_amounts, [ 'entity_name' => 'paid_check', 'amount' => $payment_mode == 'Check' ? $paid_check : 0 ]);}
                        if($mapping['entity_name']=='paid_online'){array_push($debit_amounts, [ 'entity_name' => 'paid_online', 'amount' => $payment_mode=="Online" ? $paid_online : 0 ]);}
                        if($mapping['entity_name']=='paid_voucher'){array_push($debit_amounts, [ 'entity_name' => 'paid_voucher', 'amount' => $payment_mode == 'Voucher' ? $paid_voucher : 0 ]);}
                        if($mapping['entity_name']=='loyalty_used'){array_push($debit_amounts, [ 'entity_name' => 'loyalty_used', 'amount' => $paid_loyalty > 0 ?  $paid_loyalty : 0 ]);}                        
                        if($mapping['entity_name']=='retained_amount_used'){array_push($debit_amounts, [ 'entity_name' => 'retained_amount_used', 'amount' => $retained_amount_used ]);}                        
                        
                    } else if($mapping['transaction_type']=='credit'){
                        //make credit entry data
                        if($mapping['entity_name']=='cc_fee'){array_push($credit_amounts, [ 'entity_name' => 'cc_fee', 'amount' => $cc_fee ]);} 
                        if($mapping['entity_name']=='return_cash'){array_push($credit_amounts, [ 'entity_name' => 'return_cash', 'amount' => $retain_enabled == "No" ? $return_cash : 0 ]);}
                        if($mapping['entity_name']=='retained_amount'){array_push($credit_amounts, [ 'entity_name' => 'retained_amount', 'amount' => $retain_enabled=="Yes" ? $retaining_now : 0 ]);}
                        if($mapping['entity_name']=='receivable'){array_push($credit_amounts, [ 'entity_name' => 'receivable', 'amount' => ($paid_amount+$retained_amount_used + $paid_loyalty) - $cc_fee - $retaining_now  ]);}

                    }
                }
                //get the sum of debit amounts and credit amounts
                $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;

                //add rouding adjustment if any 
                if($rounded_adjustment != 0){                    
                    if($debit_sum > $credit_sum){
                        array_push($credit_amounts, [ 'entity_name' => 'rounded_adjustment', 'amount' => $rounded_adjustment ]);
                        $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                        $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                    } else {
                        array_push($debit_amounts, [ 'entity_name' => 'rounded_adjustment', 'amount' => $rounded_adjustment ]);
                        $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                        $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                    }                    
                }
                // DB::rollBack(); //Rollback the transaction
                // return array_merge($debit_amounts, $credit_amounts);

                if($debit_sum == null || $credit_sum == null || $debit_sum != $credit_sum){
                    DB::rollBack(); //Rollback the transaction
                    Log::info('4');
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit and Credit amounts do not match. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                } else if($debit_sum == 0 || $credit_sum == 0){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([
                        "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit or Credit amounts are zero. Please contact system administrator.",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                
                
                }else{                    
                    //Insert voucher Details
                    foreach($debit_accounts as $debit){
                        $debit_parts = explode("|", $debit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $debit_parts[0];
                        $entity = $debit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->debit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $debit_amounts));
                        $new_voucher_details->credit = 0;    
                        if($new_voucher_details->debit != 0){                                            
                            $new_voucher_details->save();
                        }
                    }
                    foreach($credit_accounts as $credit){
                        $credit_parts = explode("|", $credit);
                        $new_voucher_details = new AccountVoucherDetail();
                        $new_voucher_details->account_voucher_id = $new_voucher_id;
                        $new_voucher_details->account_head_id = $credit_parts[0];
                        $new_voucher_details->debit = 0;
                        $entity = $credit_parts[2]; // this is 'paid_cash' etc.
                        $new_voucher_details->credit = array_sum(array_map(function($item) use ($entity) {
                            return $item['entity_name'] === $entity ? $item['amount'] : 0;
                        }, $credit_amounts));
                        if($new_voucher_details->credit != 0){           
                            $new_voucher_details->save();
                        }
                    }
                }
                //if we reach here, commit the transaction
                DB::commit();
                return response()->json([           
                    "message" => "Invoice Created with ID ".$new_id_invoice,            
                    "message_type" => "success",
                    "message_btn" => "success",
                    "new_id_invoice" => $new_id_invoice
                ]);

            } else {
                // Handle the case where the invoice creation failed
                 DB::rollBack();
                return response()->json([
                    "message" => "Error creating recovery invoice: Invoice ID not generated.",
                    "message_type" => "error",
                    "message_btn" => "danger"
                ]);
            }

           
        }catch(\Exception $e){
            DB::rollBack();
            return response()->json([
                "message" => "Error creating recovery invoice: " . $e->getMessage(),
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }
        
    }

    public function cancel_invoice(Request $request){
        try{
            DB::beginTransaction();
            $id_invoice = $request->input('id_invoice');

            if(empty($id_invoice) || $id_invoice < 1 || null == $id_invoice){
                return back()->withErrors([
                    'message' => 'Invoice ID not passed to the API.',
                ]);
            }

            // Cancel the invoice 
            $invoice = Invoice::find($id_invoice);

            if($invoice){            
                $invoice->invoice_status = 'Cancelled';
                $invoice->cancelled_by = session('user_name');
                $invoice->cancelled_at = date('Y-m-d H:i:s');
                $invoice->cancelreason = $request->input('cancel_reason') != null ? $request->input('cancel_reason') : '';
                
                $invoice->save();

                //Also mark the visit as open if service invoice
                if($invoice->invoice_type == "service" && $invoice->visit_id != null && $invoice->visit_id > 0 ){
                    $visit = CustomerVisits::find($invoice->visit_id);
                    if($visit){
                        $visit->visit_status = 'open';
                        $visit->save();
                    }
                } else {
                    $order = CustomerOrders::find($invoice->visit_id);
                    if($order){
                        $order->order_status = 'open';
                        $order->save();
                    }

                }

                //check if it is a recovery invoice
                if($invoice->org_invoice_id != null && $invoice->org_invoice_id > 0){
                    //Fetch the original invoice
                    $original_invoice = Invoice::find($invoice->org_invoice_id);
                    if($original_invoice){
                        $original_invoice->is_recovery = "Yes";
                        $original_invoice->save();
                    }
                }

                //check if invoice payment mode is voucher, if yes, reactivate the voucher
                if($invoice->payment_mode == "Voucher"){
                    OrderVouchers::where('order_vouchers.voucher_number','=', $invoice->instrument_number)
                    ->update([
                        'voucher_status' => 'open',
                        'remaining_amount' => DB::raw("remaining_amount + " . (float) $invoice->paid_voucher),
                        'type' => 'amount'
                ]);
                }

                //Cancel all Account Vouchers associated with this invoice
                AccountVouchers::where('account_vouchers.invoice_id','=', $invoice->id_invoice)
                ->update(['voucher_status' => 'Cancelled', 'cancelled_by' => session('user_name'), 'cancelled_on' => date('Y-m-d H:i:s')]);

                DB::commit();
                return response()->json([
                    "message" => "Invoice with ID ".$id_invoice." has been cancelled.",
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }
            DB::rollBack();
            return response()->json([
                "message" => "Invoice not found.",
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        } catch(\Exception $e){
            DB::rollBack();
            return response()->json([
                "message" => "Error cancelling invoice: " . $e->getMessage(),
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }
    }

    public function send_invoice_sms($id_invoice, $total_loyalty = 0)
    {
        
        //Fetch invoice details
        $invoice = DB::table('invoice')
            ->leftJoin('customers', 'invoice.customer_id', '=', 'customers.id_customers')
            ->join('business', 'invoice.business_id', '=', 'business.id_business')
            ->select('invoice.*', 'customers.customer_name as customer_name', 'customers.customer_cell as customer_phone', 'business.business_name as business_name'
            ,'business.loyalty_enable', 'business.r_loyalty_enable', 'business.s_loyalty', 'business.show_amount', 'business.show_points')
            
            ->where('invoice.id_invoice', $id_invoice)
            ->first();

        if($invoice && $invoice->customer_phone){

            $name_parts = $invoice->customer_name ? explode(" ", $invoice->customer_name) : [];
            $first_name = count($name_parts) > 2 ? $name_parts[1] : (count($name_parts) == 2 ? $name_parts[0] : "Customer");

            $message = "Dear " . $first_name . ",\nThank you for visiting ".$invoice->business_name.".\n";
            if($invoice->show_points == "Yes"){
                $message .= "Points earned today: " . round($invoice->loyalty_earned) . ".\nTotal points: " . round((Float)$total_loyalty + (Float)$invoice->loyalty_earned) . ".\n";
            }
            if($invoice->show_amount == "Yes"){
                $message .='Bill '. $invoice->total_payable .".\n".'Paid '. $invoice->paid_amount.".\n";
                if($invoice->balance > 0){
                    $message .= 'Balance '. $invoice->balance;
                }
            }
            //Send SMS using a SMS service
            try {
                // Assuming there's an SMS service class to handle sending
                $smsService = new SMSService(new SMSCred());
                $smsService->sendSMS($message, $invoice->customer_phone, 'InvoiceSMS', $invoice->business_id, $id_invoice);
               // (new SMSService())->sendSMS($message, $invoice->customer_phone, 'InvoiceSMS', $invoice->business_id, $id_invoice);
            } catch (\Exception $e) {
                // Log the error but do not interrupt the main flow
                Log::error("Failed to send SMS for invoice {$id_invoice}: " . $e->getMessage());
            }

        }

    }

    public function send_receipt_sms($id_invoice, $customer_cell, $customer_name, $invoice_type='service', $total_loyalty = 0, $business_id = 1, $business_name = null){

        if($invoice_type != 'service' && $invoice_type != 'sale'){
            return;
        }
        
        
        try {
            //Call the mexyon receipts API
            if($invoice_type == 'service') {
                // Assuming there's an SMS service class to handle sending
                $smsService = new SMSService(new SMSCred());
                $response = $smsService->sendSMS($total_loyalty, $customer_cell, 'ReceiptsSMS', $business_id, $id_invoice);
            } else if($invoice_type == 'sale'){
                $smsService = new SMSService(new SMSCred());
                $response = $smsService->sendSMS($total_loyalty, $customer_cell, 'ReceiptsSMSretail', $business_id, $id_invoice);
            }
            //Send the actuall SMS now
            if($response && $response !=""){
                $smsService = new SMSService(new SMSCred());
                $smsService->sendSMS("Hi ".$customer_name.",\nClick here to view your ". $business_name ." digital receipt: ". $response, $customer_cell, 'InvoiceSMS', $business_id, $id_invoice);
            }

        } catch (\Exception $e) {
            // Log the error but do not interrupt the main flow
            Log::error("Failed to send Receipt SMS for invoice {$id_invoice}: " . $e->getMessage());
        }
        
    }

    public function get_customer_invoices(Request $request, $id_customers)
    {
        $columns = [
            'invoice.id_invoice',
            'invoice.invoice_date',
            'business.business_name',
            'invoice.services',
            'invoice.staff_names',
            'invoice.total_service_price',
            'invoice.gross_wo_tax',
            'invoice.tax_total',
            'invoice.total_payable'
        ];

        $query = Invoice::select(
                'invoice.id_invoice',
                'invoice.invoice_number',
                'invoice.invoice_date',
                DB::raw("DATE_FORMAT(invoice.invoice_date, '%d/%m/%Y %r') as formatted_invoice_date"),
                DB::raw("DATEDIFF(NOW(), invoice.invoice_date) as days_since_invoice"),
                DB::raw('GROUP_CONCAT(DISTINCT invoice_details.service_name SEPARATOR ", ") as services'),
                DB::raw('GROUP_CONCAT(DISTINCT invoice_staff.staff_name SEPARATOR ", ") as staff_names'),
                DB::raw('SUM(invoice_details.price - invoice_details.discount + invoice_details.service_addition) as total_service_price'),
                'invoice.gross_wo_tax',
                'invoice.tax_total',
                'invoice.total_payable',
                'business.business_name',
                'business.business_logo'
            )
            ->join('business', 'invoice.business_id', '=', 'business.id_business')
            ->join('invoice_details', 'invoice.id_invoice', '=', 'invoice_details.invoice_id')
            ->join('invoice_staff', 'invoice.id_invoice', '=', 'invoice_staff.invoice_id')
            ->where(DB::raw('COALESCE(reference_invoice_number, "")'), '=', "")
            ->where('invoice_status', 'valid')
            ->where('invoice.customer_id', $id_customers)
            ->groupBy('invoice.id_invoice');

        // Searching
        if (!empty($request->input('search.value'))) {
            $search = $request->input('search.value');
            $query->where(function ($q) use ($search) {
                $q->where('invoice.invoice_number', 'like', "%{$search}%")
                ->orWhere('business.business_name', 'like', "%{$search}%")
                ->orWhere('invoice_details.service_name', 'like', "%{$search}%")
                ->orWhere('invoice_staff.staff_name', 'like', "%{$search}%");
            });
        }

        //Ordering
        if ($request->has('order')) {
            $order = $request->input('order')[0];
            $columnIndex = $order['column'];
            $columnName = $columns[$columnIndex] ?? 'invoice.invoice_date';
            $sortDir = $order['dir'] ?? 'desc';
            $query->orderBy($columnName, $sortDir);
        } else {
            $query->orderBy('invoice.invoice_date', 'desc');
        }


       // Pagination
        $start = $request->input('start', 0);
        $length = $request->input('length', 10);

        // Clone before limiting
        $filteredQuery = clone $query;

        // Correct count for grouped results
        $recordsFiltered = $filteredQuery->getQuery()->getCountForPagination();

        // Apply pagination
        $data = $query->skip($start)->take($length)->get();

        // Total count
        $recordsTotal = Invoice::where('customer_id', $id_customers)
            ->where(DB::raw('COALESCE(reference_invoice_number, "")'), '=', "")
            ->where('invoice_status', 'valid')
            ->count();

        // Response
        return response()->json([
            'draw' => intval($request->input('draw')),
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $data,
        ]);

    } 

    // customer order print
    public  function customer_order_view(Request $request, $order_id){
        $invoice = [];
            // return $invoice;
        $business = DB::table('business')
            ->where('id_business', session('business_id'))
            ->first();
        $checkquery=[];

         $order = CustomerOrders::select('id_customer_order', 'order_type', 'delivery_charges', 'order_extra', 'business_id', 'customer_id', 'created_by', 'order_status', 'online_order_log_id', 'shipping_address', 'billing_address',
            DB::raw('date_format(customer_order_date, "%Y-%m-%d") as customer_order_date'),
            DB::raw('date_format(customer_order_date, "%H:%i") as customer_order_time')
            )
            ->where('id_customer_order', "=", $order_id)            
            ->first();

            //if no order found
            if(!$order){
                return back()->withErrors([
                    'message' => 'Order not found or already closed.',
                ]);
            }

            if($order->order_status == 'invoiced'){
                //redirect to existing invoice
                $existing_invoice = Invoice::where('visit_id', '=', $order->id_customer_order)->where('invoice_type', '=', 'sale')
                ->where('invoice_status', '=', 'valid')
                ->first();

                if($existing_invoice){
                    return redirect()->route('existing_invoice', $existing_invoice->id_invoice);
                } else {
                    return back()->withErrors([
                        'message' => 'Order already invoiced but invoice not found. Please contact system administrator.',
                    ]);
                }
            }
            
            $business_id = $order->business_id;

            //get products in the order
            $order_products = OrderProducts::select('order_products.*', 
            'business_products.price', 'business_products.purchase_price', 'business_products.unit_type',
            'business_products.product_type', 'order_products.product_sale_tax_percentage AS product_sales_tax', 'business_products.track_inventory', 'business_products.product_image',            
            'order_products.staff_id', 'business_brands.business_brand_name', 'business_products.product',
            DB::RAW("order_products.staff_name as staff")
            )
            ->join('business_products', 'business_products.id_business_products', '=', 'order_products.product_id')
            ->join('business_brands', 'business_brands.id_business_brands', '=', 'business_products.brand_id')
            ->where('order_products.customer_order_id', "=", $order_id)
            ->where('order_products.order_product_status', "=", "Active")
            ->groupby('id_order_products')
            ->get();

            //get customer loyatly
            $customer = Customers::select('id_customers', 'customers.customer_name', 'customers.customer_cell', 'customers.customer_area', 
            DB::RAW('COALESCE(customers.customer_address, "") as customer_address'), 'customers.customer_email',
            DB::RAW('CASE WHEN sum(loyalty_earned) - sum(loyalty_used)  > 0 THEN round(sum(loyalty_earned) - sum(loyalty_used)) ELSE 0 END  as loyalty_points')
            )
            ->leftJoin('invoice', function($join){ 
                $join->on('invoice.customer_id', '=', 'customers.id_customers')
                ->where('invoice.invoice_status', '=', 'valid');
            })
            ->where('id_customers', '=', $order->customer_id)
            ->groupby('id_customers');
            $customer = $customer->first();
            
            $customer_order_advance = VisitAdvance::select(DB::raw('SUM(advance_amount) as advance_amount') ,
                DB::raw('DATE_FORMAT(advance_date, "%d-%m-%Y %H:%i") as advance_date')
                )
                ->where('customer_order_id', $order_id)
                ->where('advance_status', 'Active')
                ->groupBy('advance_date')
                ->orderBy('advance_date', 'asc')
                ->get();

        $categoriesData = DB::table('customer_order_categories_form_data')
                        ->select('category_name', 'form_jason')
                        ->where('customer_order_id', $order_id)
                        ->get();
    
        $categoriesDataFormattedData = []; 
        foreach ($categoriesData as $data) {
            $decodedData = json_decode($data->form_jason, true);
            
            $category = [
                'category_name' => $data->category_name,
                'sections' => []
            ];
            if (isset($decodedData['sections'])) {
                foreach ($decodedData['sections'] as $section) {
                    $category['sections'][] = [
                        'title' => $section['title'],
                        'fields' => $section['fields']
                    ];
                }
            }
            $categoriesDataFormattedData[] = $category;
        }

        return view('customer_order.customer_order_print', compact('invoice', 'business', 'checkquery','order', 'order_products', 'customer','customer_order_advance','categoriesDataFormattedData'));
    }

}
