<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business; // Assuming you have a Business model
use App\Services\MenuService;

use Illuminate\Support\Facades\Auth;
use App\Models\User; // Assuming you have a User model

class LoginController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function welcome(Request $request)
    {
        $business = Business::where('id_business', session('business_id'))->first();
        if ($business) {
            session(['ho_accounts' => $business->ho_accounts]);      
            session(['ho' => $business->ho]);      
            session(['business_name' => $business->business_name]);
            session(['common_services' => $business->common_services]);
            session(['common_products' => $business->common_products]);
            session(['ho_accounts' => $business->ho_accounts]);
        } else {
            // Business does not exist, handle the error
            return redirect()->route('error.400');
        }

        $userRole = session('user_role');
        // dd($userRole);
        if($userRole == 'Super Admin' || $userRole == 'Super User') {
            return redirect()->route('business.branches'); // Redirect to branch dashboard
        } elseif ($userRole == 'Admin') {
            return redirect()->route('home'); // Redirect to dashboard
        } elseif ($userRole == 'Reception') {
            return redirect()->route('scheduler'); // Redirect to scheduler route
        } elseif (session('user_role') == 'Accountant') {
            return redirect()->route('accounts.open_account_vouchers'); // Redirect to scheduler route
        }
        elseif (session('user_role') == 'Store Manager') {
            return redirect()->route('brands'); // Redirect to scheduler route
        }elseif (strtolower(session('user_role')) == 'pos') {
            return redirect()->route('restaurant.pos'); // Redirect to pos route
        }
        elseif (session('user_role') == 'Store Operator') {
            return redirect()->route('brands'); // Redirect to scheduler route
        } else {
            // Fallback: Show welcome page for unmatched roles
            $menuService = app(MenuService::class);
            $menus = $menuService->getMenus([
                'is_active' => true
            ]);
            
            return view('welcome', [
                'menus' => $menus
            ]);
        }
    }

    public function logout(Request $request)
     {
          redirect('auth/logout');
     }

}


