<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Menu;
use App\Services\MenuService;
use App\Models\Permission;

class MenuController extends Controller
{
    protected $menuService;

    public function __construct(MenuService $MenuService)
    {
        $this->menuService = $MenuService;
    }


    public function index()
    {
        $all_menus = $this->menuService->getMenus();
        $permissions = Permission::all();

        return view('menu.menu_management', compact('all_menus', 'permissions'));
    }

    public function store(Request $request)
    {
        $parent_id = $request->input('parent_id', '');
        return $this->menuService->createMenu($request, $parent_id);
    }

    public function update(Request $request, $id)
    {
        return $this->menuService->updateMenu($request, $id);
    }

    public function updateMenuStatus(Request $request, $id)
    {
        return $this->menuService->updateMenuStatus($request, $id);
    }

    public function updateOrder(Request $request)
    {
        foreach($request->menus as $menu) {
            Menu::where('id', $menu['id'])->update([
                'sort_order' => $menu['sort_order'],
                'parent_id' => $menu['parent_id'],
            ]);
        }
        return response()->json(['status' => 'success']);
    }
}
