<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\LoginLog;

class RoutingController extends Controller
{
    public function index(Request $request)
    {
        if (Auth::user()) {
            return redirect('welcome');
        } else {    
            // If user is not authenticated, redirect to login       
            if(!$request->is('/') || !$request->is('login') || !$request->is('forgot-password') || !$request->is('register')) {
                return redirect('login');
            } else {
                return view($request->path());
            }
        }
    }

    /**
     * Display a view based on first route param
     *
     * @return \Illuminate\Http\Response
     */
    public function root(Request $request, $first)
    {
       // return $request->path();

       if($request->path() == 'logout') {
            $sessionId = $request->session()->getId(); // current session id
    
            // Update logout time in login log before logging out
            if (Auth::check()) {
                LoginLog::where('session_id', $sessionId)
                    ->whereNull('logout_time')
                    ->update(['logout_time' => now()]);
            }

            Auth::guard('web')->logout();
            //print_r($sessionId); exit();
            // Delete current session from DB
            DB::table('sessions')->where('id', $sessionId)->delete();

            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return view('auth.logout');
        }

        if ($first == "assets")
            return redirect('home');

        return view($first);
    }

    /**
     * second level route
     */
    public function secondLevel(Request $request, $first, $second)
    {
       

        if ($first == "assets")
            return redirect('home');

        return view($first . '.' . $second);
    }

    /**
     * third level route
     */
    public function thirdLevel(Request $request, $first, $second, $third)
    {
        
        if ($first == "assets")
            return redirect('home');
        
        return view($first . '.' . $second . '.' . $third);
    }
}
