<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Department;

class ServiceDepartmentController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function service_departments(Request $request)
    {
        // Business scoping:
        // - Normally departments are tied to the current business (implicit on UI)
        // - If common_services is enabled, treat departments as "common" and use HO business_id
        $business_id = session('business_id');
        if (session('common_services') == "Yes") {
            $ho_business = DB::table('business')->where('ho', 'Yes')->first();
            $business_id = $ho_business->id_business ?? session('business_id');
        }

        $departments = Department::where('business_id', $business_id)
            ->orderBy('id_service_department', 'ASC')
            ->get();

        return view('service_department.service_departments_listing', compact('departments', 'business_id'));
    }

    public function save_or_update(Request $request)
    {
        try {
            $request->validate([
                'service_department' => 'required|string|max:255',
                'department_status' => 'required|in:Active,InActive',
                'id_service_department' => 'nullable|integer',
            ]);

            $id = $request->input('id_service_department');

            $business_id = session('business_id');
            if (session('common_services') == "Yes") {
                $ho_business = DB::table('business')->where('ho', 'Yes')->first();
                $business_id = $ho_business->id_business ?? session('business_id');
            }

            $department = Department::updateOrCreate(
                ['id_service_department' => $id],
                [
                    'service_department' => $request->input('service_department'),
                    'department_status' => $request->input('department_status'),
                    'business_id' => $business_id,
                ]
            );

            return response()->json([
                'success' => true,
                'message' => 'Service department saved successfully',
                'department' => $department,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ], 500);
        }
    }
}
