<?php

namespace App\Http\Controllers\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class AdvancedSettingsController extends Controller
{
    /**
     * Display the Advanced settings page.
     */
    public function index()
    {
        return view('settings.advanced');
    }

    /**
     * Run the PermissionSystemSeeder.
     */
    public function runSeeder(Request $request)
    {
        try {
            // Run the PermissionSystemSeeder
            Artisan::call('db:seed', [
                '--class' => 'PermissionSystemSeeder',
                '--force' => true
            ]);

            $output = Artisan::output();

            return response()->json([
                'success' => true,
                'message' => 'PermissionSystemSeeder has been executed successfully. All roles, menus, and permissions have been reset to their default values.',
                'output' => $output
            ]);
        } catch (\Exception $e) {
            Log::error('Error running PermissionSystemSeeder: ' . $e->getMessage(), [
                'exception' => $e,
                'trace' => $e->getTraceAsString()
            ]);

            return response()->json([
                'success' => false,
                'message' => 'An error occurred while running the seeder: ' . $e->getMessage()
            ], 500);
        }
    }
}
