<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use App\Models\Business;
use App\Models\AccountHeads;
use App\Models\Stores;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Log;

class StoreController extends Controller
{
    public function stores(Request $request){
        
        if (session('ho') == 'Yes') {
            $businesses = Business::where('common_products', 'Yes')->get();
        } else{
            $businesses = Business::where('id_business', session('business_id'))->get();
        }

        $business_id = $request->input('business_id');
        if($business_id > 0) {
            $business_id = $request->input('business_id');
        }else{
            $business_id = 0; 
        }    

        $stores = Stores::select('business_stores.*','account_heads.account_head','account_heads.account_head_number','account_heads.id_account_heads','business.business_name')
        ->join('business','business.id_business', '=', 'business_stores.business_id')
        ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'business_stores.account_head_id');
        if($business_id > 0){
          $stores->where('business_stores.business_id', $business_id);
        }else if(session('ho') == 'Yes'){
          $stores->whereIn('business_stores.business_id', function ($query) {
                $query->select('id_business')->from('business')->where('common_products','Yes');
            });
        }else{
         $stores->where('business_stores.business_id', session('business_id'));
        }
        $stores = $stores->get();
        $accounts_inventory = $this->get_event_account(20, 'inventory'); 
        $account_head ='';
        if($accounts_inventory){
            $account_head = $accounts_inventory->account_head;
        }

        $cities = DB::table('cities')->select('city')->distinct();
        if ($business_id > 0) {
            $cities->where('business_id', $business_id);
        } else if (session('ho') == 'Yes') {
            $cities->whereIn('business_id', function ($query) {
                $query->select('id_business')->from('business')->where('common_products', 'Yes');
            });
        } else {
            $cities->where('business_id', session('business_id'));
        }

        $cities = $cities->get();
        return view('stores.store', compact('businesses', 'business_id', 'stores','account_head','cities'));
    }

    public function save_stores(Request $request)
    {
        DB::beginTransaction();
        try {
            $id_business_stores = $request->input('id_business_stores');
            if (!$id_business_stores) {
                $data = $request->only([
                    'business_store',
                    'store_manager',
                    'store_cell',
                    'store_phone1',
                    'store_city',
                    'store_address',
                    'business_id'
                ]);
                $data['created_by'] = session('user_name');

                $stores = Stores::create($data);
                if ($stores) {
                    if ($request->input('create_account_head') == 1) {
                        $result = $this->createAccountHeadForStore($stores->business_store, $stores->business_id);

                        if (!$result['success']) {
                            DB::rollBack(); 
                            return response()->json([
                                'message' => $result['message'],
                                'message_type' => $result['message_type'],
                                'success' => $result['success'],
                                'message_btn' => $result['message_btn']
                            ]);
                        } else {
                            $stores->update([
                                'account_head_id' => $result['account_head']->id_account_heads
                            ]);
                        }
                    }

                    DB::commit();
                    return response()->json([
                        'success' => true,
                        'message_type' => 'success',
                        'message' => 'Store added successfully',
                        'message_btn' => 'btn btn-success',
                        'data' => $stores
                    ]);
                } else {
                    DB::rollBack();
                    return response()->json([
                        'message' => 'Store could not be created',
                        'message_type' => 'error',
                        'success' => false,
                        'message_btn' => 'btn btn-danger'
                    ]);
                }

            } else {
               
                $stores = Stores::find($id_business_stores);

                if ($stores) {
                    $stores->update($request->only([
                        'business_store',
                        'store_manager',
                        'store_cell',
                        'store_phone1',
                        'store_city',
                        'store_address'
                    ]));

                    DB::commit();
                    return response()->json([
                        'success' => true,
                        'message_type' => 'success',
                        'message' => 'Store updated successfully',
                        'message_btn' => 'btn btn-success',
                        'data' => $stores
                    ]);
                } else {
                    DB::rollBack();
                    return response()->json([
                        'message' => 'Store not found',
                        'message_type' => 'error',
                        'success' => false,
                        'message_btn' => 'btn btn-danger'
                    ]);
                }
            }

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => 'An error occurred: ' . $e->getMessage(),
                'message_type' => 'error',
                'success' => false,
                'message_btn' => 'btn btn-danger'
            ]);
        }
    }

    function get_event_account($eventid, $entity_name, $business_id = 0)
    {
        if (empty($business_id) || $business_id == 0) {
            if (session('ho_accounts') === 'Yes') {
                $business_id = Business::where('ho', 'Yes')->value('id_business');
            } else {
                $business_id = session('business_id');
            }
        }
        return DB::table('account_event_mapping')
            ->join('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
            ->select('account_head_id', 'account_head')
            ->where('account_event_id', $eventid)
            ->where('entity_name', $entity_name)
            ->where('account_event_mapping.business_id', $business_id)
            ->first();
   }

    public function createAccountHeadForStore($account_head_name, $business_id) { 
        try {
            $business = Business::select('id_business', 'ho_accounts')
                                ->where('id_business', $business_id)
                                ->first();
            if (!$business) {
                return [
                    'message' => 'Business not found',
                    'message_type' => 'error',
                    "message_btn" => "btn btn-danger",
                    "success" => false,
                ];
            }
            if ($business->ho_accounts === "Yes") {
                $business_id = Business::where('ho', 'Yes')->value('id_business');
            } else {
                $business_id = $business->id_business;
            }

            $eventid = 20;
            $entity_name = "inventory";

            $account_event_mapping = DB::table('account_event_mapping')
                                        ->join('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
                                        ->select('account_head_id', 'account_head', 'account_sub_control_id')
                                        ->where('account_event_id', $eventid)
                                        ->where('entity_name', $entity_name)
                                        ->where('account_event_mapping.business_id', $business_id)
                                        ->first();

            if (!$account_event_mapping) {
                return [
                    'message' => 'Event mapping not found',
                    'message_type' => 'error',
                    "message_btn" => "btn btn-danger",
                    "success" => false,
                ];
            }                        

            $account_head = new AccountHeads();            
            $account_head->account_head = $account_head_name.' Inventory';
            $account_head->account_head_number = null;
            $account_head->account_head_status = "Active";
            $account_head->account_sub_control_id = $account_event_mapping->account_sub_control_id;
            $account_head->business_id = $business_id;
            $account_head->save();

            // Update account_head_number with its own ID
            $account_head->account_head_number = $account_head->id_account_heads;
            $account_head->save();

            return [
                'message' => 'Account head created successfully.',
                'message_type' => 'success',
                "message_btn" => "btn btn-success",
                'account_head' => $account_head,
                "success" => true,
            ];

        } catch (\Exception $e) {
            return [
                'message' => 'Error creating account head: ' . $e->getMessage(),
                'message_type' => 'error',
                "message_btn" => "btn btn-danger",
                "success" => false,
            ];
        }
    }

}
