<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\Business;
use App\Models\Supplier;
use App\Models\AccountHeads;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Log; 

class SupplierController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;
    public function supplier_search(Request $request)
    {
        $business_id = $request->input('business.id');
        $search_term = $request->input('term');

        $suppliers = Supplier::select('id_business_supplier as id', 
        'business.business_name', 
        'business_supplier.business_id', 
        'business_supplier.supplier_name as text',         
        'business_supplier.supplier_name as supplier_name',         
        'business_supplier.contact_person as contact_person ', 
        'business_supplier.email as email', 
        'business_supplier.contact_number as supplier_cell',
        DB::raw('"Yes" as supplier_active')
        )
        ->join('business', 'business.id_business', '=', 'business_supplier.business_id')
        ->where(function ($query) use ($search_term) {
            $query->where('business_supplier.supplier_name', 'LIKE', '%' . $search_term . '%')
                  ->orWhere('business_supplier.contact_person', 'LIKE', '%' . $search_term . '%')
                  ->orWhere('business_supplier.email', 'LIKE', '%' . $search_term . '%')
                  ->orWhere('business_supplier.contact_number', 'LIKE', '%' . $search_term . '%')
                  ->orWhere('business_supplier.office_phone1', 'LIKE', '%' . $search_term . '%')
                  ->orWhere('business_supplier.office_phone2', 'LIKE', '%' . $search_term . '%')
                  ->orWhere('business_supplier.website', 'LIKE', '%' . $search_term . '%')
                  ;
            });

         // Apply business filter
            if ($business_id != 0) {
                $suppliers->where('business_id', $business_id);
            } else {
                $suppliers->whereIn('business_id', function ($query) {
                    $query->select('id_business')
                        ->from('business')
                        ->where('common_products', 'Yes');
                });
            }

        $suppliers = $suppliers->get();
        return response()->json($suppliers);
    }

    public function suppliers(){
        if(session('common_products') == 'Yes'){
            $branches = Business::where('common_products', 'Yes')->get();
        } else {
            $branches = Business::where('id_business', session('business_id'))->get();
        }

        $business_id = session('business_id');
        $suppliers = Supplier::select('business_supplier.*','account_heads.account_head','account_heads.account_head_number','account_heads.id_account_heads','business.business_name')
        ->join('business','business.id_business', '=', 'business_supplier.business_id')
        ->leftJoin('account_heads', 'account_heads.id_account_heads', '=', 'business_supplier.account_head_id');
        if(session('common_products') == 'Yes'){
            $suppliers->whereIn('business_supplier.business_id', function ($query) {
                $query->select('id_business')
                    ->from('business')
                    ->where('common_products', 'Yes');
            });
        } else {
            $suppliers->where('business_supplier.business_id', $business_id);
        }
        $suppliers = $suppliers->get();
        $accounts_payable = $this->get_event_account(20, 'payables');
        $account_head ='';
        if($accounts_payable){
           $account_head = $accounts_payable->account_head;
        }
        return view('suppliers.suppliers', compact('branches', 'business_id', 'suppliers','account_head'));
    }

    public function supplier_details(Request $request)
    {
        $supplier_id = $request->input('supplier_id');

        $supplier = Supplier::where('id_business_supplier', $supplier_id)->first();

        if ($supplier) {
            return response()->json([
                'success' => true,
                'message_type' => 'Success',
                'message' => 'Supplier details retrieved successfully',
                'message_btn' => 'btn btn-success',
                'data' => $supplier
            ]);
        } else {
            return response()->json([
                'message' => 'Supplier not found',
                'message_type' => 'Error',
                'success' => false,
                'message_btn' => 'btn btn-danger'
            ]);
        }
    }

    public function save_supplier(Request $request)
    {
        try{
            DB::beginTransaction();
            $id_business_supplier = $request->input('id_business_supplier');
            if(!$id_business_supplier){
                //Create new supplier
                $data = $request->only([
                    'supplier_name',
                    'contact_person',
                    'contact_number',
                    'office_phone1',
                    'office_phone2',
                    'website',
                    'ho_address',
                    'email',
                    'business_id'
                ]);
                $supplier = Supplier::create($data); 
                if($supplier){
                    if ($request->input('create_account_head') == 1) {
                        $result = $this->createAccountHeadForSupplier($supplier->supplier_name, $supplier->business_id);
                        if (!$result['success']) {
                                DB::rollBack(); 
                                return response()->json([
                                    'message' => $result['message'],
                                    'message_type' => $result['message_type'],
                                    'success' => $result['success'],
                                    'message_btn' => $result['message_btn']
                                ]);
                            } else {
                                $supplier->update([
                                    'account_head_id' => $result['account_head']->id_account_heads
                                ]);
                            }
                    }
                     DB::commit();
                    return response()->json([
                        'success' => true,
                        'message_type' => 'success',
                        'message' => 'Supplier added successfully',
                        'message_btn' => 'btn btn-success',
                        'data' => $supplier
                    ]);

                }else{
                    DB::rollBack();
                    return response()->json([
                            'message' => 'Supplier could not be created',
                            'message_type' => 'error',
                            'success' => false,
                            'message_btn' => 'btn btn-danger'
                    ]);
                }    

            } else {
                $supplier = Supplier::find($id_business_supplier);
                if ($supplier) {
                    // Update existing supplier
                    $supplier->supplier_name = $request->input('supplier_name');
                    $supplier->contact_person = $request->input('contact_person');
                    $supplier->contact_number = $request->input('contact_number');
                    $supplier->office_phone1 = $request->input('office_phone1');
                    $supplier->office_phone2 = $request->input('office_phone2');
                    $supplier->website = $request->input('website');
                    $supplier->ho_address = $request->input('ho_address');
                    $supplier->email = $request->input('email');
                    $supplier->save();
                     DB::commit();
                    return response()->json([
                        'success' => true,
                        'message_type' => 'success',
                        'message' => 'Supplier updated successfully',
                        'message_btn' => 'btn btn-success',
                        'data' => $supplier
                    ]);
                } else {
                    DB::rollBack();
                    return response()->json([
                        'message' => 'Supplier not found',
                        'message_type' => 'error',
                        'success' => false,
                        'message_btn' => 'btn btn-danger'
                    ]);
                }
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => 'An error occurred: ' . $e->getMessage(),
                'message_type' => 'error',
                'success' => false,
                'message_btn' => 'btn btn-danger'
            ]);
        }
    } 


      public function createAccountHeadForSupplier($account_head_name, $business_id) { 
            try {
                $business = Business::select('id_business', 'ho_accounts')
                                    ->where('id_business', $business_id)
                                    ->first();
                if (!$business) {
                    return [
                        'message' => 'Business not found',
                        'message_type' => 'error',
                        "message_btn" => "btn btn-danger",
                        "success" => false,
                    ];
                }
                if ($business->ho_accounts === "Yes") {
                    $business_id = Business::where('ho', 'Yes')->value('id_business');
                } else {
                    $business_id = $business->id_business;
                }

                $eventid = 20;
                $entity_name = "payables";

                $account_event_mapping = DB::table('account_event_mapping')
                                            ->join('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
                                            ->select('account_head_id', 'account_head', 'account_sub_control_id')
                                            ->where('account_event_id', $eventid)
                                            ->where('entity_name', $entity_name)
                                            ->where('account_event_mapping.business_id', $business_id)
                                            ->first();

                if (!$account_event_mapping) {
                    return [
                        'message' => 'Event mapping not found',
                        'message_type' => 'error',
                        "message_btn" => "btn btn-danger",
                        "success" => false,
                    ];
                }                        

                $account_head = new AccountHeads();            
                $account_head->account_head = $account_head_name.' Payable';
                $account_head->account_head_number = null;
                $account_head->account_head_status = "Active";
                $account_head->account_sub_control_id = $account_event_mapping->account_sub_control_id;
                $account_head->business_id = $business_id;
                $account_head->save();

                // Update account_head_number with its own ID
                $account_head->account_head_number = $account_head->id_account_heads;
                $account_head->save();

                return [
                    'message' => 'Account head created successfully.',
                    'message_type' => 'success',
                    "message_btn" => "btn btn-success",
                    'account_head' => $account_head,
                    "success" => true,
                ];

            } catch (\Exception $e) {
                return [
                    'message' => 'Error creating account head: ' . $e->getMessage(),
                    'message_type' => 'error',
                    "message_btn" => "btn btn-danger",
                    "success" => false,
                ];
            }
    }
    
    function get_event_account($eventid, $entity_name, $business_id = 0)
    {
        // Determine business_id
        if (empty($business_id) || $business_id == 0) {
            if (session('ho_accounts') === 'Yes') {
                $business_id = Business::where('ho', 'Yes')->value('id_business');
            } else {
                $business_id = session('business_id');
            }
        }

        return DB::table('account_event_mapping')
            ->join('account_heads', 'account_heads.id_account_heads', '=', 'account_event_mapping.account_head_id')
            ->select('account_head_id', 'account_head')
            ->where('account_event_id', $eventid)
            ->where('entity_name', $entity_name)
            ->where('account_event_mapping.business_id', $business_id)
            ->first();
    }

}