<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Bus;

class UserController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function index(Request $request)
    {
       
       $user = User::where('id_users', session('user_id'))
        ->with(['roles']) // assuming relationships are defined
        ->first();

        $teammembers = User::with(['roles'])            
            ->where('id_users', '!=', session('user_id'))
            ->where('business_id', $user->business_id)
            ->where('user_status', 'Active')
            ->where('user_hidden', 'No')
            ->whereRAW('upper(user_name) not like ?', '%MEXYON%')
            ->get();

        //print_r(compact('teammembers')); exit();
       // echo  $user->roles->pluck('role_name')->first(); exit();

        return view('contacts.profile', compact('user', 'teammembers'));
    }

    // public function ajax_user(Request $request)
    // {
    //     $user = User::where('id_users', $request->input('id_users'))
    //     ->with('role')->first();

    //     echo json_encode($user);
    //     exit;
    // }

}


