<?php

namespace App\Http\Controllers;


use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class UtilityController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function clearLaravelCache()
    {
        try {
            // Check cache driver
            $cacheDriver = config('cache.default');

            // If cache driver is database, ensure table exists
            if ($cacheDriver === 'database' && !Schema::hasTable('cache')) {
                // Log a warning (optional)
                Log::warning('Cache table missing — switching to file cache for this operation.');

                // Temporarily switch to file cache
                config(['cache.default' => 'file']);
            }

            // Run standard clear commands
            Artisan::call('cache:clear');
            Artisan::call('config:clear');
            Artisan::call('route:clear');
            Artisan::call('view:clear');

            return redirect()->back()->with('success', 'Laravel cache cleared successfully.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Error clearing cache: ' . $e->getMessage());
        }
    }
}
    