<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Bus;
use App\Models\CustomerVisits;
use App\Models\VisitServices;
use App\Models\VisitServiceStaff;
use App\Models\VisitAdvance;
use App\Models\Staff;
use App\Models\Discount;
use App\Models\Invoice;
use App\Models\Business;
use App\Models\Customers;
use App\Models\AccountVouchers;
use App\Models\AccountVoucherDetail;
use App\Models\AccountEventMapping;
use App\Models\InvoiceDetails;
use App\Models\InvoiceStaff;
use App\Models\Services;
use App\Models\ServiceType;
use App\Models\ServiceCategory;
use App\Models\PackageType;
use App\Models\PackageCategory;
use App\Models\PackageServices;
use App\Models\Booking;
use App\Models\BookingVisit;

use App\Services\dispatchRequestService;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
            

class VisitsController extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function customer_visits(Request $request)
    {

        // handle date        
        $start_date = $request->start_date ?? date('Y-m-d');            
        $visit_status = $request->visit_status ?? 'open';            

        $businss = $business = DB::table('business')
            ->where('id_business', session('business_id'))
            ->first();

        //Get Business Taxes
        $business_taxes = DB::table('business_taxes')
            ->select(
                'business.cc_charge',
                DB::raw('
                    SUM(CASE WHEN tax_payment_mode = "Cash"   AND tax_invoice_type = "service" THEN tax_percentage ELSE 0 END) AS tax_percentage_cash_service,
                    SUM(CASE WHEN tax_payment_mode = "Card"   AND tax_invoice_type = "service" THEN tax_percentage ELSE 0 END) AS tax_percentage_card_service,
                    SUM(CASE WHEN tax_payment_mode = "Online" AND tax_invoice_type = "service" THEN tax_percentage ELSE 0 END) AS tax_percentage_online_service,
                    SUM(CASE WHEN tax_payment_mode = "Check"  AND tax_invoice_type = "service" THEN tax_percentage ELSE 0 END) AS tax_percentage_check_service,
                    SUM(CASE WHEN tax_payment_mode = "Voucher"AND tax_invoice_type = "service" THEN tax_percentage ELSE 0 END) AS tax_percentage_voucher_service,

                    SUM(CASE WHEN tax_payment_mode = "Cash"   AND tax_invoice_type = "sale" THEN tax_percentage ELSE 0 END) AS tax_percentage_cash_sale,
                    SUM(CASE WHEN tax_payment_mode = "Card"   AND tax_invoice_type = "sale" THEN tax_percentage ELSE 0 END) AS tax_percentage_card_sale,
                    SUM(CASE WHEN tax_payment_mode = "Online" AND tax_invoice_type = "sale" THEN tax_percentage ELSE 0 END) AS tax_percentage_online_sale,
                    SUM(CASE WHEN tax_payment_mode = "Check"  AND tax_invoice_type = "sale" THEN tax_percentage ELSE 0 END) AS tax_percentage_check_sale,
                    SUM(CASE WHEN tax_payment_mode = "Voucher"AND tax_invoice_type = "sale" THEN tax_percentage ELSE 0 END) AS tax_percentage_voucher_sale
                ')
            )
            ->join('business', 'business_taxes.business_id', '=', 'business.id_business');

        if (session('common_products') == "Yes") {
            $business_taxes = $business_taxes->where('business.ho', 'Yes');
        } else {
            $business_taxes = $business_taxes->where('business_id', session('business_id'));
        }

        $business_taxes = $business_taxes
            ->where('tax_active', 'Y')
            ->groupBy('business.id_business')
            ->first();

        return view('visits.customer_visits', compact('start_date', 'visit_status', 'business', 'business_taxes'));

    }

    public function visitsdata(Request $request)
    {
        // print_r(empty($request->start_date)); exit();
        $baseQuery = CustomerVisits::select(
            'customer_visits.*', 'business.business_name',
            'customers.customer_cell',
            'customers.customer_name', 
            'visit_services.service_flag',
            'visit_services.visit_service_start',
            DB::raw('group_concat(visit_services.s_rate ORDER BY id_visit_services SEPARATOR "<br>") as s_rate'),
            DB::raw('group_concat(distinct(visit_services.s_type) ORDER BY id_visit_services SEPARATOR "<br>") as s_type'), 
            DB::raw('group_concat(distinct(visit_services.s_category) ORDER BY id_visit_services SEPARATOR "<br>") as s_category'), 
            DB::raw('group_concat(distinct(visit_services.service_name) ORDER BY id_visit_services SEPARATOR "<br>") as services'),
            DB::raw('group_concat(distinct(visit_service_staffs.staff_name) ORDER BY visit_service_id SEPARATOR "<br>") as staff'),
            DB::raw('DATE_FORMAT(customer_visit_date, "%h:%i") as visit_time'),
            DB::raw('DATE_FORMAT(customer_visits.created_on, "%d-%m-%Y") as visit_created_on'),
            
            DB::raw('DATE_FORMAT(visit_services.visit_service_start, "%d-%m-%Y %H:%i") as visit_service_start_formatted'),
            DB::raw('COALESCE(advances.total_advance, 0) as advance')
        )
        ->join('business', 'business.id_business', '=', 'customer_visits.business_id')
        ->leftJoin('customers', 'customers.id_customers', '=', 'customer_visits.customer_id')
        ->leftJoin(DB::raw('(SELECT customer_visit_id, SUM(advance_amount) as total_advance 
                            FROM visit_advance 
                            where visit_advance.advance_status = "Active"
                            GROUP BY customer_visit_id) advances'),
                'advances.customer_visit_id', '=', 'customer_visits.id_customer_visits')
        ->leftJoin('visit_services', function ($join) {
            $join->on('customer_visits.id_customer_visits', '=', 'visit_services.customer_visit_id')
                ->where('visit_services.visit_service_status', 'Active');
        })
        ->leftJoin('visit_service_staffs', function ($join) {
            $join->on('visit_services.id_visit_services', '=', 'visit_service_staffs.visit_service_id')
                ->where('visit_service_staffs.visit_service_staff_status', 'Active');
        })
        
        ->groupBy('id_customer_visits');

        // ----Role based Filters ---
        if(session('user_role') != 'Admin' && session('user_role') != 'Super User'){
            $baseQuery->where('customer_visits.business_id', '=', session('business_id'));
        } else {            
            $baseQuery->where('business.common_services', '=', "Yes");
        }

        // --- filters ---
        if (empty($request->start_date)) {
            $today = $request->start_date ?? date('Y-m-d');
            $baseQuery->whereDate('visit_service_start', '>=', $today);
        } else {
            $today = $request->start_date;
            $baseQuery->whereDate('visit_service_start', '>=', $today);
        }

        if (empty($request->visit_status)) {            
            $baseQuery->where('customer_visits.visit_status', '=', 'open');
        } elseif ($request->visit_status=='open') {            
            $baseQuery->where('customer_visits.visit_status', '=', 'open');
        }elseif($request->visit_status=='invoiced') {
            $baseQuery->where('customer_visits.visit_status', '=', 'invoiced');
        } else {
            $baseQuery->whereNotIn('customer_visits.visit_status', ['open', 'invoiced']);
        }



        $baseQuery->when($request->filled('customer_id'), fn($q) =>
            $q->where('business.common_service', "Yes")
        );

        // $s = $baseQuery->toSql();
        // $bindings = $baseQuery->getBindings();
        // dd($s, $bindings); exit(); 
        
        //$visits = $baseQuery->get(); 
        
        // print_r($visits);
        // exit();

        // --- searching ---
        if (!empty($request->search['value'])) {
            $search = $request->search['value'];
            $baseQuery->where(function ($q) use ($search) {
                $q->where('id_customer_visits', 'like', "%{$search}%")
                ->orWhere('customer_name', 'like', "%{$search}%")
                ->orWhere('customer_cell', 'like', "%{$search}%")
                ->orWhere('service_flag', 'like', "%{$search}%")
                ->orWhere('service_name', 'like', "%{$search}%")
                ->orWhere('staff_name', 'like', "%{$search}%")
                ->orWhere('visit_status', 'like', "%{$search}%")
                ->orWhere('visit_extra', 'like', "%{$search}%")
                ;
            });
        }

        
        // --- ordering ---
        if ($request->has('order')) {
            $columns = $request->columns;
            foreach ($request->order as $order) {
                $colIndex = $order['column'];
                $colName  = $columns[$colIndex]['name'];
                $dir      = $order['dir'];
                $baseQuery->orderBy($colName, $dir);
            }
        } else {
             $baseQuery->orderBy('visit_services.visit_service_start', 'asc');
         }

        // --- pagination ---
        // Clone the query BEFORE skip/take
        $countQuery = clone $baseQuery;

        // recordsFiltered = count of filtered rows (with groupBy handled)
        $recordsFiltered = $countQuery->get()->count();

        // Now paginate only for data
        $start  = $request->start ?? 0;
        $length = $request->length ?? 10;

        if ($length != -1) {
            $baseQuery->skip($start)->take($length);
        }

        $visits = $baseQuery->get();

        // recordsTotal = total without filters
        $recordsTotal = CustomerVisits::count();

        return response()->json([
            "draw" => intval($request->draw),
            "recordsTotal" => $recordsFiltered,
            "recordsFiltered" => $recordsFiltered,
            "data" => $visits
        ]);
    }

    public function visitdetaildata(Request $request){
        if(empty($request->id_customer_visits) || $request->id_customer_visits <1){
            return response()->json([           
                "message" => "Visit ID Not Passed To API",            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }

        //Get Visit Details
        $visit = CustomerVisits::select('customer_visits.*', 'customer_visits.customer_id',
         'invoice.id_invoice', 'customers.customer_alert', 'customers.customer_allergies', 'customers.customer_name', 
        'customers.customer_cell', 'customers.customer_email', 'customers.customer_type', 'business.cc_charge', 
        'business.common_services', 'business.invoiced_drag')
        ->Join('customers', 'customers.id_customers', '=', 'customer_visits.customer_id')
        ->leftJoin('invoice', function ($join) {
             $join->on('invoice.visit_id', '=', 'customer_visits.id_customer_visits')
             ->where('invoice.invoice_status', '=', 'valid')
             ->where('invoice.invoice_type', '=', 'service');
            })
        ->Join('business', 'business.id_business', '=', 'customer_visits.business_id')
        ->where('id_customer_visits','=', $request->id_customer_visits)
        ->first();
            
        //Get Visit Services 
        $visit_services = VisitServices::select(
            '*',
            DB::RAW('CASE WHEN date(visit_service_start) > date(now()) THEN "future" ELSE "false" END as futurevisit'),
            DB::raw('date_format(visit_service_start, "%Y-%m-%d %H:%i:%s") as checkin'),
            DB::raw('date_format(visit_service_start, "%H:%i:%s") as service_start'),
            DB::raw('date_format(visit_service_end, "%H:%i:%s") as service_end')
            )
            ->where('customer_visit_id', $request->id_customer_visits)
            ->where('visit_service_status', 'Active')
            ->get();

        //Get Staff Doing the Services 
        $visit_service_staff = VisitServiceStaff::select('*')
            ->where('customer_visit_id', $request->id_customer_visits)
            ->where('visit_service_staff_status', 'Active')
            ->get()
            ->groupBy('visit_service_id'); // group staff by service id

        // Attach staff to each service
        $servicesWithStaff = $visit_services->map(function ($service) use ($visit_service_staff) {
            $service->staff = $visit_service_staff->get($service->id_visit_services, collect());
            return $service;
        });
        

        //Get the Advances Against This Visit
        $visit_advance = VisitAdvance::select('*',
        DB::RAW('date_format(advance_date, "%d-%m-%Y") as formatted_advance_date')
        )
        ->where('customer_visit_id', '=', $request->id_customer_visits)      
        ->where('advance_status', '=', 'Active')        
        ->get();


        //Get All Recovery Invoices that are still Valid
        $recoveries = Invoice::select('id_invoice', 'balance')
        ->where('is_recovery', '=', 'Yes')
        ->where('customer_id', '=', $visit->customer_id)
        ->where('invoice_status', '=', 'valid')
        ->get();


        ///Only Send Staff and Discount Reasons if not already loaded on DOM
        if($request->getstaff == "true"){
            $staff_list = Staff::select('id_staff', 'staff_fullname', 'staff_image')
            ->where('staff_scheduler','=', 'On')
            ->where('staff_active','=',  'Y');
            if($visit->common_services == 'Yes')
                $staff_list = $staff_list->where(function($q) {
                    $q->where('staff.business_id', session('business_id'))
                    ->orWhere('staff.staff_shared', 'Yes');
                });
            else {
                $staff_list = $staff_list->where('business_id', '=', session('business_id'));
            }            
            $staff_list = $staff_list->get();
        } else { $staff_list = []; }

        if($request->getdiscounts == "true"){
            $discounts_list = Discount::select('*')        
            ->where('discount_reasons.active','=','Yes')
            ->where('business_id', '=', session('business_id'))
            ->get();
        } else { $discounts_list = []; }

        
        return response()->json([           
            "visit" => $visit,            
            "servicesWithStaff" => $servicesWithStaff,
            "visitAdvance" => $visit_advance,  
            "recoveries" => $recoveries,  
            "staffList" => $staff_list,
            "discountList" => $discounts_list  
        ]);


    }

    public function update_visit(Request $request){

        /////----Control Variables---/////
        /*
            USE ONLY ONE OF THE FOLLOWING AT A TIME OR MULTIPLE IF THEY DO NOT CLASH OR UPDATE THE SAME FIELDS

            1- reassign_all_to_staff
            2- reassign_service_staff
            3- update_visit_service_date
            4- update_service_time
            5- update_strict_time
            6- update_sms_reminder
            7- update_email_reminder
            8- update_call_reminder
            9- add_visit_extra
            10- visit_color
            11- update_staff_req
            12- update_service_promo            
            13- update_service_crosssell
            14- remove_service
            15- duplicate_service
            16- discount
            17- remarks
            18- remove_advance
            19- add_advance
            20- mark_in_service
            21- replace_invoiced_staff
        */

        if(empty($request->id_customer_visits) || $request->id_customer_visits == null){
            return response()->json([           
                "message" => "Visit Service ID is Empty ",            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        } else {
            ///---update last updated date in visit_services table
            
            $currentDateTime = Carbon::now();
            VisitServices::where('customer_visit_id', $request->id_customer_visits)->update([
            'update_date' => $currentDateTime
            ]);
        
        }

        $id_customer_visits = $request->id_customer_visits;

        //verify status of the visit
        $visit_details = CustomerVisits::select('id_customer_visits', 'customer_id', 'visit_status')
        ->where("id_customer_visits","=",$id_customer_visits)
        ->first();

        $business = Business::select('id_business', 'invoiced_drag')
        ->where("id_business", "=", session('business_id'))
        ->first();

        if($visit_details->visit_status == "invoiced"){
            if($business->invoiced_drag == "No"){
                return response()->json([           
                    "message" => "You dont have rights to edit Invoiced Visits",            
                    "message_type" => "error",
                    "message_btn" => "danger"
                ]);
            }
        } elseif($visit_details->visit_status != "invoiced" && $visit_details->visit_status != "open"){
                return response()->json([           
                    "message" => "Cancelled Visits Cannot be Edited",            
                    "message_type" => "error",
                    "message_btn" => "danger"
                ]);
        }

        try {
            DB::beginTransaction();
            ///Insert New Visit_Service_Staff records and Update older records to InActive Status 
            if($request->reassign_all_to_staff != null){
                $id_staff = $request->reassign_all_to_staff;
                
                $staff_details = Staff::select('id_staff', 'staff_fullname', 'staff_shared', 'business_id')
                ->where('id_staff', $id_staff)
                ->first();

                $block_other="No";
                if($staff_details->staff_shared == 'Yes'){
                    $block_other = "Yes";
                }

                VisitServiceStaff::where('customer_visit_id', $id_customer_visits)  
                ->update(['visit_service_staff_status' => 'Cancelled']);

                $visit_services = VisitServices::select('id_visit_services', 'business_id')
                ->where('customer_visit_id', '=', $id_customer_visits)
                ->where('visit_service_status', '=', 'Active')
                ->get();

                foreach($visit_services as $visit_service){
                    $visitServiceStaff = VisitServiceStaff::updateOrCreate(
                        [
                            'customer_visit_id' => $id_customer_visits,
                            'visit_service_id'  => $visit_service->id_visit_services,
                            'staff_id' => $id_staff
                        ], 
                        [  
                            'customer_visit_id'         => $id_customer_visits, // include again
                            'visit_service_id'          => $visit_service->id_visit_services, // include again
                            'staff_id'                  => $id_staff, // include again                    
                            'staff_name'                => $staff_details->staff_fullname,
                            'visit_service_staff_status' => 'Active',      
                            'block_other'               => $block_other,
                            'business_id' => $visit_service->business_id
                        ]
                    );

                    //get visit_staff_id from VisitServiceStaff 
                    $visit_staff_id = $visitServiceStaff->id_visit_service_staffs;               

                    //if visit status is invoice update invoice staff table 
                    if($request->has('visit_status') && $request->visit_status == "invoiced"){
                        $invoice_details = InvoiceDetails::where('visit_service_id', '=', $visit_service->id_visit_services)->first();
                        $id_invoice_details = $invoice_details->id_invoice_details;
                        $invoice_id = $invoice_details->invoice_id;
                        if($id_invoice_details){
                            InvoiceStaff::updateOrCreate(
                                [
                                    'invoice_detail_id' => $id_invoice_details,
                                    'visit_staff_id'    => $visit_staff_id
                                ],
                                [
                                'invoice_detail_id' => $id_invoice_details,
                                'visit_staff_id'    => $visit_staff_id,
                                'business_id'       => $staff_details->business_id,
                                'invoice_id'        => $invoice_id,
                                'staff_id'          => $staff_details->id_staff, // include again  
                                'staff_name'        => $staff_details->staff_fullname,
                                'service_type'      => $invoice_details->service_type,
                                'service_category'  => $invoice_details->service_category,
                                'service_name'      => $invoice_details->service_name,
                                ]
                            );
                        }
                    }

                }
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Services Assigned to Staff ".$id_staff,            
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            ///Insert New Visit_Service_Staff records for specific service and Update older records to InActive Status
            if($request->staff_add != null){
                    //return $request->all();
                    VisitServiceStaff::where('customer_visit_id', $id_customer_visits)  
                    ->where('visit_service_id', '=', $request->id_visit_services)
                    ->update(['visit_service_staff_status' => 'Cancelled']);

                    $additional = 'No';
                    foreach($request->reassign_service_staff as $staff){

                       // return $request->id_visit_service_staff;
                       

                        $staff_details = Staff::select('id_staff', 'staff_fullname', 'staff_shared', 'business_id')
                        ->where('id_staff', '=', $staff)
                        ->first();
                    
                        $block_other="No";
                        if($staff_details->staff_shared == 'Yes'){
                            $block_other = "Yes";
                        }

                        $visitServiceStaff = VisitServiceStaff::updateOrCreate(
                            [
                                'customer_visit_id' => $id_customer_visits,
                                'visit_service_id'  => $request->id_visit_services,
                                'staff_id' => $staff
                            ], 
                            [  
                                'customer_visit_id'         => $id_customer_visits, // include again
                                'visit_service_id'          => $request->id_visit_services, // include again
                                'business_id'               => $staff_details->business_id,
                                'staff_id'                  => $staff_details->id_staff, // include again                    
                                'staff_name'                => $staff_details->staff_fullname,
                                'visit_service_staff_status' => 'Active',      
                                'block_other'               => $block_other,
                                'business_id' => $staff_details->business_id,
                                'additional_staff' => $additional
                            ]
                        );
                        //get visit_staff_id from VisitServiceStaff 
                        $visit_staff_id = $visitServiceStaff->id_visit_service_staffs; 

                        $additional="Yes";
                    }
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Staff Assigned to Service ",            
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if($request->reassign_service_staff != null && $request->staff_add == null){

            // return $request->reassign_service_staff;
                if(empty($request->reassign_service_staff)){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                    "message" => "Staff List is Empty ",            
                    "message_type" => "error",
                    "message_btn" => "danger"

                    ]);
                } 
                if(empty($request->id_visit_services)){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                    "message" => "Visit Service ID is Empty ",            
                    "message_type" => "error",
                    "message_btn" => "danger"
                    ]);
                }
                if(count($request->reassign_service_staff) < 1 || $request->reassign_service_staff[0] == "0"){
                    if($request->has('service_start_datetime') && $request->service_start_datetime != null){
                        $service_start = $request->service_start_datetime;
                        $service_end = $request->service_end_datetime;
                        VisitServices::where('id_visit_services', $request->id_visit_services)
                        ->update([
                            'visit_service_start' => $service_start,
                            'visit_service_end' => $service_end
                        ]);
                    } 
                    

                    DB::commit(); //Commit the transaction
                    return response()->json([                           
                        "message" => "Service Time Updated.",            
                        "message_type" => "success",
                        "message_btn" => "success"
                    ]);
                }

               
                foreach($request->reassign_service_staff as $staff){

                   // return $request->id_visit_service_staff;
                   

                    $staff_details = Staff::select('id_staff', 'staff_fullname', 'staff_shared', 'business_id')
                    ->where('id_staff', '=', $staff)
                    ->first();
                
                    $block_other="No";
                    if($staff_details->staff_shared == 'Yes'){
                        $block_other = "Yes";
                    }

                   $visitServiceStaff = VisitServiceStaff::where(
                        'id_visit_service_staffs',
                        $request->id_visit_service_staff
                    )->update([
                        'customer_visit_id'          => $id_customer_visits,
                        'visit_service_id'           => $request->id_visit_services,
                        'business_id'                => $staff_details->business_id,
                        'staff_id'                   => $staff_details->id_staff,
                        'staff_name'                 => $staff_details->staff_fullname,
                        'visit_service_staff_status' => 'Active',
                        'block_other'                => $block_other
                    ]);
                    //get visit_staff_id from VisitServiceStaff 
                    $visit_staff_id = $request->id_visit_service_staff; 

                    //get all visit_service_staffs for this service
                    $all_staffs = VisitServiceStaff::select('*')->where('visit_service_id', '=', $request->id_visit_services)
                    ->where('visit_service_staff_status', '=', 'Active')->orderBy('id_visit_service_staffs', 'asc');
                    $additional = 'No';
                    foreach($all_staffs->get() as $vs_staff){
                        //update additional staff field
                        VisitServiceStaff::where('id_visit_service_staffs', $vs_staff->id_visit_service_staffs)
                        ->update([
                            'additional_staff' => $additional
                        ]);
                        $additional = "Yes";
                    }
                }

                //if visit status is invoice update invoice staff table 
                if($request->has('visit_status') && $request->visit_status == "invoiced"){
                    //get visit_service_staff records for this visit
                    $visit_service_staffs = VisitServiceStaff::select('*')
                    ->where('visit_service_id', '=', $request->id_visit_services)
                    ->where('visit_service_staff_status', '=', 'Active')
                    ->get();

                    foreach($visit_service_staffs as $vs_staff){
                        $visit_staff_id = $vs_staff->id_visit_service_staffs; 
                        $staff_details = Staff::select('id_staff', 'staff_fullname', 'business_id')
                        ->where('id_staff', '=', $vs_staff->staff_id)
                        ->first();
                        
                        $affected = InvoiceStaff::where(
                                'visit_staff_id', $visit_staff_id
                            )->update([                                
                                
                                              
                                'staff_id'          => $vs_staff->staff_id,
                                'staff_name'        => $staff_details->staff_fullname,
                                
                            ]);

                    }
                }

                if($request->has('service_start_datetime') && $request->service_start_datetime != null){
                    $service_start = $request->service_start_datetime;
                    $service_end = $request->service_end_datetime;
                    VisitServices::where('id_visit_services', $request->id_visit_services)
                    ->update([
                        'visit_service_start' => $service_start,
                        'visit_service_end' => $service_end
                    ]);
                }                 

                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Staff Assigned to Service ",            
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if(null != $request->replace_invoiced_staff && $request->replace_invoiced_staff == "true"){

                $id_visit_service_staffs = $request->id_visit_service_staffs;               
                $id_staff_new = $request->staff_id;

                if($id_visit_service_staffs == null || $id_staff_new == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Required Data Not Sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

               
                //update staff_id and staff_name
                $staff_details = Staff::where('id_staff', $id_staff_new)->first();

                VisitServiceStaff::where('id_visit_service_staffs', $id_visit_service_staffs)
                ->update([
                    'staff_id' => $staff_details->id_staff,
                    'staff_name' => $staff_details->staff_fullname
                ]);

                //update invoice_staff table
                InvoiceStaff::where('visit_staff_id', $id_visit_service_staffs)
                ->update([
                    'staff_id' => $staff_details->id_staff,
                    'staff_name' => $staff_details->staff_fullname
                ]);

                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Invoiced Staff Replaced Successfully!",            
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if(null != $request->update_visit_service_date){


                $id_customer_visits = $request->id_customer_visits;

                if($id_customer_visits == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }
            
                $visit_service_date = $request->update_visit_service_date;

                VisitServices::where('customer_visit_id', $id_customer_visits)->update([
                    'visit_service_start' => DB::RAW("concat('".$visit_service_date."', substr(visit_service_start, position('T' IN visit_service_start), length(visit_service_start)))"),
                    'visit_service_end' => DB::RAW("concat('".$visit_service_date."', substr(visit_service_end, position('T' IN visit_service_end), length(visit_service_end)))"),
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Visit Check In Time Updated for Visit ID ".$id_customer_visits,            
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if(null != $request->update_service_time){

                $id_customer_visits = $request->id_customer_visits; 
                $id_visit_services = $request->id_visit_services;

                if ($id_visit_services == null) {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Service Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if ($request->visit_service_start == null) {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Service Start Time not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                } else {
                    $visit_service_start = $request->visit_service_start;
                }

                if ($request->visit_service_end == null) {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Service End Time not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                } else {
                    $visit_service_end = $request->visit_service_end;
                }
                //return $request->all();

                // --- Validation ---
                $start = Carbon::createFromFormat('H:i:s', $visit_service_start);
                $end   = Carbon::createFromFormat('H:i:s', $visit_service_end);

                if ($start >= $end) {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Start time cannot be greater than or equal to end time!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if ($start->diffInMinutes($end) < 15) {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Service must be at least 15 minutes long!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                // --- Update ---
                VisitServices::where('id_visit_services', $id_visit_services)->update([
                    'visit_service_start' => DB::raw("concat(substr(visit_service_start, 1, position('T' IN visit_service_start)), '$visit_service_start')"),
                    'visit_service_end'   => DB::raw("concat(substr(visit_service_end, 1, position('T' IN visit_service_end)), '$visit_service_end')")
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Visit Service Start and End Time Updated for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);


            }

            if($request->update_strict_time != null){

                $id_customer_visits = $request->id_customer_visits;

                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollBack(); //Rollback the Transaction
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $strictTime = $request->update_strict_time;

                CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                    'reminder_stricttime' => $strictTime
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Visit Start Time Change Restrictions Changed for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }

            if($request->update_sms_reminder != null){

                $id_customer_visits = $request->id_customer_visits;

                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollBack(); //Rollback the Transaction
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $smsReminder = $request->update_sms_reminder;

                CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                    'reminder_sms' => $smsReminder
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "SMS Reminder Status Changed for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }

            if($request->update_email_reminder != null){

                $id_customer_visits = $request->id_customer_visits;

                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $emailReminder = $request->update_email_reminder;

                CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                    'reminder_email' => $emailReminder
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Email Reminder Status Changed for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }

            if($request->update_call_reminder != null){

                $id_customer_visits = $request->id_customer_visits;

                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollBack();
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $callReminder = $request->update_call_reminder;

                CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                    'reminder_call' => $callReminder
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Email Reminder Status Changed for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }

            if($request->add_visit_extra != null){

                $id_customer_visits = $request->id_customer_visits;

                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollback();
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $visit_extra = $request->add_visit_extra;

                CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                    'visit_extra' => $visit_extra
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Extra Information Added to Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }

            if($request->visit_color != null){
                $id_customer_visits = $request->id_customer_visits;

                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollBack();
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $visit_color = $request->visit_color;

                CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                    'visit_color' => $visit_color
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Color Changed for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }

            if($request->update_visit_status != null){

                $id_customer_visits = $request->id_customer_visits;


                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollBack();
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $visit_status = $request->update_visit_status;
                $cancel_reason = $request->cancel_reason;

                if(null == $cancel_reason || empty($cancel_reason)){
                    DB::rollback();
                    return response()->json([           
                        "message" => "Visit Cannot be Cancelled without Providing a Valid Reason! for Visit ID ".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if($visit_status == "cancelled" || $visit_status == "cancelVisitKeepAdv" || $visit_status == "cancelVisitRetainAdv" || $visit_status == "cancelVisitReturnAdv"){

                    CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                        'visit_status' => $visit_status,
                        'cancelled_on' => date('Y-m-d H:i:s'),
                        'canceled_by' => session('user_name'),
                        'cancelreason' => $cancel_reason
                    ]);

                    //create appropriate account voucher for cancellations to handle advance amount
                    if($visit_status != "cancelled"){ //if cancelled with advance handling
                        $a = $this->handle_visit_cancellation_advance($id_customer_visits, $visit_status);
                        if($a != "success"){
                            DB::rollBack(); //Rollback the transaction
                            return response()->json([
                                "message" => $a, //return the error message
                                "message_type" => "error",
                                "message_btn" => "danger"
                            ]);
                        }

                    } else {
                        //if cancelled without advance handling, just mark all advances as cancelled
                        VisitAdvance::where('customer_visit_id', $id_customer_visits)
                        ->where('advance_status', 'Active')
                        ->update([
                            'advance_status' => 'Cancelled',
                            'cancelled_by' => session('user_name'),
                            'cancelled_on' => date('Y-m-d H:i:s')
                        ]);
                    }
                    DB::commit(); //Commit the transaction
                    return response()->json([           
                        "message" => "Visit ID ".$id_customer_visits." has been Cancelled!",
                        "message_type" => "success",
                        "message_btn" => "success"
                    ]);

                } else if($visit_status == "open" || $visit_status == "invoiced") {
                    CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                        'visit_status' => $visit_status                    
                    ]);
                    DB::commit(); //Commit the transaction
                    return response()->json([           
                        "message" => "Status Changed for Visit ID ".$id_customer_visits,
                        "message_type" => "success",
                        "message_btn" => "success"
                    ]);
                } 

            }

            if(null != $request->update_staff_req){
                if($request->id_visit_services == null || empty($request->id_visit_services) || $request->id_customer_visits == null || empty($request->id_customer_visits)){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Service ID not sent to the API! ",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $req = $request->update_staff_req;
                $id_customer_visits = $request->id_customer_visits;
                $id_visit_services = $request->id_visit_services;

                VisitServiceStaff::where('customer_visit_id', $id_customer_visits)  
                ->where('additional_staff', 'No')
                ->where('visit_service_id', '=', $request->id_visit_services)->update([
                'requested' => $req 
                ]); 
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Staff Marked as Requested for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if(null != $request->update_service_promo){ //Mark Promotional
                if($request->id_visit_services == null || empty($request->id_visit_services) || $request->id_customer_visits == null || empty($request->id_customer_visits)){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Service ID not sent to the API! ",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $promo = $request->update_service_promo;
                $id_customer_visits = $request->id_customer_visits;
                $id_visit_services = $request->id_visit_services;

                VisitServices::where('customer_visit_id', $id_customer_visits)              
                ->where('id_visit_services', '=', $request->id_visit_services)->update([
                'promo' => $promo 
                ]); 
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Service Marked as Promotional for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if(null != $request->update_service_crosssell){ //Add Cross Sell
                if($request->id_visit_services == null || empty($request->id_visit_services) || $request->id_customer_visits == null || empty($request->id_customer_visits)){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Service ID not sent to the API! ",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $crosssell = $request->update_service_crosssell;
                $id_customer_visits = $request->id_customer_visits;
                $id_visit_services = $request->id_visit_services;

                VisitServices::where('customer_visit_id', $id_customer_visits)  
                ->where('id_visit_services', '=', $request->id_visit_services)->update([
                'crosssell' => $crosssell 
                ]); 
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Service Marked as Cross Sell for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if(null != $request->remove_service){   //Remove Service

                $id_customer_visits = $request->id_customer_visits; 
                $id_visit_services = $request->id_visit_services;

                if($id_customer_visits == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if($id_visit_services == null){
                    DB::rollBack();
                    return response()->json([           
                        "message" => "Service Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                //count the number of active services for the visit
                $active_services_count = VisitServices::where('customer_visit_id', $id_customer_visits)
                ->where('visit_service_status', 'Active')->count();

                if($active_services_count <= 1){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Cannot Remove the only Active Service for Visit ID ".$id_customer_visits,            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                VisitServices::where('customer_visit_id', $id_customer_visits)  
                ->where('id_visit_services', '=', $id_visit_services)->update([
                'visit_service_status' => 'Cancelled'
                ]); 
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Service Has been removed from Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);


            }

            if($request->duplicate_service != null){   //Duplicate Service

                $id_customer_visits = $request->id_customer_visits; 
                $id_visit_services = $request->id_visit_services;

                if($id_customer_visits == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if($id_visit_services == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Service Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $service_details = VisitServices::where('customer_visit_id', $id_customer_visits)  
                ->where('id_visit_services', '=', $id_visit_services)
                ->first();

                if(null == $service_details || empty($service_details)){
                    DB::rollBack();
                    return response()->json([           
                        "message" => "Service Details Not Found for Service ID ".$id_visit_services,            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $new_service = new VisitServices();
                $new_service->customer_visit_id = $service_details->customer_visit_id;
                $new_service->service_id = $service_details->service_id;
                $new_service->service_flag = $service_details->service_flag;
                $new_service->service_name = $service_details->service_name;
                $new_service->s_type = $service_details->s_type;
                $new_service->s_category = $service_details->s_category;
                $new_service->s_rate = $service_details->s_rate;
                $new_service->id_service_type = $service_details->id_service_types;
                $new_service->id_service_category = $service_details->id_service_category;                
                $new_service->visit_service_start = $service_details->visit_service_start; //New Service Starts 5 Minutes after the End of the Previous Service
                // Calculate new end time based on original duration
                $new_service->visit_service_end = $service_details->visit_service_end;
                $new_service->promo = $service_details->promo;
                $new_service->crosssell = $service_details->crosssell;
                
                $new_service->visit_service_status = $service_details->visit_service_status;
                $new_service->business_id = $service_details->business_id;
                $new_service->save();
                $new_service_id = $new_service->id_visit_services;
                //Duplicate the Staff also
                $service_staff = VisitServiceStaff::where('customer_visit_id', $id_customer_visits)  
                ->where('visit_service_id', '=', $id_visit_services)
                ->where('visit_service_staff_status', 'Active')
                ->get();

                foreach($service_staff as $staff){
                    $new_staff = new VisitServiceStaff();
                    $new_staff->customer_visit_id = $staff->customer_visit_id;
                    $new_staff->visit_service_id = $new_service_id;
                    $new_staff->staff_id = $staff->staff_id;
                    $new_staff->staff_name = $staff->staff_name;
                    $new_staff->visit_service_staff_status = $staff->visit_service_staff_status;
                    $new_staff->block_other = $staff->block_other;
                    $new_staff->business_id = $staff->business_id;
                    $new_staff->requested = $staff->requested;
                    $new_staff->additional_staff = 'Yes';
                    $new_staff->save();
                }
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Service Has been Duplicated for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }
                
            if($request->discount != null){
                $discount = $request->discount;
                $reason=$request->reason;
                $id_customer_visits = $request->id_customer_visits; 

                if($id_customer_visits == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if($discount > 0){
                    
                    CustomerVisits::where('id_customer_visits', '=', $id_customer_visits)->update([
                    'discount' => $discount , 'discount_reason' => $reason
                    ]); 
                    DB::commit(); //Commit the transaction
                    return response()->json([           
                        "message" => "Discount to be given at time of Invoicing added to Visit ID ".$id_customer_visits,
                        "message_type" => "success",
                        "message_btn" => "success"
                    ]);
                } else {
                    DB::rollBack();
                    return response()->json([           
                        "message" => "Discount 0 cannot be added to  Visit ID ".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

            }

            if($request->remarks !=""){
                $id_customer_visits = $request->id_customer_visits; 
                $remarks = $request->remarks;

                if($id_customer_visits == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Id not sent to API!",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if($remarks != ""){
                    CustomerVisits::where('id_customer_visits', '=', $id_customer_visits)->update([
                    'advance_comment' => $remarks
                    ]); 
                    DB::commit(); //Commit the transaction
                    return response()->json([           
                        "message" => "Remarks added to Visit ID ".$id_customer_visits,
                        "message_type" => "success",
                        "message_btn" => "success"
                    ]);
                } else {
                    DB::rollBack();
                    return response()->json([           
                        "message" => "Remarks cannot be empty for Visit ID ".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                
                }           

            }

            if($request->remove_advance != null){
                $id_visit_advance = $request->id_visit_advance;
                $id_customer_visits = $request->id_customer_visits;

                if($id_customer_visits == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit ID not passed to the API",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }
                if($id_visit_advance == null) {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Advance ID not passed to the API",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                $visit_advance = VisitAdvance::select('id_visit_advance', 'customer_visit_id', DB::RAW('date(advance_date) as advance_date'))
                ->where('id_visit_advance', '=', $id_visit_advance)
                ->where('customer_visit_id', '=', $id_customer_visits)->first();
                if($visit_advance->advance_date == date("Y-m-d")){
                    //Mark the Advance as Cancelled
                    VisitAdvance::where('id_visit_advance', '=', $id_visit_advance)
                    ->where('customer_visit_id', '=', $id_customer_visits)
                    ->where('advance_status', 'Active')
                    ->update([
                        'advance_status' => 'Cancelled',
                        'cancelled_by' => session('user_name'),
                        'cancelled_on' => date('Y-m-d H:i:s')
                    ]);
                    //Cancel Advance Account Voucher
                    $account_voucher = AccountVouchers::where('visit_advance_id', $id_visit_advance)
                    ->update([
                        'voucher_status' => 'Cancelled',
                        'cancelled_by' => session('user_name'),
                        'cancelled_on' => date('Y-m-d H:i:s')
                    ]);
                } else {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Previous Date Advances Cannot Be Removed! ",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }                

                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Advance Removed from Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);

            }

            if($request->add_advance != null){
                $id_customer_visits = $request->id_customer_visits;

                if($id_customer_visits == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit ID not passed to the API",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if($request->payment_mode == null){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Payment Mode not passed to the API",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                if($request->advance_amount == null || $request->advance_amount < 0){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Advance Amount not passed to the API",
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

            
                    $new_visit_advance = new VisitAdvance();
                    $new_visit_advance->customer_visit_id = $id_customer_visits;
                    $new_visit_advance->advance_amount = $request->advance_amount;
                    $new_visit_advance->advance_date = date("Y-m-d H:i:s");
                    $new_visit_advance->advance_mode = $request->payment_mode;
                    $new_visit_advance->advance_inst = $request->inst_number;
                    $new_visit_advance->advance_remarks = $request->advance_comments;
                    $new_visit_advance->advance_user = session("user_name");
                    $new_visit_advance->advance_cc_charge = $request->cc_fee;
                    $new_visit_advance->save();
                    $new_id_visit_advance = $new_visit_advance->id_visit_advance;

                    ///Create Advance Account Voucher
                    if($new_id_visit_advance > 0){
                        

                        $account_voucher = new AccountVouchers();
                        $account_voucher->voucher_date = date("Y-m-d H:i:s");         
                        $account_voucher->voucher_type = 2; //Receipt
                        $account_voucher->voucher_status = 'Active';
                        $account_voucher->created_by = session('user_name');
                        $account_voucher->created_on = date('Y-m-d H:i:s');
                        $account_voucher->visit_advance_id = $new_id_visit_advance;
                        $account_voucher->sale_type = 'service';     
                        $account_voucher->voucher_date = date('Y-m-d H:i:s');
                        $account_voucher->description = 'Advance Received against Visit ID: '.$new_id_visit_advance.' on '.date('d-m-Y H:i:s').', from '.$request->customer_name.' customer ID : '.$request->id_customer;
                        $account_voucher->business_id = $request->business_id ?? session('business_id');
                        $account_voucher->voucher_amount = $request->advance_amount;
                        $account_voucher->cost_center = 1;
                        $account_voucher->cost_center_name = 'Front Desk';
                        $account_voucher->business_partner = '1';
                        $account_voucher->business_partner_id = $request->id_customer;
                        $account_voucher->business_partner_name = $request->customer_name;
                        $account_voucher->visit_id = $request->id_customer_visits;            
                        $account_voucher->payment_mode = $request->payment_mode;
                        $account_voucher->auto_voucher = 'Yes';

                        $account_voucher->save();
                        $new_voucher_id = $account_voucher->id_account_vouchers;
                    
                        //Get the event mappings for Invoice Creation id_events = 1
                        
                        if(session('ho_accounts')=='Yes'){
                            $common_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                        } else {
                            $common_business_id = $request->business_id;
                        }

                        $event_mappings = AccountEventMapping::where('account_event_id', 2)->where('business_id', $common_business_id)->get();
                        $debit_amounts = [];
                        $credit_amounts = [];
                        $debit_accounts = array();
                        $credit_accounts = array();
                        foreach($event_mappings as $mapping){                    

                            if($mapping['transaction_type']=='debit'){
                                array_push($debit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                            } else {
                                array_push($credit_accounts, $mapping['account_head_id']."|".$mapping['transaction_type']."|".$mapping['entity_name']);
                            }
                        
                            if($mapping['transaction_type']=='debit'){
                                //make debit entry data
                                if($mapping['entity_name']=='paid_cash'){array_push($debit_amounts, [ 'entity_name' => 'paid_cash', 'amount' => $request->payment_mode == "Cash" ? $request->advance_amount : 0 ]);}
                                if($mapping['entity_name']=='paid_card'){array_push($debit_amounts, [ 'entity_name' => 'paid_card', 'amount' => $request->payment_mode == "Card" || $request->payment_mode == "D-Card" ? $request->advance_amount : 0 ]);}
                                if($mapping['entity_name']=='paid_check'){array_push($debit_amounts, [ 'entity_name' => 'paid_check', 'amount' => $request->payment_mode == "Check" ? $request->advance_amount : 0 ]);}
                                if($mapping['entity_name']=='paid_online'){array_push($debit_amounts, [ 'entity_name' => 'paid_online', 'amount' => $request->payment_mode == "Online" ? $request->advance_amount : 0 ]);}
                                if($mapping['entity_name']=='cc_fee_expense'){array_push($debit_amounts, [ 'entity_name' => 'cc_fee_expense', 'amount' => $request->cc_fee ]);}

                                //get the sum of debit amounts
                                

                            } else if($mapping['transaction_type']=='credit'){
                                //make credit entry data
                                if($mapping['entity_name']=='advance_amount'){array_push($credit_amounts, [ 'entity_name' => 'advance_amount', 'amount' => $request->advance_amount ]);}
                                if($mapping['entity_name']=='cc_fee'){array_push($credit_amounts, [ 'entity_name' => 'cc_fee', 'amount' => $request->cc_fee ]);}

                                //get the sum of credit amounts
                            
                            }
                        }
                        // return $debit_sum." == ".$credit_sum;
                        $debit_sum = !empty($debit_amounts) ? array_sum(array_column($debit_amounts, 'amount')) : null;
                        $credit_sum = !empty($credit_amounts) ? array_sum(array_column($credit_amounts, 'amount')) : null;
                        if($debit_sum == null || $credit_sum == null || $debit_sum != $credit_sum){
                            DB::rollBack(); //Rollback the transaction
                            return response()->json([
                                "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit and Credit amounts do not match. Please contact system administrator.",
                                "message_type" => "error",
                                "message_btn" => "danger"
                            ]);
                        } else if($debit_sum == 0 || $credit_sum == 0){
                            DB::rollBack(); //Rollback the transaction
                            return response()->json([
                                "message" => "debit=". $debit_sum . " credit=". $credit_sum . " Error in Voucher Creation. Debit or Credit amounts are zero. Please contact system administrator.",
                                "message_type" => "error",
                                "message_btn" => "danger"
                            ]);
                        
                        
                        }else{                    
                            //Insert voucher Details
                            foreach($debit_accounts as $debit){
                                $debit_parts = explode("|", $debit);
                                $new_voucher_details = new AccountVoucherDetail();
                                $new_voucher_details->account_voucher_id = $new_voucher_id;
                                $new_voucher_details->account_head_id = $debit_parts[0];
                                $entity = $debit_parts[2]; // this is 'paid_cash' etc.
                                $new_voucher_details->debit = array_sum(array_map(function($item) use ($entity) {
                                    return $item['entity_name'] === $entity ? $item['amount'] : 0;
                                }, $debit_amounts));
                                $new_voucher_details->credit = 0;    
                                if($new_voucher_details->debit != 0){                                            
                                    $new_voucher_details->save();
                                }
                            }
                            foreach($credit_accounts as $credit){
                                $credit_parts = explode("|", $credit);
                                $new_voucher_details = new AccountVoucherDetail();
                                $new_voucher_details->account_voucher_id = $new_voucher_id;
                                $new_voucher_details->account_head_id = $credit_parts[0];
                                $new_voucher_details->debit = 0;
                                $entity = $credit_parts[2]; // this is 'paid_cash' etc.
                                $new_voucher_details->credit = array_sum(array_map(function($item) use ($entity) {
                                    return $item['entity_name'] === $entity ? $item['amount'] : 0;
                                }, $credit_amounts));
                                if($new_voucher_details->credit != 0){           
                                    $new_voucher_details->save();
                                }
                            }
                        }
                        //Voucher Creation Ends
                        DB::commit(); //Commit the transaction
                    } else {
                        DB::rollBack(); //Rollback the transaction
                        return response()->json([           
                            "message" => "Error in Saving Advance. Please contact system administrator.",
                            "message_type" => "error",
                            "message_btn" => "danger"
                        ]);
                    }
                
                DB::commit(); //Commit the transaction    
                return response()->json([           
                    "message" => "Advance Added to Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }

            if($request->mark_in_service == 1){
                $id_customer_visits = $request->id_customer_visits;

                if(null == $id_customer_visits || empty($id_customer_visits)){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "ID Visit not sent to the API!".$id_customer_visits,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }

                CustomerVisits::where('id_customer_visits', $id_customer_visits)->update([
                    'inservice' => 'Yes',
                    'inservice_time' => date('Y-m-d H:i:s')
                ]);
                DB::commit(); //Commit the transaction
                return response()->json([           
                    "message" => "Visit Marked as In Service for Visit ID ".$id_customer_visits,
                    "message_type" => "success",
                    "message_btn" => "success"
                ]);
            }
            
        } catch(\Exception $e){
            DB::rollBack(); //Rollback the transaction
                return response()->json([           
                    "message" => "Error Occurred: ".$e->getMessage(),
                    "message_type" => "error",
                    "message_btn" => "danger"
                ]);
        }    
    }

    public function add_services_to_visit(Request $request){
      //  echo '<pre>'; print_r($request->add_services); exit();

        if(empty($request->id_customer_visits) || $request->id_customer_visits <1){
            return response()->json([           
                "message" => "Visit ID Not Passed To API",            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }

        if(empty($request->add_services) || count($request->add_services) <1){
            return response()->json([           
                "message" => "No Services Selected to be Added to Visit",            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }

        $id_customer_visits = $request->id_customer_visits;
        $add_services = $request->add_services;

        $visit_details = CustomerVisits::select('id_customer_visits', 'customer_id', 'customer_visits.business_id', 'visit_status', DB::RAW('max(visit_service_end) as visit_service_start'), 'staff_id', 'staff_name')
        ->join('visit_services', 'visit_services.customer_visit_id', '=', 'customer_visits.id_customer_visits')
        ->join('visit_service_staffs', 'visit_service_staffs.visit_service_id', '=', 'visit_services.id_visit_services')
        ->where("id_customer_visits","=",$id_customer_visits)
        ->where("visit_service_status","=", "Active")
        ->where("visit_service_staff_status","=", "Active")        
        ->first();

        if($visit_details->visit_status != "open"){
            return response()->json([           
                "message" => "Only Open Visits can be Edited",            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }

        $next_visit_service_start = "";
        foreach($add_services as $service){

            $id_service = $service['id_business_services'];
            $service_name = $service['service_name'];
            $id_service_type = $service['id_service_types'];
            $type_name = $service['type_name'];
            $id_service_category = $service['id_service_category'];
            $category_name = $service['category_name'];
            $service_flag = $service['service_flag'];
            $service_price = $service['service_price'];
            $service_crosssell = $service['crosssell'];
           // $service_duration = $service['service_duration'];


            if($service_flag == "servicetype"){

                $service_details = Services::select('id_business_services', 'service_name', 'id_service_types', 'id_service_category', 'service_type', 'service_category', 'service_duration', 'service_rate', 'business_services.business_id', 'business.business_closing_time')
                ->join('service_category', 'service_category.id_service_category', '=', 'business_services.service_category_id')
                ->join('service_type', 'service_type.id_service_types', '=', 'service_category.service_type_id')
                ->join('business', 'business.id_business', '=', 'business_services.business_id')
                ->where('id_business_services', '=', $id_service)
                ->where('id_service_category', '=', $id_service_category)
                ->where('id_service_types', '=', $id_service_type)
                ->where('service_active', '=', 'Yes')
                ->where('service_type_active', '=', 'Yes')
                ->where('service_category_active', '=', 'Yes')
                ->first();

                

                if(null == $service_details || empty($service_details)){
                    continue;
                }

                //Insert into visit_services
                $new_visit_service = new VisitServices();
                $new_visit_service->customer_visit_id = $id_customer_visits;
                $new_visit_service->service_id = $service_details->id_business_services;
                $new_visit_service->service_flag = 'servicetype';
                $new_visit_service->service_name = $service_details->service_name;
                $new_visit_service->s_type = $service_details->service_type;
                $new_visit_service->s_category = $service_details->service_category;
                $new_visit_service->s_rate = $service_details->service_rate;
                $new_visit_service->id_service_type = $service_details->id_service_types;
                $new_visit_service->id_service_category = $service_details->id_service_category;   
                $new_visit_service->crosssell = $service_crosssell;
                // Determine base start
                $base_start = $next_visit_service_start != "" 
                    ? Carbon::parse($next_visit_service_start) 
                    : Carbon::parse($visit_details->visit_service_start);
                // Service duration
                list($h, $m, $s) = array_map('intval', explode(':', $service_details->service_duration = "00:00:00" ? "00:15:00" : $service_details->service_duration));
                
                // Calculate tentative end                
                $visit_service_end = $base_start->copy()
                    ->addHours($h)
                    ->addMinutes($m)
                    ->addSeconds($s);
                
                
                // Business closing for the same day
                $business_closing = Carbon::parse(
                    $base_start->format('Y-m-d') . ' ' . $service_details->business_closing_time
                );
                
                // Clamp end time if it exceeds business closing
                if ($visit_service_end->greaterThan($business_closing)) {
                    // End 5 minutes before closing
                    $visit_service_end = $business_closing->copy()->subMinutes(5);

                    // Start = end - service_duration
                    $base_start = $visit_service_end->copy()
                        ->subHours($h)
                        ->subMinutes($m)
                        ->subSeconds($s);
                }

                // Save clamped end
                $new_visit_service->visit_service_start = $base_start->format('Y-m-d\TH:i:s');  //Insert Start Time                
                $new_visit_service->visit_service_end = $visit_service_end->format('Y-m-d\TH:i:s'); //Insert End Time

                // Decide next start for following appointment
                $next_visit_service_start = $visit_service_end->format('Y-m-d\TH:i:s');

                $new_visit_service->visit_service_status = 'Active';
                $new_visit_service->business_id = $visit_details->business_id;
                $new_visit_service->save();

                //Assign the Same Staff as the Visit to this New Service
                $new_visit_service_staff = new VisitServiceStaff();
                $new_visit_service_staff->customer_visit_id = $id_customer_visits;
                $new_visit_service_staff->visit_service_id = $new_visit_service->id_visit_services;
                $new_visit_service_staff->staff_id = $visit_details->staff_id;
                $new_visit_service_staff->staff_name = $visit_details->staff_name;
                $new_visit_service_staff->visit_service_staff_status = 'Active';
                $new_visit_service_staff->block_other = 'No';
                $new_visit_service_staff->business_id = $visit_details->business_id;
                $new_visit_service_staff->save();

            } elseif($service_flag == "packagetype"){
                $package_details = Services::select('id_business_services', 'service_name', 'package_services.service_rate', 'service_duration', 'id_package_type', 'service_type', 'id_package_category', 'service_category', 'business_services.business_id', 'business.business_closing_time')
                ->join('package_services', 'package_services.service_id', '=', 'business_services.id_business_services')
                ->join('package_category', 'package_category.id_package_category', '=', 'package_services.package_category_id')
                ->join('package_type', 'package_type.id_package_type', '=', 'package_category.package_type_id')
                ->join('business', 'business.id_business', '=', 'business_services.business_id')
                ->where('package_services.service_id', '=', $id_service)
                ->where('package_services.package_category_id', '=', $id_service_category)
                ->where('package_category.package_type_id', '=', $id_service_type)
                ->where('service_active', '=', 'Yes')
                ->where('service_type_active', '=', 'Yes')
                ->where('service_category_active', '=', 'Yes')
                ->where('package_services_active', '=', 'Yes')
                ->first();
                
                if(null == $package_details || empty($package_details)){
                    continue;
                }

                //Insert into visit_services
                $new_visit_service = new VisitServices();
                $new_visit_service->customer_visit_id = $id_customer_visits;
                $new_visit_service->service_id = $package_details->id_business_services;
                $new_visit_service->service_flag = 'packagetype';
                $new_visit_service->service_name = $package_details->service_name;
                $new_visit_service->s_type = $package_details->service_type;
                $new_visit_service->s_category = $package_details->service_category;
                $new_visit_service->s_rate = $package_details->service_rate;
                $new_visit_service->id_service_type = $package_details->id_package_type;
                $new_visit_service->id_service_category = $package_details->id_package_category;        
                       
                 // Determine base start
                $base_start = $next_visit_service_start != "" 
                    ? Carbon::parse($next_visit_service_start) 
                    : Carbon::parse($visit_details->visit_service_start);

                

                // Service duration
                list($h, $m, $s) = array_map('intval', explode(':', $package_details->service_duration = "00:00:00" ? "00:15:00" : $package_details->service_duration));
                
                // Calculate tentative end
                
                $visit_service_end = $base_start->copy()
                    ->addHours($h)
                    ->addMinutes($m)
                    ->addSeconds($s);
                
                
                // Business closing for the same day
                $business_closing = Carbon::parse(
                    $base_start->format('Y-m-d') . ' ' . $service_details->business_closing_time
                );

                // Clamp end time if it exceeds business closing
                if ($visit_service_end->greaterThan($business_closing)) {
                    // End 5 minutes before closing
                    $visit_service_end = $business_closing->copy()->subMinutes(5);

                    // Start = end - service_duration
                    $base_start = $visit_service_end->copy()
                        ->subHours($h)
                        ->subMinutes($m)
                        ->subSeconds($s);
                }

                // Save clamped end
                $new_visit_service->visit_service_start = $base_start->format('Y-m-d\TH:i:s');  //Insert Start Time                
                $new_visit_service->visit_service_end = $visit_service_end->format('Y-m-d\TH:i:s'); //Insert End Time

                // Decide next start for following appointment
                $next_visit_service_start = $visit_service_end->format('Y-m-d\TH:i:s');

                $new_visit_service->visit_service_status = 'Active';
                $new_visit_service->business_id = $visit_details->business_id;
                $new_visit_service->save();

                
                //Assign the Same Staff as the Visit to this New Service
                $new_visit_service_staff = new VisitServiceStaff();
                $new_visit_service_staff->customer_visit_id = $id_customer_visits;
                $new_visit_service_staff->visit_service_id = $new_visit_service->id_visit_services;
                $new_visit_service_staff->staff_id = $visit_details->staff_id;
                $new_visit_service_staff->staff_name = $visit_details->staff_name;
                $new_visit_service_staff->visit_service_staff_status = 'Active';
                $new_visit_service_staff->block_other = 'No';
                $new_visit_service_staff->business_id = $visit_details->business_id;
                $new_visit_service_staff->save();
                
            } else {
                continue;
            }

        }
        return response()->json([           
            "message" => "Selected Services Added to Visit",            
            "message_type" => "success",
            "message_btn" => "success"
        ]);
    }

    public function create_visits_from_booking(Request $request){

        try {
            $package_id = $request->package_id;
            $business_id = session('business_id');
            if($request->business_id != null && $request->business_id > 0){
                $business_id = $request->business_id;
            }

            $business_details= Business::select('id_business', 'single_period_booking')->where('id_business', $business_id)->first();

            $id_customer = $request->customer_id;
            $booking_date = $request->booking_date;
            $event_date = $request->event_date;

            $referring_staff = $request->referring_staff;        
            $booking_discount = $request->booking_discount;
            $booking_advance = $request->booking_advance;
            $booking_total_after_discount = $request->booking_total_after_discount;
            $booking_remaining_total = $request->booking_remaining_total;
            $visit_date = $request->visit_date != null ? $request->visit_date : $request->event_date;            

            //create a new booking
            $new_booking = new Booking();
            $new_booking->business_id = $business_id;
            $new_booking->customer_id = $id_customer;
            $new_booking->package_id = $package_id;
            $new_booking->booking_date = now();
            $new_booking->discount = $booking_discount;
            $new_booking->save();


            $newRequest = new Request();
            $newRequest->replace([
                'business_id' => $business_id,
                'id_customer' => $id_customer,
                'visit_date' => $visit_date != null ? $visit_date : $event_date,
                'staff_id' => $referring_staff,
                'strict_time' => 'No',
                'promo' => 'No',
                'requested' => 'No',
                'referring_staff' => $referring_staff,
                'booking' => 'Yes',
                'discount' => $booking_discount,
                'advance' => $booking_advance,           
                'instrument_number' => $request->booking_instrument_number,
                'payment_mode' => $request->booking_payment_mode,   
            ]);


            $category_data = $request->category_data;

            // ---- TOTAL CATEGORY PRICE ----
            $totalCategoryPrice = 0;
            foreach ($category_data as $cat) {
                $totalCategoryPrice += $cat['category_price'] ?? 0;
            }

            $remainingDiscount = $booking_discount;
            $remainingAdvance  = $booking_advance;


            $category_data = $request->category_data;            
            $service_data = []; $last_category_id = 0;
            foreach($category_data as $category){                
                $categoryPrice = $category['category_price'] ?? 0;

                // ---------- DISCOUNT DISTRIBUTION ----------
                $categoryDiscount = 0;
                if ($totalCategoryPrice > 0 && $remainingDiscount > 0) {
                    $categoryDiscount = round(
                        ($categoryPrice / $totalCategoryPrice) * $booking_discount,
                        2
                    );
                    $remainingDiscount -= $categoryDiscount;
                }

                $discountedCategoryPrice = $categoryPrice - $categoryDiscount;

                // ---------- ADVANCE CONSUMPTION ----------
                $categoryAdvance = 0;
                if ($remainingAdvance > 0) {
                    if ($remainingAdvance >= $discountedCategoryPrice) {
                        $categoryAdvance = $discountedCategoryPrice;
                        $remainingAdvance -= $discountedCategoryPrice;
                    } else {
                        $categoryAdvance = $remainingAdvance;
                        $remainingAdvance = 0;
                    }
                }


                $service_ids = explode(",", $category['id_service']);
                foreach($service_ids as $service_id){
                    $service_data[] = [
                        'id_service_types' => $category['id_service_type'],
                        'id_business_services' => $service_id,                                        
                        'id_service_category' => $category['id_service_category'],                  
                        'service_name' => '',
                        'category_name' => $category['category_name'],
                        'type_name' => $category['type_name'],
                        'service_price' => '',
                        'service_flag' => 'packagetype',                    
                        'staff_id' => $category['category_staff'],
                        'service_start_time' => $category['category_date_time'],
                    ];  
                    $last_category_id = $category['id_service_category'];                        
                }
                //////////only if single period booking is no, create seperate visit for each category//////////
                if($business_details->single_period_booking == "No"){

                    $newRequest->merge([
                        'add_services' => $service_data,
                        'discount'     => $categoryDiscount,
                        'advance'      => $categoryAdvance,
                    ]);
                    
                    //seperate visit for the category processed
                    $newRequest->merge(['add_services' => $service_data]);
                    $response =  $this->create_visit($newRequest);      
                    $response_data = $response->getData();

                    if($response_data->message_type == "success"){
                        DB::beginTransaction(); //Start Transaction
                        //create new booking_visit record
                        $new_booking_visit = new BookingVisit();
                        $new_booking_visit->booking_id = $new_booking->id_bookings;
                        $new_booking_visit->visit_id = $response_data->new_visit_id;
                        $new_booking_visit->category_id = $last_category_id;
                        
                        $new_booking_visit->save(); 

                        if ($response_data->message_type == "success" && $categoryAdvance > 0) {
                            
                                $created_visit_id = $response_data->new_visit_id;
                                $advanceRequest = new Request();
                                $advanceRequest->replace([
                                    'id_customer_visits' => $created_visit_id,
                                    'add_advance'        => 1,
                                    'advance_amount'     => $categoryAdvance, 
                                    'payment_mode'       => $request->booking_payment_mode,
                                    'inst_number'        => $request->booking_instrument_number,
                                    'advance_comments'   => 'Advance against Booking ID: '.$new_booking->id_bookings,
                                    'cc_fee'             => 0,
                                    'id_customer'        => $id_customer,
                                    'customer_name'      => Customers::where('id_customers', $id_customer)->value('customer_name'),
                                    'business_id'        => $business_id
                                ]);

                                $advance_response = $this->update_visit($advanceRequest);
                                $advance_response_data = $advance_response->getData();

                                if ($advance_response_data->message_type == "success") {
                                    
                                } else {
                                    DB::rollBack();
                                    return response()->json([
                                        "message"      => "Visit Created but Error in Adding Advance: ".$advance_response_data->message,
                                        "message_type" => "error",
                                        "message_btn"  => "danger"
                                    ]);
                                }
                            }


                        DB::commit(); //Commit the transaction
                    } else {
                        DB::rollBack(); //Rollback the transaction
                        return $response;
                    }

                    //reinitialize $newRequest and $service_data
                    $service_data = [];
                    $newRequest = new Request();
                    $newRequest->replace([
                        'business_id' => $business_id,
                        'id_customer' => $id_customer,
                        'visit_date' => $visit_date,
                        'staff_id' => $referring_staff,
                        'strict_time' => 'No',
                        'promo' => 'No',
                        'requested' => 'No',
                        'referring_staff' => $referring_staff,
                        'booking' => 'Yes',
                        'discount' => 0,
                        'advance' => 0,           
                        'instrument_number' => $request->booking_instrument_number,
                        'payment_mode' => $request->booking_payment_mode,   
                    ]);
                }                
                //////////end of category wise multiple visits per booking/////////////////////////////////////
            }

            //create visit with all services if single period booking is Yes
            if($business_details->single_period_booking == "Yes"){
                DB::beginTransaction(); //Start Transaction
                $newRequest->merge(['add_services' => $service_data]);         
                //return $newRequest;   
                $response =  $this->create_visit($newRequest);
                $response_data = $response->getData();

                if($response_data->message_type == "success"){
                    //create new booking_visit record
                    $new_booking_visit = new BookingVisit();
                    $new_booking_visit->booking_id = $new_booking->id_bookings;
                    $new_booking_visit->visit_id = $response_data->new_visit_id;
                    $new_booking_visit->category_id = $last_category_id;
                    
                    $new_booking_visit->save();
                    DB::commit(); //Commit the transaction
                } else {
                    DB::rollBack(); //Rollback the transaction
                    return $response;
                }
            }
            //End of creating single visit for the booking

            //add booking advance against the visit
            
            if($response_data->message_type == "success" && $booking_advance >0 && $business_details->single_period_booking == "Yes"){
               
                DB::beginTransaction(); //Start Transaction

                $created_visit_id =$response_data->new_visit_id;                

                $advanceRequest = new Request();
                $advanceRequest->replace([
                    'id_customer_visits' => $created_visit_id,
                    'add_advance' => 1,
                    'advance_amount' => $booking_advance,
                    'payment_mode' => $request->booking_payment_mode,
                    'inst_number' => $request->booking_instrument_number,
                    'advance_comments' => 'Advance against Booking ID: '.$new_booking->id_bookings,
                    'cc_fee' => 0,
                    'id_customer' => $id_customer,
                    'customer_name' => Customers::where('id_customers', $id_customer)->value('customer_name'),
                    'business_id' => $business_id
                ]);

                $advance_response = $this->update_visit($advanceRequest);
                $advance_response_data = $advance_response->getData();
                DB::commit(); //Commit the transaction

                if($advance_response_data->message_type != "success"){
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([           
                        "message" => "Visit Created but Error in Adding Advance: ".$advance_response_data->message,
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }
            }

            //add new booking id to response
            $response_data->booking_id = $new_booking->id_bookings;
            $response->setData($response_data);
            
            return $response;
        } catch(\Exception $e){
            DB::rollBack(); //Rollback the transaction
            return response()->json([           
                "message" => "Error Occurred: ".$e->getMessage(),
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }

    }

    public function create_visit(Request $request){        
       
        if(empty($request->id_customer) || $request->id_customer <1){
            return response()->json([           
                "message" => "Customer ID Not Passed To API",            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }

        if(empty($request->visit_date) || $request->visit_date =="" || $request->visit_date == null){
            return response()->json([           
                "message" => "Visit Date Not Passed To API",            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }

        DB::beginTransaction(); //Start the transaction
        try{
            $customer_id = $request->id_customer;
            $business_id = session('business_id');
            if($request->business_id != null && $request->business_id >0){
                $business_id = $request->business_id;
            }

            $visit_date = $request->visit_date;        
            $visit_color = $request->visit_color;
            $staff_id = $request->staff_id;       
            $visit_stricttime = $request->strict_time;
            $requested = $request->requested;
            $promo = $request->promo;
            $membership = $request->membership;

            $business = Business::where('id_business', '=', $business_id)->first();

            //Check if Customer Exists
            $customer_details = Customers::where('id_customers', '=', $customer_id)        
            ->first();

            if(null == $customer_details || empty($customer_details)){
                DB::rollBack(); //Rollback the transaction
                return response()->json([           
                    "message" => "Customer Does Not Exist or is Inactive",            
                    "message_type" => "error",
                    "message_btn" => "danger"
                ]);
            }

            //Check if Staff Exists
            if($request->booking == null || $request->booking != "Yes"){
                if(null != $staff_id && $staff_id >0){
                    $staff_details = Staff::where('id_staff', '=', $staff_id);
                    if($business->common_products == "Yes"){
                        $staff_details = $staff_details->where(function($query) use ($business_id){
                            $query->where('business_id', '=', $business_id)
                                ->orWhere('staff_shared', '=', 'Yes');
                        });
                    } else {
                        $staff_details = $staff_details->where('business_id', '=', $business_id);
                    }
                    $staff_details = $staff_details->where('staff_active', '=', 'Y')
                    ->where('staff_scheduler', '=', 'On')
                    ->first();

                    if(null == $staff_details || empty($staff_details)){
                        DB::rollBack(); //Rollback the transaction
                        return response()->json([           
                            "message" => "Staff Does Not Exist or is Inactive ID: ".$staff_id,            
                            "message_type" => "error",
                            "message_btn" => "danger"
                        ]);
                    }
                } else {
                    DB::rollBack(); //Rollback the transaction
                    return response()->json([          
                        "message" => "Staff ID Not Passed To API",            
                        "message_type" => "error",
                        "message_btn" => "danger"
                    ]);
                }
            } 

            //Get Next Visit Color
            if(null == $visit_color || $visit_color == ""){
                $last_visit_color = DB::TABLE('customer_visit_colors')            
                ->where('visit_color_code', '=', DB::raw("(SELECT visit_color FROM customer_visits WHERE customer_visits.business_id = $business_id 
                AND customer_visits.visit_status in('open', 'invoiced') ORDER BY id_customer_visits Desc LIMIT 1)"))
                ->first();
                //return $last_visit_color;
                if(null != $last_visit_color && !empty($last_visit_color)){
                    if($last_visit_color->visit_color_code == null || $last_visit_color->visit_color_code == "" || $last_visit_color->visit_color_code == null){
                        $visit_color = "#641E16";
                        $visit_color_type = "Light";                
                    } else {
                        $new_visit_color = DB::TABLE('customer_visit_colors')            
                        ->where('id_visit_colors', '>', $last_visit_color->id_visit_colors)
                        ->orderBy('id_visit_colors', 'ASC')
                        ->first();
                        if(null == $new_visit_color || empty($new_visit_color)){
                            $visit_color =  "#641E16";
                            $visit_color_type = "Light";
                        }else{
                            $visit_color = $new_visit_color->visit_color_code;
                            $visit_color_type = $new_visit_color->visit_color_type;
                        }
                    }
                } else {
                    $visit_color = "#641E16";
                    $visit_color_type = "Light";
                }
            }

            //Create Visit
            $new_visit = new CustomerVisits();
            $new_visit->customer_id = $customer_id;
            $new_visit->business_id = $business_id;        
            $new_visit->customer_visit_date = $visit_date;        
            $new_visit->visit_status = 'open';
            $new_visit->visit_color = $visit_color;     
            $new_visit->visit_color_type = $visit_color_type;   
            $new_visit->created_by = session('user_name');
            $new_visit->reminder_stricttime = $visit_stricttime != null ? $visit_stricttime : "No";   
            $new_visit->referring_staff = $request->referring_staff != null ? $request->referring_staff : null;
            $new_visit->discount  = $request->discount != null ? $request->discount : 0;
            $new_visit->advance_amount  = $request->advance != null ? $request->advance : 0;
            $new_visit->advance = $request->advance != null && $request->advance >0 ? true : false;
            $new_visit->advance_mode = $request->advance != null && $request->advance >0 ? $request->payment_mode : "";
            $new_visit->advance_inst = $request->advance != null && $request->advance >0 ? $request->instrument_number : "";

            $new_visit->save();
            $new_visit_id = $new_visit->id_customer_visits;

            //Add Services to the Visit if any
            if(!empty($request->add_services) && count($request->add_services) > 0){
                $add_services = $request->add_services;

                $next_visit_service_start = "";
                foreach($add_services as $service){
                    $service_flag = $service['service_flag'];     
                    $id_service = $service['id_business_services'];
                    $service_name = $service['service_name'];
                    $id_service_type = $service['id_service_types'];
                    $type_name = $service['type_name'];
                    $id_service_category = $service['id_service_category'];
                    $category_name = $service['category_name'];
                    $service_price = $service['service_price'];

                    $visit_date = $service['service_start_time'] ?? $visit_date;

                    if($service_flag == "servicetype"){
                        $service_details = Services::select('id_business_services', 'service_name', 'id_service_types', 'id_service_category', 
                        'service_type', 'service_category', 'service_duration', 'service_rate', 'business_services.business_id', 'business.business_closing_time')
                        ->join('service_category', 'service_category.id_service_category', '=', 'business_services.service_category_id')
                        ->join('service_type', 'service_type.id_service_types', '=', 'service_category.service_type_id')
                        ->join('business', 'business.id_business', '=', 'business_services.business_id')
                        ->where('id_business_services', '=', $id_service)
                        ->where('id_service_category', '=', $id_service_category)
                        ->where('id_service_types', '=', $id_service_type)
                        ->where('service_active', '=', 'Yes')
                        ->where('service_type_active', '=', 'Yes')
                        ->where('service_category_active', '=', 'Yes')
                        ->first();

                        if(null == $service_details || empty($service_details)){
                            continue;
                        }

                        //Insert into visit_services
                        $new_visit_service = new VisitServices();
                        $new_visit_service->customer_visit_id = $new_visit_id;
                        $new_visit_service->service_id = $service_details->id_business_services;
                        $new_visit_service->service_flag = 'servicetype';
                        $new_visit_service->service_name = $service_details->service_name;
                        $new_visit_service->s_type = $service_details->service_type;
                        $new_visit_service->s_category = $service_details->service_category;
                        // $new_visit_service->s_rate = $service_details->service_rate;
                        $new_visit_service->s_rate = $service_price;
                        $new_visit_service->id_service_type = $service_details->id_service_types;
                        $new_visit_service->id_service_category = $service_details->id_service_category;                
                        // Determine base start
                        $base_start = $next_visit_service_start != "" 
                        ? Carbon::parse($next_visit_service_start) 
                        : Carbon::parse($visit_date);
                        // Service duration
                        list($h, $m, $s) = array_map('intval', explode(':', $service_details->service_duration == "00:00:00" ? "00:15:00" : $service_details->service_duration));
                        
                        // Calculate tentative end
                        $visit_service_end = $base_start->copy()
                            ->addHours($h)
                            ->addMinutes($m)
                            ->addSeconds($s);

                        // Business closing for the same day
                        $business_closing = Carbon::parse(
                            $base_start->format('Y-m-d') . ' ' . $service_details->business_closing_time
                        );
                        // Clamp end time if it exceeds business closing
                        if ($visit_service_end->greaterThan($business_closing)) {
                            // End 5 minutes before closing
                            $visit_service_end = $business_closing->copy()->subMinutes(5);

                            // Start = end - service_duration
                            $base_start = $visit_service_end->copy()
                                ->subHours($h)
                                ->subMinutes($m)
                                ->subSeconds($s);
                        }
                        // Save clamped end
                        $new_visit_service->visit_service_start = $base_start->format('Y-m-d\TH:i:s');  //Insert Start Time                
                        $new_visit_service->visit_service_end = $visit_service_end->format('Y-m-d\TH:i:s'); //Insert End Time
                        // Decide next start for following appointment
                        $next_visit_service_start = $visit_service_end->format('Y-m-d\TH:i:s');
                        $new_visit_service->visit_service_status = 'Active';
                        $new_visit_service->business_id = $business_id;
                        $new_visit_service->promo = $promo != null ? $promo : "No";
                        $new_visit_service->membership = $membership != null ? $membership : "No";
                        $new_visit_service->update_date = Carbon::now();
                        $new_visit_service->save();

                        //Assign the Same Staff as the Visit to this New Service
                        $new_visit_service_staff = new VisitServiceStaff();
                        $new_visit_service_staff->customer_visit_id = $new_visit_id;
                        $new_visit_service_staff->visit_service_id = $new_visit_service->id_visit_services;
                        $new_visit_service_staff->staff_id = $staff_details->id_staff;
                        $new_visit_service_staff->staff_name = $staff_details->staff_fullname;
                        $new_visit_service_staff->visit_service_staff_status = 'Active';
                        $new_visit_service_staff->block_other = 'No';
                        $new_visit_service_staff->requested = $requested;
                        $new_visit_service_staff->business_id = session('business_id');
                        $new_visit_service_staff->save();
                    
                    } else if($service_flag == "packagetype"){
                        $package_details = Services::select('id_business_services', 'service_name', 
                        #'package_services.service_rate', 
                         DB::raw('COALESCE(package_services_business_mapping.price, package_services.service_rate) as service_price'),
                        'service_duration', 'id_package_type', 
                        'package_type.service_type', 'id_package_category', 'package_category.service_category', 'business_services.business_id', 
                        'business.business_closing_time')
                        ->join('package_services', 'package_services.service_id', '=', 'business_services.id_business_services')
                        ->join('package_category', 'package_category.id_package_category', '=', 'package_services.package_category_id')
                        ->join('package_type', 'package_type.id_package_type', '=', 'package_category.package_type_id')
                        ->join('business', 'business.id_business', '=', 'business_services.business_id')
                        ->leftJoin('package_services_business_mapping', function ($join) {
                                $join->on(
                                        'package_services_business_mapping.package_services_id',
                                        '=',
                                        'package_services.id_package_services'
                                    )
                                    ->where(
                                        'package_services_business_mapping.business_id',
                                        session('business_id')
                                    );
                        })
                        ->where('package_services.service_id', '=', $id_service)
                        ->where('package_services.package_category_id', '=', $id_service_category)
                        ->where('package_category.package_type_id', '=', $id_service_type)
                        ->where('service_active', '=', 'Yes')
                        ->where('service_type_active', '=', 'Yes')
                        ->where('service_category_active', '=', 'Yes')
                        ->where('package_services_active', '=', 'Yes')
                        ->where(function ($query) {
                                $query->whereNull('package_services_business_mapping.is_visible')
                                    ->orWhere('package_services_business_mapping.is_visible', 'Yes');
                            })
                        ->first();
                        
                        if(null == $package_details || empty($package_details)){
                            // return response()->json([           
                            //     "message" => "Package Service Not Found for Service ID ".$id_service.", Category ID ".$id_service_category.", Type ID ".$id_service_type,      
                            //     "message_type" => "error",
                            //     "message_btn" => "danger"
                            // ]);
                            continue;
                        }

                        //Insert into visit_services
                        $new_visit_service = new VisitServices();
                        $new_visit_service->customer_visit_id = $new_visit_id;
                        $new_visit_service->service_id = $package_details->id_business_services;
                        $new_visit_service->service_flag = 'packagetype';
                        $new_visit_service->service_name = $package_details->service_name;
                        $new_visit_service->s_type = $package_details->service_type;
                        $new_visit_service->s_category = $package_details->service_category;
                        $new_visit_service->s_rate = $package_details->service_price;
                        // $new_visit_service->s_rate = $service_price;
                        $new_visit_service->id_service_type = $package_details->id_package_type;
                        $new_visit_service->id_service_category = $package_details->id_package_category;        
                            
                        // Determine base start
                        $base_start = $next_visit_service_start != "" ? Carbon::parse($next_visit_service_start) : Carbon::parse($visit_date);                    

                        // Service duration
                        list($h, $m, $s) = array_map('intval', explode(':', $package_details->service_duration == "00:00:00" ? "00:15:00" : $package_details->service_duration));
                        // Calculate tentative end
                        $visit_service_end = $base_start->copy()
                            ->addHours($h)
                            ->addMinutes($m)
                            ->addSeconds($s);
                        // Business closing for the same day
                        $business_closing = Carbon::parse(
                            $base_start->format('Y-m-d') . ' ' . $package_details->business_closing_time
                        );
                        // Clamp end time if it exceeds business closing
                        if ($visit_service_end->greaterThan($business_closing)) {
                            // End 5 minutes before closing
                            $visit_service_end = $business_closing->copy()->subMinutes(5);

                            // Start = end - service_duration
                            $base_start = $visit_service_end->copy()
                                ->subHours($h)
                                ->subMinutes($m)
                                ->subSeconds($s);
                        }
                        // Save clamped end
                        $new_visit_service->visit_service_start = $base_start->format('Y-m-d\TH:i:s');  //Insert Start Time                
                        $new_visit_service->visit_service_end = $visit_service_end->format('Y-m-d\TH:i:s'); //Insert End Time
                        // Decide next start for following appointment
                        $next_visit_service_start = $visit_service_end->format('Y-m-d\TH:i:s');
                        $new_visit_service->visit_service_status = 'Active';
                        $new_visit_service->business_id = $business_id;
                        $new_visit_service->promo = $promo != null ? $promo : "No";
                        $new_visit_service->membership = $membership != null ? $membership : "No";
                        $new_visit_service->update_date = Carbon::now();
                        $new_visit_service->save();

                        //get staff details (if booking is sending staff id in service details then use different ids)
                        if(isset($service['staff_id'])){
                            $get_staff_id = $service['staff_id'];
                        } else {
                            $get_staff_id = $staff_id;
                        }
                        $staff_details = Staff::where('id_staff', $get_staff_id)->first();

                        //Assign the Same Staff as the Visit to this New Service
                        $new_visit_service_staff = new VisitServiceStaff();
                        $new_visit_service_staff->customer_visit_id = $new_visit_id;
                        $new_visit_service_staff->visit_service_id = $new_visit_service->id_visit_services;
                        $new_visit_service_staff->staff_id = $staff_details->id_staff;
                        $new_visit_service_staff->staff_name = $staff_details->staff_fullname;
                        $new_visit_service_staff->visit_service_staff_status = 'Active';
                        $new_visit_service_staff->block_other = 'No';
                        $new_visit_service_staff->requested = $requested;
                        $new_visit_service_staff->business_id = $business_id;
                        $new_visit_service_staff->save();
                    }
                } // end foreach services
                
                DB::commit(); //Commit the transaction
                $dispatchRequestService = new dispatchRequestService();
                $drResponse = $dispatchRequestService->createDispatchRequest($new_visit_id);     
                // JSON → array
                $dr = $drResponse->getData(true);
                if (!($dr['success'])) {
                    DB::rollBack();
                    return response()->json([
                        'success'      => false,
                        'message'      => $dr['message'] ?? 'Dispatch request failed.',
                        'message_type' => 'error',
                        'message_btn'  => 'btn btn-danger',
                    ]);
                }

                log::info('Dispatch Request for Visit ID: '.$new_visit_id. ' '. $drResponse);
                    
                return response()->json([           
                        "message" => "Visit Created with ID ".$new_visit_id,            
                        "message_type" => "success",
                        "message_btn" => "success",
                        "new_visit_id" => $new_visit_id
                    ]);
                    
            } else {
                DB::rollBack(); //Rollback the transaction
                return response()->json([           
                    "message" => "Services Not Added To Visit Created with ID ".$new_visit_id,            
                    "message_type" => "error",
                    "message_btn" => "danger",
                    "new_visit_id" => $new_visit_id
                ]);
            }
                    
        } catch(\Exception $e){
            DB::rollBack(); //Rollback the transaction
            return response()->json([           
                "message" => "Error Occurred: ".$e->getMessage(),            
                "message_type" => "error",
                "message_btn" => "danger"
            ]);
        }         
    }  

    function get_discount_reasons(Request $request){
        $business_id = session('business_id');
        $discounts_list = Discount::select('*')        
        ->where('discount_reasons.active','=','Yes')
        ->where('business_id','=',$business_id)
        ->get();

        return response()->json(
            [
                "discountList" => $discounts_list
            ]);
    }

    public function open_advance_receipt($visit_id){
        //return $visit_id;
        $visit = CustomerVisits::find($visit_id);
        if (!$visit) {
            return redirect()->back()->with('error', 'Visit not found.');
        }

        $visit_advance = VisitAdvance::select('visit_advance.*',
        'customer_visits.id_customer_visits', 'customer_visits.visit_status', 'customer_visits.created_by as visit_created_by',
         'customers.customer_name', 'customers.customer_cell', 'customers.customer_area', 'customer_visits.discount',
        'customers.customer_email',
         'id_business', 'business_name', 'business_logo', 'business_address', 'business.payment_terms', 'business.invoice_terms',
        DB::RAW("date_format(visit_advance.advance_date, '%d-%m-%Y %H:%s') as formatted_advance_date"),
        DB::RAW("date_format(customer_visits.customer_visit_date, '%d-%m-%Y %H:%s') as formatted_visit_date")
        )
        ->join("customer_visits", "customer_visits.id_customer_visits", "=", "visit_advance.customer_visit_id")
        ->join("customers", "customers.id_customers","=","customer_visits.customer_id")
        ->join("business", "business.id_business","=","customer_visits.business_id")
        ->where('customer_visits.id_customer_visits', "=", $visit_id)
        ->where('visit_advance.advance_status','=', 'Active')
        ->get();


        $visit_services = VisitServices::select("*")
        ->where("visit_services.customer_visit_id", "=", $visit_id)
        ->where("visit_services.visit_service_status", "=", "Active")
        ->get();

        // Assuming we have a view named 'visits.advance_receipt'
        return view('visits.advance_receipt', compact('visit_advance', 'visit_services'));
    }

    public function handle_visit_cancellation_advance($id_customer_visits, $visit_status){        
        //Check if there are any advances
        try{
            
            $visit_advance = VisitAdvance::select('visit_advance.*', 'customer_visits.id_customer_visits', 'customer_visits.customer_id', 'customers.customer_name')
            ->where('customer_visit_id', '=', $id_customer_visits)
            ->join ('customer_visits', 'customer_visits.id_customer_visits', '=', 'visit_advance.customer_visit_id')
            ->join ('customers', 'customers.id_customers', '=', 'customer_visits.customer_id')
            ->where('advance_status', '=', 'Active')
            ->get();
            
            
            $business_id = $visit_advance->first()->business_id ?? session('business_id');

            if($visit_status == "cancelVisitRetainAdv"){
                //Retain Advance and Deactivate Advance Record
                if(null != $visit_advance && count($visit_advance) >0){
                    if(session('ho_accounts')=='Yes'){
                        $common_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                    } else {
                        $common_business_id = $business_id;
                    }
                    //get account event mapping from event 1
                    $account_event = AccountEventMapping::where('business_id', '=', $common_business_id)
                    ->where('account_event_id', '=', 1) //Advance Payment
                    ->whereIn('entity_name', ['advance_adjusted', 'retained_amount'])
                    ->get();
                    $retained_account = $account_event->where('entity_name', '=', 'retained_amount')->first();
                    $advance_account = $account_event->where('entity_name', '=', 'advance_adjusted')->first();

                    foreach($visit_advance as $advance){
                        //Create Negative Voucher for the Advance Amount
                        $new_voucher = new AccountVouchers();
                        $new_voucher->business_id = $business_id;
                        $new_voucher->business_partner_id = $advance->customer_id;
                        $new_voucher->business_partner = 1; //Customer
                        $new_voucher->business_partner_name = $advance->customer_name;
                        $new_voucher->visit_id = $advance->customer_visit_id;
                        $new_voucher->payment_mode = 'Cash';
                        $new_voucher->visit_id = $advance->id_customer_visits;
                        $new_voucher->visit_advance_id = $advance->id_visit_advance;
                        $new_voucher->cost_center = 1;
                        $new_voucher->cost_center_name = 'Front Desk';
                        $new_voucher->voucher_type = "3";
                        $new_voucher->voucher_date = Carbon::now();               
                        $new_voucher->voucher_status = "Active";
                        $new_voucher->description = "Retained Advance for Visit ID ".$advance->customer_visit_id;
                        $new_voucher->created_by = session('user_name');
                        $new_voucher->save();
                    
                    //create voucher detail
                        $voucher_detail = new AccountVoucherDetail();
                        $voucher_detail->account_voucher_id = $new_voucher->id_account_vouchers;
                        $voucher_detail->account_head_id = $advance_account->account_head_id;               
                        $voucher_detail->debit = $advance->advance_amount;
                        $voucher_detail->credit = 0.00;
                        $voucher_detail->save();

                        $voucher_detail2 = new AccountVoucherDetail();
                        $voucher_detail2->account_voucher_id = $new_voucher->id_account_vouchers;
                        $voucher_detail2->account_head_id = $retained_account->account_head_id;               
                        $voucher_detail2->debit = 0.00;
                        $voucher_detail2->credit = $advance->advance_amount;
                        $voucher_detail2->save();
                    }
                }
            } elseif($visit_status == "cancelVisitReturnAdv"){
                //Refund Advance and Deactivate Advance Record
                if(null != $visit_advance && count($visit_advance) >0){
                    if(session('ho_accounts')=='Yes'){
                        $common_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                    } else {
                        $common_business_id = $business_id;
                    }
                    //get account event mapping from event 1
                    $account_event = AccountEventMapping::where('business_id', '=', $common_business_id)
                    ->where('account_event_id', '=', 1) //Advance Payment
                    ->whereIn('entity_name', ['advance_adjusted', 'paid_cash'])
                    ->get();
                    $cash_account = $account_event->where('entity_name', '=', 'paid_cash')->first();
                    $advance_account = $account_event->where('entity_name', '=', 'advance_adjusted')->first();

                    foreach($visit_advance as $advance){
                        //Create Negative Voucher for the Advance Amount
                        $new_voucher = new AccountVouchers();
                        $new_voucher->business_id = $business_id;
                        $new_voucher->business_partner_id = $advance->customer_id;
                        $new_voucher->business_partner = 1; //Customer
                        $new_voucher->business_partner_name = $advance->customer_name;                
                        $new_voucher->payment_mode = 'Cash';
                        $new_voucher->visit_id = $advance->id_customer_visits;
                        $new_voucher->visit_advance_id = $advance->id_visit_advance;
                        $new_voucher->cost_center = 1;
                        $new_voucher->cost_center_name = 'Front Desk';                
                        $new_voucher->voucher_type = "1";
                        $new_voucher->voucher_date = Carbon::now();               
                        $new_voucher->voucher_status = "Active";
                        $new_voucher->description = "Refund of Advance for Visit ID ".$advance->customer_visit_id;
                        $new_voucher->created_by = session('user_name');
                        $new_voucher->save();
                        
                        //create voucher detail
                        $voucher_detail = new AccountVoucherDetail();
                        $voucher_detail->account_voucher_id = $new_voucher->id_account_vouchers;
                        $voucher_detail->account_head_id = $advance_account->account_head_id;               
                        $voucher_detail->debit = $advance->advance_amount;
                        $voucher_detail->credit = 0.00;
                        $voucher_detail->save();

                        $voucher_detail2 = new AccountVoucherDetail();
                        $voucher_detail2->account_voucher_id = $new_voucher->id_account_vouchers;
                        $voucher_detail2->account_head_id = $cash_account->account_head_id;               
                        $voucher_detail2->debit = 0.00;
                        $voucher_detail2->credit = $advance->advance_amount;
                        $voucher_detail2->save();
                    }
                }
            } elseif($visit_status == "cancelVisitKeepAdv"){
                //Save advance as Sale Income through Account Voucher
                if(null != $visit_advance && count($visit_advance) >0){

                    if(session('ho_accounts')=='Yes'){
                        $common_business_id = Business::where('business.ho', 'Yes')->value('id_business');
                    } else {
                        $common_business_id = $business_id;
                    }
                    //get account event mapping from event 1
                    $account_event = AccountEventMapping::where('business_id', '=', $common_business_id)
                    ->whereIn('entity_name', ['advance_adjusted', 'grosstotal_service'])
                    ->where('account_event_id', '=', 1) //Advance Payment
                    ->first();
                    $advance_account = $account_event->where('entity_name', '=', 'advance_adjusted')->first();
                    $income_account = $account_event->where('entity_name', '=', 'grosstotal_service')->first();

                    foreach($visit_advance as $advance){
                        //Create Negative Voucher for the Advance Amount
                        $new_voucher = new AccountVouchers();
                        $new_voucher->business_id = $business_id;
                        $new_voucher->business_partner_id = $advance->customer_id;
                        $new_voucher->business_partner = 1; //Customer
                        $new_voucher->business_partner_name = $advance->customer_name;
                        $new_voucher->visit_id = $advance->customer_visit_id;
                        $new_voucher->payment_mode = 'Cash';
                        $new_voucher->visit_id = $advance->id_customer_visits;
                        $new_voucher->visit_advance_id = $advance->id_visit_advance;
                        $new_voucher->cost_center = 1;
                        $new_voucher->cost_center_name = 'Front Desk';
                        $new_voucher->voucher_type = "3";
                        $new_voucher->voucher_date = Carbon::now();               
                        $new_voucher->voucher_status = "Active";
                        $new_voucher->description = "Advance Adjusted as Income for Visit ID ".$advance->customer_visit_id;
                        $new_voucher->created_by = session('user_name');
                        $new_voucher->save();
                        
                        //create voucher detail
                        $voucher_detail = new AccountVoucherDetail();
                        $voucher_detail->account_voucher_id = $new_voucher->id_account_vouchers;
                        $voucher_detail->account_head_id = $income_account->account_head_id; //Sales Income               
                        $voucher_detail->debit = 0.00;
                        $voucher_detail->credit = $advance->advance_amount;
                        $voucher_detail->save();

                        $voucher_detail2 = new AccountVoucherDetail();
                        $voucher_detail2->account_voucher_id = $new_voucher->id_account_vouchers;
                        $voucher_detail2->account_head_id = $advance_account->account_head_id; //Advannce Adjusted               
                        $voucher_detail2->debit = $advance->advance_amount;
                        $voucher_detail2->credit = 0.00;
                        $voucher_detail2->save();
                    }
                }
            }
           
            return "success";
        } catch (\Exception $e) {           
           
            return "error ".$e;
        }

    }

    public function get_day_visits_by_status(Request $request){
        $business_id = $request->business_id ?? session('business_id');
        $status = $request->status ?? ['open'];
        $for_day = $request->for_day ?? date('Y-m-d');

        $currently_open_visits = CustomerVisits::select(
            DB::RAW('id_customer_visits as id'),
            DB::RAW('CONCAT(customer_name, " @ ", business_name) as text'),
            DB::RAW('customer_visits.created_by'),
            DB::RAW('date_format(MIN(visit_services.visit_service_start), "%H:%i") as service_time'),
        )
         ->join('visit_services', function ($join) {
            $join->on('visit_services.customer_visit_id', '=', 'customer_visits.id_customer_visits')
                ->where('visit_services.visit_service_status', '=', 'Active');
        })
        ->join('customers', 'customers.id_customers', '=', 'customer_visits.customer_id')
        ->join('business', 'business.id_business', '=', 'customer_visits.business_id')
        ->where('customer_visits.business_id', '=', $business_id)
        ->whereIn('visit_status', $status)
        ->whereDate('visit_services.visit_service_start', '=', $for_day)
        ->groupBy('id_customer_visits')
        ->orderBy('id_customer_visits', 'ASC')
        ->get();

        return response()->json(['currently_open_visits' => $currently_open_visits]);
    }

    public function get_visit_services($visit_id){

        $visit_services = VisitServices::select(
            DB::RAW('visit_services.id_visit_services as id'),
            DB::RAW('visit_services.service_name as text'),
            DB::RAW('date_format(visit_services.visit_service_start, "%d-%m-%Y %H:%i") as visit_service_start'),
            DB::RAW('date_format(visit_services.visit_service_end, "%H:%i") as visit_service_end'),
            DB::RAW('GROUP_CONCAT(visit_service_staffs.staff_name) as staff')
            )
        ->join('visit_service_staffs', function ($join) {
            $join->on('visit_service_staffs.visit_service_id', '=', 'visit_services.id_visit_services')         
                ->where('visit_service_staffs.visit_service_staff_status', '=', 'Active');
            })
        ->where('visit_services.customer_visit_id', '=', $visit_id)
        ->where('visit_service_status', '=', 'Active')
        ->groupBy('visit_services.id_visit_services')
        ->orderBy('visit_services.visit_service_start', 'ASC')
        ->get();

        return response()->json(['visit_services' => $visit_services]);
    }

    public function search_visits(Request $request){
        $business_id = session('business_id');
        $term = $request->input('term', '');
        $status = $request->input('status', 'open');
        $start = $request->input('start');
        $end = $request->input('end');

        $visits = CustomerVisits::select(
            'id_customer_visits as id', 
            DB::RAW('CONCAT(customer_name, " - ", business_name) as text'),
            DB::RAW('customer_visit_date'), 
            'visit_status'
        )
       ->join('visit_services', function ($join) {
            $join->on('visit_services.customer_visit_id', '=', 'customer_visits.id_customer_visits')
                ->where('visit_services.visit_service_status', '=', 'Active');
        })
        ->join('customers', 'customers.id_customers', '=', 'customer_visits.customer_id')
        ->join('business', 'business.id_business', '=', 'customer_visits.business_id')        
            ->where('business_id', '=', $business_id)
            ->where(function($query) use ($term) {
                $query->where('id_customer_visits', 'LIKE', '%' . $term . '%')
                      ->orWhere('customer_visit_date', 'LIKE', '%' . $term . '%')
                      ->orWhere('visit_status', 'LIKE', '%' . $term . '%');
            });
        if($start != ''){
            $visits = $visits->where('visit_services.visit_service_start', '>=', $start);
        }
        if($end != ''){
            $visits = $visits->where('visit_services.visit_service_end', '<=', $end);
        }
        if($status != '') {
            $visits = $visits->where('visit_status', '=', $status);
        }
        $visits = $visits->groupBy('id_customer_visits');            
        $visits = $visits->orderBy('id_customer_visits', 'DESC')            
        ->get();

        $results = [];
        foreach ($visits as $visit) {
            $results[] = [
                'id' => $visit->id_customer_visits,
                'text' => $visit->customer_name . ' | Date: ' . $visit->customer_visit_date . ' | Status: ' . $visit->visit_status,
            ];
        }

        return response()->json([
            'results' => $results,           
         ]);
    }
}