<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Menu;

class CheckRoutePermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $routeName = $request->route()?->getName();
        $path = $request->path();

        // Exclude login and logout routes from permission checks
        $excludedRoutes = ['login', 'logout'];
        $excludedPaths = ['login', 'logout', 'auth/logout'];
        
        if (in_array($routeName, $excludedRoutes) || in_array($path, $excludedPaths)) {
            return $next($request);
        }

        $segments = $request->segments();

        $menu = Menu::whereNotNull('permission')
        ->where(function($q) use ($routeName, $segments) {
                $q->where('route', $routeName)
                ->orWhereJsonContains('route_params', $segments);
            })
            ->first();
            
        // dd($routeName, $segments, $menu, auth()->user());

        if ($menu && !auth()->user()->can($menu->permission)) {
            return response()->view('error.403', [], 403);
        }

        return $next($request);
    }
}
