<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\RestKey;

class VerifyApiKey
{
    /**
     * Handle an incoming request.
     * 
     * Validates the SKED-API-KEY header against the rest_keys table.
     * Returns "Invalid Access" string if validation fails (matching legacy behavior).
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $apiKey = $request->header('SKED-API-KEY');

        if (!$apiKey) {
            return response()->json("Authentication required", 401);
        }

        $key = RestKey::findByKey($apiKey);

        if (!$key || !$key->isValid()) {
            return response()->json("Authentication failed", 401);
        }

        // Store the key in the request for use in controllers if needed
        $request->attributes->set('api_key', $key);

        return $next($request);
    }
}
