<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class AccountControl extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'account_control'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_account_control';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'account_control',
       'account_control_number',
       'account_main_id',
       'business_id',
       'created_on',
       'account_control_status',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function accountMain()
    {
         return $this->belongsTo(AccountMain::class, 'account_main_id', 'id_account_main');
    }
}
