<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class AccountEventMapping extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'account_event_mapping'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_account_event_mapping';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'account_event_id',
        'account_head_id',
        'business_id',
        'transaction_type',
        'mapped_on',
        'entity_name',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }


    public function account_events()
    {
         return $this->belongsTo(AccountEvents::class, 'business_id', 'id_business');
    }   

}
