<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class AccountHeads extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'account_heads'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_account_heads';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'account_sub_control_id',
       'created_on',
       'account_head',
       'account_type',
       'account_sub_type',
       'account_head_number',
       'business_id',
       'till_account',
       'account_head_status',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function accountSubControl()
    {
         return $this->belongsTo(AccountSubControl::class, 'account_sub_control_id', 'id_account_sub_control');
    }
}
