<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class AccountSubControl extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'account_sub_control'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_account_sub_control';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'account_sub_control',
       'account_sub_control_number',
       'account_control_id',
       'business_id',
       'created_on',
       'account_sub_control_status',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function accountControl()
    {
         return $this->belongsTo(AccountControl::class, 'account_control_id', 'id_account_control');
    }
}
