<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class AccountVoucherDetail extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'account_voucher_detail'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_account_voucher_detail';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        
        'account_voucher_id',
        'account_head_id',
        'debit',
        'credit',
        'created_date',
        'cost_center_type',
        'cost_center',
        'instrument_number',
        'detail_remarks',
        'payment_mode'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function account_vouchers()
    {
         return $this->belongsTo(AccountVouchers::class, 'account_voucher_id', 'id_account_vouchers');
    }

}
