<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class AccountVouchers extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'account_vouchers'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_account_vouchers';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id_account_head',
        'business_id',
        'description',
        'voucher_amount',
        'voucher_date',
        'created_by',
        'created_on',
        'voucher_status',
        'voucher_type',
        'cost_center',
        'cost_center_name',
        'business_partner',
        'business_partner_id',
        'business_partner_name',
        'bank_name',
        'payment_mode',
        'purchase_order_id',
        'grn_id',
        'invoice_id',
        'auto_voucher',
        'cancelled_by',
        'cancelled_on',
        'sale_type',
        'order_voucher_id',
        'visit_id',
        'visit_advance_id',
        'dispatch_id',
        'program_invoice_id',
        'return_note_id',
        'adjustment_id',
        'gtn_id',
        'franchise_order_id',
        'cashregister_id',
        'staffpayment_id',
        'program_enrolled_service_id',
        'program_enrollment_id',
        'program_invoice_payment_id',
        'loan_application_id',
        'transfer_voucher_id',
        'franchise_return_note_id',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

}
