<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class AdjustmentNotes extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'adjustment_notes'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_adjustment_notes';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'batch_id',
        'product_id',
        'adjustment_qty',
        'adjustment_date',
        'adjustment_remarks',
        'unit_price',
        'created_by',
        'created_on',
        'adjustment_order_id',
        ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function batch()
    {
        return $this->belongsTo(ProductBatch::class, 'batch_id', 'id_batch'); // assuming PK of product_batch table is `id_batch`
    }

    public function products()
    {
        return $this->hasMany(Products::class, 'id_business_products', 'product_id'); 
    }

}
