<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Attendance extends Model
{
    protected $table = 'attendance_request';
    protected $primaryKey = 'id_attendance_request';
    
    protected $fillable = [
        'staff_id',
        'business_id',
        'request_date',
        'request_time_in',
        'request_time_out',
        'address',
        'request_status',
        'approved_by'
    ];
    
    protected $casts = [
        'request_date' => 'date',
    ];
    
    public function staff()
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id_staff');
    }
    
    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }
}