<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class BlockStaffTime extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'block_staff_time'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_staff_time_blocked';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'block_event_id',
        'block_time_event_id',
        'staff_id',
        'staff_name',
        'start_time',
        'end_time',
        'remarks'
        ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of business table is `id_business`
    }

}
