<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'bookings'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_bookings';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'booking_date',
        'customer_id',
        'business_id',
        'package_id',
        'discount'
        ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of product_batch table is `id_batch`
    }

    public function package_type()
    {
        return $this->hasMany(PackageType::class, 'package_id', 'id_package_type'); 
    }

    public function customers()
    {
        return $this->hasMany(Customers::class, 'customer_id', 'id_customers'); 
    }

}
