<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class BookingVisit extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'booking_visits'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_booking_visits';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'booking_id',
        'visit_id',
        'category_id',
        ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function Visits()
    {
        return $this->hasMany(Visit::class, 'visit_id', 'id_visit'); // assuming PK of product_batch table is `id_batch`
    }

    public function package_category()
    {
        return $this->hasMany(PackageCategory::class, 'category_id', 'id_package_category'); 
    }

}
