<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Brands extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'business_brands'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_business_brands';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'supplier_id',
        'business_id',
        'business_brand_name',
        'business_brand_short',
        'business_brand_website',
        'business_brand_active',
        ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of business table is `id_business`
    }

    public function products()
    {
        return $this->hasMany(Products::class, 'id_business_brands', 'brand_id'); 
    }

}
