<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Business extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'business'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_business';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
    'business_type_id',
    'business_name',
    'business_address',
    'business_area',
    'business_logo',
    'business_email',
    'business_email_password',
    'business_phone1',
    'business_phone2',
    'business_phone3',
    'business_phone4',
    'business_owner',
    'business_owner_contact',
    'payment_terms',
    'business_opening_time',
    'business_closing_time',
    'scheduler_style',
    'scheduler_input_search',
    'tax_optional',
    'rec_allow_prev',
    'l_point_value',
    'l_point_discount',
    'loyalty_enable',
    'staff_stats',
    's_loyalty',
    'r_loyalty_enable',
    'shifts',
    'show_staff',
    'period_booking',
    'loyalty_mode',
    'loyalty_sms',
    'show_professional',
    'walkin_enable',
    'cc_charge',
    'force_extra_record',
    'discount_pw',
    'long',
    'lat',
    'gym',
    'programs',
    'training',
    'show_cash_reg',
    'pos_enabled',
    'allow_stock_update',
    'allow_price_update',
    'recurring',
    'multibranchpo',
    'admin_notifications',
    'ho',
    'show_points',
    'show_amount',
    'b_switch',
    'common_products',
    'invoicenumber',
    'sh_hide',
    'auto_vouchers',
    'till_closing',
    'tax_mode',
    'hide_cell',
    'invoice_terms',
    'fineprint',
    'imsfiscal',
    'imsfiscal_r',
    'invoiced_drag',
    'qr_enabled',
    'timein_margin',
    'coaching',
    'allow_balance',
    'loyalty_otp',
    'srb_fiscal_service',
    'srb_fiscal_sale',
    'allow_invoice_cancel',
    'receipts_installed',
    'page_1',
    'backdated_invoice',
    's_min_sh',
    'common_services',
    'ho_accounts',
    'flexi_pricing_enabled',
];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    // public function user()
    // {
    //     return $this->belongsToMany(User::class, 'business_id');
    // }

   

}
