<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class BusinessTargets extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'business_targets';
    protected $primaryKey = 'id_business_targets';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',    
        'target_type',    
        'year',    
        'month',    
        'amount',    
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }
}
