<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BusinessTimeslot extends Model
{
    protected $table = 'business_timeslots';
    protected $primaryKey = 'id_business_timeslots';
    
    protected $fillable = [
        'business_id',
        'timeslot_name',
        'start_time',
        'end_time',
        'order',
        'active',
    ];

    protected $casts = [
        'start_time' => 'datetime:H:i',
        'end_time' => 'datetime:H:i',
        'active' => 'integer',
        'order' => 'integer',
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function pricingBands()
    {
        return $this->hasMany(PricingBand::class, 'timeslot_id', 'id_business_timeslots');
    }
}

