<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CashRegister extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'cash_register'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_cash_register';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'till_amounts',
        'business_id',
        'x5000',
        'x1000',
        'x500',
        'x100',
        'x75',
        'x50',
        'x20',
        'x10',
        'x5',
        'x1',
        'difference',
        'daily_expense',
        'remarks',
        'cash_register_date',
        'cash_addition',
        'register_status',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
       
    ];


    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

   

}
