<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CategoryMapping extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'category_mapping';
    protected $primaryKey = 'id_mapping';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'mapping_name',
        'business_id',
        'active',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'active' => 'integer',
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function categoryMappingPackages()
    {
        return $this->hasMany(CategoryMappingPackage::class, 'mapping_id', 'id_mapping');
    }

    public function mappingFloors()
    {
        return $this->hasMany(MappingFloor::class, 'mapping_id', 'id_mapping');
    }

    public function pricingBands()
    {
        return $this->hasMany(PricingBand::class, 'mapping_id', 'id_mapping');
    }

    public function packageCategories()
    {
        return $this->belongsToMany(PackageCategory::class, 'category_mapping_packages', 'mapping_id', 'package_category_id');
    }
}

