<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CategoryMappingPackage extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'category_mapping_packages';
    protected $primaryKey = 'id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'mapping_id',
        'package_category_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function categoryMapping()
    {
        return $this->belongsTo(CategoryMapping::class, 'mapping_id', 'id_mapping');
    }

    public function packageCategory()
    {
        return $this->belongsTo(PackageCategory::class, 'package_category_id', 'id_package_category');
    }
}

