<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CityAreas extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'city_areas'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_city_area';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'city_area',
        'city_id',
        'city',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function cities()
    {
        return $this->belongsTo(Cities::class, 'city_id', 'id_cities');
    }

   

}
