<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ColorRecords extends Model
{
    use HasFactory;
    protected $table = 'color_records';
    protected $primaryKey = 'id';

    protected $fillable = [
        'business_id',
        'customer_visit_id',
        'customer_id',
        'customer',
        'color_type_id',
        'color_type',
        'color_number_id',
        'color_number',
        'time',
        'charge',
        'remarks',
        'date',
        'created_on',
        'water_content',
        'recommendation',
    ];

    public function customers()
    {
         return $this->belongsTo(Customers::class, 'customer_id', 'id_customers');
    } 

}
